.       \" XP - exdented paragraph
.de XP
.RT
.if \\n(1T .sp \\n(PDu
.ne 1.1
.if !\\n(IP .nr IP +1
.in +\\n(I\\n(IRu
.ti -\\n(I\\n(IRu
..
.\" Copyright (c) 1986 Ed James. All rights reserved. 
.\"
.TH ATC 6 "January 1, 1986"
.UC
.SH NAME
atc \- Air Traffic Controller Game
.SH SYNOPSIS
.B atc
-[u?lstp] [-[gf] game_name] [-r random seed]
.SH DESCRIPTION
.LP
.I Atc
lets you try your hand at the nerve wracking duties of the air traffic
controller without endangering the lives of millions of
travelers each year.
Your responsibilities require you to direct the flight of jets
and prop planes into and out of the flight arena and airports.
The speed (update time) and frequency of the planes depend on the
difficulty of the chosen arena.
.SH OPTIONS
.LP
.TP 8
.B \-u
Print the usage line and exit.
.TP
.B \-?
Same as
.B \-u.
.TP
.B \-l
Print a list of available games and exit.
The first game name printed is the default game.
.TP
.B \-s
Print the score list (formerly the Top Ten list).
.TP
.B \-t
Same as
.B \-s.
.TP
.B \-p
Print the path to the special directory where 
.I atc
expects to find its private files.  This is used during the
installation of the program.
.TP
.B "\-g game"
Play the named game.  If the game listed is not one of the
ones printed from the 
.B \-l
option, the default game is played.
.TP
.B "\-f game"
Same as
.B \-g.
.TP
.B "\-r seed"
Set the random seed.  The purpose of this flag is questionable.
.SH GOALS
.LP
Your goal in 
.I atc
is to keep the game going as long as possible.  
There is no winning state, except to beat the times of other players.
You will need to: launch planes at airports (by instructing them to
increase their altitude); land planes at airports (by instructing them to
go to altitude zero when exactly over the airport); and maneuver planes
out of exit points.  
.LP
Several things will cause the end of the game.
Each plane has a destination (see information area), and 
sending a plane to the wrong destination is an error.
Planes can run out of fuel, or can collide.  Collision is defined as
adjacency in any of the three dimensions.  A plane leaving the arena
in any other way than through its destination exit is an error as well.
.LP
Scores are sorted in order of the number of planes safe.  The other
statistics are provided merely for fun.  There is no penalty for 
taking longer than another player (except in the case of ties).
.LP
Suspending a game is not permitted.  If you get a talk message, tough.
When was the last time an Air Traffic Controller got called away to
the phone? 
.SH "THE DISPLAY"
.LP
Depending on the terminal you run 
.I atc
on, the screen will be divided into 4 areas. 
It should be stressed that the terminal driver portion of the
game was designed to be reconfigurable, so the display format can vary
depending the version you are playing.  The descriptions here are based 
on the ascii version
of the game.  The game rules and input format, however,
should remain consistent.
Control-L redraws the screen, should it become muddled.
.SS RADAR
.IP
The first screen area is the radar display, showing the relative locations
of the planes, airports, standard entry/exit points, radar
beacons, and "lines" which simply serve to aid you in guiding
the planes. 
.IP
Planes are shown as a single letter with an altitude.  If
the numerical altitude is a single digit, then it represents
thousands of feet.
Some distinction is made between the prop
planes and the jets.  On ascii terminals, prop planes are
represented by a upper case letter, jets by a lower case letter.
.IP
Airports are shown as a number and some indication of the direction
planes must be going to land at the airport.  
On ascii terminals, this is one of '^', '>', '<', and 'v', to indicate
north (0 degrees), east (90), west (270) and south (180), respectively.
The planes will also
take off in this direction.
.IP
Beacons are represented as circles or asterisks and a number.
Their purpose is to offer a place of easy reference to the plane pilots.
See 'the delay command' under the input section of this manual.
.IP
Entry/exit points are displayed as numbers along the border of the 
radar screen.  Planes will enter the arena from these points without
warning.  These points have a direction associated with them, and 
planes will always enter the arena from this direction.  On the
ascii version of
.I atc,
this direction is not displayed.  It will become apparent
what this direction is as the game progresses.
.IP
Incoming planes will always enter at the same altitude: 7000 feet.
For a plane to successfully depart through an entry/exit point, 
it must be flying at 9000 feet.
It is not necessary for the planes to be flying in any particular
direction when they leave the arena (yet).
.SS "INFORMATION AREA"
.IP
The second area of the display is the information area, which lists
the time (number of updates since start), and the number of planes you
have directed safely out of the arena.
Below this is a list of planes currently in the air, followed by a 
blank line, and then a list of planes on the ground (at airports).
Each line lists the plane name and its current altitude, 
an optional asterisk indicating low fuel, the plane's destination,
and the plane's current command.  Changing altitude is not considered
to be a command and is therefore not displayed.  The following are 
some possible information lines:
.IP
	B4*A0: Circle @ b1
.br
	g7 E4: 225
.IP
The first example shows a prop plane named 'B' that is flying at 4000
feet.  It is low on fuel (note the '*').  It's destination is
Airport #0.
The next command it expects
to do is circle when it reaches Beacon #1.
The second example shows a jet named 'g' at 7000 feet, destined for 
Exit #4.  It is just now executing a turn to 225 degrees (South-West).
.SS "INPUT AREA"
.IP
The third area of the display is the input area.  It is here that 
your input is reflected.  See the INPUT heading of this manual
for more details.
.SS "AUTHOR AREA"
.IP
This area is used simply to give credit where credit is due. :-)
.SH INPUT
.LP
A command completion interface is built into
the game.  At any time, typing '?' will list possible input characters.
Typing a backspace (your erase character) backs up, erasing the last part
of the command.  When a command is complete, a return enters it, and 
any semantic checking is done at that time.  If no errors are detected,
the command is sent to the appropriate plane.  If an error is discovered
during the check, the offending statement will be underscored and a
(hopefully) descriptive message will be printed under it.
.LP
The command syntax is broken into two parts:
.I "Immediate Only"
and 
.I Delayable
commands.
.I "Immediate Only"
commands happen on the next
update.  
.I Delayable
commands also happen on the next update unless they
are followed by an optional predicate called the 
.I Delay 
command.
.LP
In the following tables, the syntax 
.B [0\-9]
means any single digit, and 
.B <dir>
refers to the keys around the 's' key, namely ``wedcxzaq''.
In absolute references, 'q' refers to North-West or 315 degrees, and 'w'
refers to North, or 0 degrees.  
In relative references, 'q' refers to -45 degrees or 45 degrees left, and 'w'
refers to 0 degrees, or no change in direction.
.LP
All commands start with a plane letter.  This indicates the recipient
of the command.  Case is ignored.
.SS "IMMEDIATE ONLY COMMANDS"
.RS
.B "\- a Altitude:"
.RS
Affect a plane's altitude (and take off).
.RE
.RS
.B "\- [0\-9] Number:"
.RS
Go to the given altitude (thousands of feet).
.RE
.B "\- c/+ Climb:"
.RS
Relative altitude change.
.RE
.RS
.B "\- [0\-9] Number:"
.RS
Difference in thousands of feet.
.RE
.RE
.B "\- d/\- Descend:"
.RS
Relative altitude change.
.RE
.RS
.B "\- [0\-9] Number:"
.RS
Difference in thousands of feet.
.RE
.RE
.RE
.B "\- m Mark:"
.RS
Display in highlighted mode.  Command is displayed normally.
.RE
.B "\- i Ignore:"
.RS
Do not display highlighted.  Command is displayed as a
line of dashes if there is no command.
.RE
.B "\- u Unmark:"
.RS
Same as ignore, but if a delayed command is processed, 
the plane will become marked.  This is useful if you want
to forget about a plane during part, but not all, of its
journey.
.RE
.RE
.SS "DELAYABLE COMMANDS"
.RS
.B "\- c Circle:"
.RS
Have the plane circle (clockwise by default).
.RE
.RS
.B "\- l Left:"
.RS
Circle counterclockwise.
.RE
.B "\- r Right:"
.RS
Circle clockwise.
.RE
.RE
.B "\- t Turn:"
.RS
Change direction.
.RE
.RS
.B "\- l Left:"
.RS
Turn counterclockwise (45 degrees by default).
.RE
.RS
.B "\- <dir> Direction:"
.RS
Turn ccw the given number of degrees.
Zero degrees is no turn.  A ccw turn
of -45 degrees is 45 cw.
.RE
.RE
.B "\- r Right:"
.RS
Turn clockwise (45 degrees by default).
.RE
.RS
.B "\- <dir> Direction:"
.RS
Same as turn left <dir>.
.RE
.RE
.B "\- L Left 90:"
.RS
Turn counterclockwise 90 degrees.
.RE
.B "\- R Right 90:"
.RS
Turn clockwise 90 degrees.
.RE
.B "\- <dir> Direction:"
.RS
Turn to the absolute compass heading given.
The shortest turn will be taken.
.RE
.B "\- t Towards:"
.RS
Turn towards a beacon, airport or exit.  The turn is
just an estimate.
.RE
.RS
.B "\- b/* Beacon:"
.RS
Turn towards the beacon.
.RE
.RS
.B "\- [0-9] Number:"
.RS
The beacon number.
.RE
.RE
.B "\- e Exit:"
.RS
Turn towards the exit.
.RE
.RS
.B "\- [0-9] Number:"
.RS
The exit number.
.RE
.RE
.B "\- a Airport:"
.RS
Turn towards the airport.
.RE
.RS
.B "\- [0-9] Number:"
.RS
The airport number.
.RE
.RE
.RE
.RE
.RE
.SS THE DELAY COMMAND
.LP
The 
.B Delay
(a/@)
command may be appended to any 
.B Delayable 
command.  It allows the controller to instruct a plane to do an action
when the plane reaches a particular beacon (or other objects in future
versions).
.sp
.RS
.B "\- a/@ At:"
.RS
Do the given delayable command when the plane reaches the given beacon.
.RE
.RS
.B "\- b/* Beacon:"
.RS
This is redundant to allow for expansion.
.RE
.RS
.B "\- [0-9] Number:"
.RS
The beacon number.
.RE
.RE
.RE
.RE
.SS "MARKING, UNMARKING AND IGNORING"
.LP
Planes are 
.B marked
when they enter the arena.  This means they are displayed in highlighted
mode on the radar display.  A plane may also be either 
.B unmarked
or
.B ignored.
An
.B unmarked
plane is drawn in unhighlighted mode, and a line of dashes is displayed in
the command field of the information area.  The plane will remain this
way until a mark command has been issued.  Any other command will be issued,
but the command line will return to a line of dashes when the command
is completed.  
.LP
An
.B ignored
plane is treated the same as an unmarked plane, except that it will
automatically switch to 
.B marked
status when a delayed command has been processed.  This is useful if
you want to forget about a plane for a while, but its flight path has
not yet been completely set.
.LP
As with all of the commands, marking, unmarking and ignoring will take effect 
at the beginning of the next update.  Do not be surprised if the plane does
not immediately switch to unhighlighted mode.
.SS EXAMPLES
.RS
.TP 16
atlab1
a: turn left at beacon #1
.TP 16
cc
C: circle
.TP 16
gtte4ab2
g: turn towards exit #4 at beacon #2
.TP 16
ma+2
m: altitude: climb 2000 feet
.TP 16
stq
S: turn to 315
.TP 16
xi
x: ignore
.RE
.SH "OTHER INFORMATION"
.LP
Jets move every update; prop planes move every other update.
.LP
All planes turn a most 90 degrees per movement.
.LP
Planes enter at 7000 feet and leave at 9000 feet.
.LP
Planes flying at an altitude of 0 crash if they are not over an airport.
.LP
Planes waiting at airports can only be told to take off (climb in altitude).
.SH "NEW GAMES"
.LP
The 
.B Game_List
file lists the currently available play fields.  New field description
file names must be placed in this file to be 'playable'.  If a player
specifies a game not in this file, his score will not be logged.
.LP
The game field description files are broken into two parts.  The first
part is the definition section.  Here, the four tunable game parameters
must be set.  These variables are set with the syntax:
.IP
variable = number;
.LP
Variable may be one of: 
.B update,
indicating the number of seconds between forced updates;
.B newplane,
indicating (about) the number of updates between new plane entries;
.B width,
indicating the width of the play field; and
.B height,
indicating the height of the play field.
.LP
The second part of the field description files describes the locations
of the exits, the beacons, the airports and the lines.
The syntax is as follows:
.IP
beacon:	(x y) ... ;
.br
airport:	(x y direction) ... ;
.br
exit:	(x y direction) ... ;
.br
line:	[ (x1 y1) (x2 y2) ] ... ;
.LP
For beacons, a simple x, y coordinate pair is used (enclosed in parenthesis).
Airports and exits require a third value, a direction, which is one
of 
.B wedcxzaq.
For airports, this is the direction that planes must be going to take
off and land, and for exits, this is the direction that planes will going
when they
.B enter
the arena.  This may not seem intuitive, but as there is no restriction on
direction of exit, this is appropriate.
Lines are slightly different, since they need two coordinate pairs to
specify the line endpoints.  These endpoints must be enclosed in 
square brackets.
.LP
All statements are semi-colon (;) terminated.  Multiple item statements
accumulate.  Each definition must occur exactly once, before any
item statements.  Comments begin with a hash (#) symbol
and terminate with a newline.
The coordinates are between zero and width-1 and height-1
inclusive.  All of the exit coordinates must lie on the borders, and
all of the beacons and airports must lie inside of the borders.
Line endpoints may be anywhere within the field, so long as 
the lines are horizontal, vertical or 
.B "exactly diagonal."
.SS "FIELD FILE EXAMPLE"
.RS
.sp
.nf
.TA 1i 1i
.ta 1i 1i
# This is the default game.

update = 5;
newplane = 5;
width = 30;
height = 21;

exit:		( 12  0 x ) ( 29  0 z ) ( 29  7 a ) ( 29 17 a )
		(  9 20 e ) (  0 13 d ) (  0  7 d ) (  0  0 c ) ;

beacon:		( 12  7 ) ( 12 17 ) ;

airport:	( 20 15 w ) ( 20 18 d ) ;

line:		[ (  1  1 ) (  6  6 ) ]
		[ ( 12  1 ) ( 12  6 ) ]
		[ ( 13  7 ) ( 28  7 ) ]
		[ ( 28  1 ) ( 13 16 ) ]
		[ (  1 13 ) ( 11 13 ) ]
		[ ( 12  8 ) ( 12 16 ) ]
		[ ( 11 18 ) ( 10 19 ) ]
		[ ( 13 17 ) ( 28 17 ) ]
		[ (  1  7 ) ( 11  7 ) ] ;
.fi
.RE
.SH FILES
.LP
Files are kept in a special directory. See the OPTIONS for a way to 
print this path out.
.TP 16
.B ATC_score
Where the scores are kept.
.TP 16
.B Game_List
The list of playable games.
.SH AUTHOR
.LP
Ed James, UC Berkeley: edjames@ucbvax.berkeley.edu, ucbvax!edjames
.LP
This game is based on someone's description of the overall flavor
of a game written for some unknown PC many years ago, maybe.
.SH BUGS
.LP
The screen sometimes refreshes after you have quit.
.LP
Yet Another Curses Bug was discovered during the development of this game.
If your curses library clrtobot.o is version 5.1 or earlier, 
you will have erase problems with the backspace operator in the input
window.

