.\"	@(#)yacc.1	6.1 (Berkeley) 4/29/85
.\"
.TH YACC 1 "April 29, 1985"
.AT 3
.SH NAME
yacc \- yet another compiler-compiler
.SH SYNOPSIS
.B yacc
[
.B \-vd
]
grammar
.SH DESCRIPTION
.I Yacc
converts a context-free grammar into a set of
tables for a simple automaton which executes an LR(1) parsing
algorithm.
The grammar may be ambiguous;
specified precedence rules are used to break ambiguities.
.PP
The output file,
.IR y.tab.c ,
must be compiled by the C compiler
to produce a program
.IR yyparse .
This program must be loaded with the lexical analyzer program,
.IR yylex ,
as well as
.I main
and
.IR yyerror ,
an error handling routine.
These routines must be supplied by the user;
.IR Lex (1)
is useful for creating lexical analyzers usable by
.IR yacc .
.PP
If the
.B \-v
flag is given, the file
.I y.output
is prepared, which contains a description of the parsing tables
and a report on
conflicts generated by ambiguities in the grammar.
.PP
If the \-\fBd\fR flag is used, the file
.I y.tab.h
is generated with the
.I define
statements that associate the
.I yacc\c
-assigned `token codes' with the user-declared `token names'.
This allows source files other than
.I y.tab.c
to access the token codes.
.SH FILES
.ta \w'yacc.tmp, yacc.acts 'u
y.output
.br
y.tab.c
.br
y.tab.h	defines for token names
.br
yacc.tmp, yacc.acts	temporary files
.br
/usr/lib/yaccpar	parser prototype for C programs
.SH "SEE ALSO"
.IR lex (1)
.br
.I "LR Parsing"
by A. V. Aho and S. C. Johnson,
Computing Surveys, June, 1974.
.br
.I "YACC \- Yet Another Compiler Compiler"
by S. C. Johnson.
.SH DIAGNOSTICS
The number of reduce-reduce and shift-reduce conflicts
is reported on the standard output;
a more detailed report is
found in the
.I y.output
file.
Similarly, if some rules are not reachable from the
start symbol, this is also reported.
.SH BUGS
Because file names are fixed, at most one
.I yacc
process can be active in a given directory at
a time.
