.\"	@(#)uux.1c	6.3 (Berkeley) 4/24/86
.\"
.TH UUX 1C "April 24, 1986"
.AT 3
.SH NAME
uux \- unix to unix command execution
.SH SYNOPSIS
.B uux
[
.B -
] [
.B -cClLnprz
] [
.BI -a name
] [
.BI -g grade
] [
.BI -x debug
]
command-string
.SH DESCRIPTION
.I Uux\^
will gather zero or more files from various systems,
execute a command on a specified system
and then send standard output to a file on a specified
system.
.PP
The
.I command-string
is made up of one or more arguments that look
like a Shell command line,
except that the command and file names
may be prefixed by
.IB system-name !\fR.\fP
A null \fIsystem-name\fP is interpreted as the local system.
.PP
File names may be one of
.IP
(1) a full path name;
.IP
(2) a path name preceded by
.BI ~ user
where
.I user
is a login name on the specified system
and is replaced by that user's login directory;
.IP
(3) a path name prefixed by
.BR ~;
where
.B ~
is expanded to the system's public directory (usually /usr/spool/uucppublic);
.IP
(4) a partial pathname, which is prefixed by the current directory.
.PP
As an example, the command
.IP
uux "\^!diff usg!/usr/dan/file1 pwba!/a4/dan/file2 > !~/dan/file.diff\^"
.PP
will get the \fBfile1\fP and \fBfile2\fP files
from the ``usg'' and ``pwba'' machines,
execute a
.IR diff (1)
command
and put the results in \fBfile.diff\fP in the 
local /usr/spool/uucppublic/dan/ directory.
.PP
Any special shell characters, such as \fB<>;|\fP, should be quoted either
by quoting the entire \fIcommand-string\fP, or quoting the special
characters as individual arguments.
.PP
.I Uux
will attempt to get all files to the execution system.
For files that are output files, the file name must be escaped using
parentheses.
For example, the command
.IP
uux a!wc b!/usr/file1 \\(c!/usr/file2 \\)
.PP
get \fB/usr/file1\fP from system ``b'' and send it to system ``a'',
perform a \fIwc\fP command on that file
and send the result of the 
.I wc
command to system ``c''.
.PP
.I Uux\^
will notify you by mail if the requested command on the remote
system was disallowed.
This notification can be turned off by the \fB\-n\fP option.
.PP
The following \fIoptions\fP are interpreted by
.IR uux :
.TP .5i
.B \-
The standard input to
.I uux
is made the standard input to the
.IR command-string .
.TP .5i
.BI \-a name
Use
.I name
as the user identification replacing the initiator user-id.
.TP .5i
.B \-c
Do not copy local file to the spool directory for transfer to the remote
machine (this is the default).
.TP .5i
.B \-C
Force the copy of local files to the spool directory for transfer.
.TP .5i
.BI \-g grade
.I Grade
is a single letter/number, from
.B 0
to
.BR 9 ,
.B A
to
.BR Z ,
or
.B a
to
.BR z ;
.B 0
is the highest, and
.B z
is the lowest grade.
The default is 
.BR A ;
by comparison
.IR uucp (1C)
defaults to
.B n
and mail is usually sent at grade
.BR C .
Lower grades should be specified for high-volume jobs, such as news.
.TP .5i
.B \-l
Try and make a link from the original file to the spool directory.
If the link cannot be made, copy the file.
.TP .5i
.B \-n
Do not notify the user when the command completes.
.TP .5i
.B \-p
Same as \-:
The standard input to
.I uux
is made the standard input to the
.IR command-string .
.TP .5i
.B \-r
Do not start the file transfer, just queue the job.
.TP .5i
.BI \-x debug
Produce debugging output on stdout.
The debug is a number between 0 and 9;
higher numbers give more detailed information. Debugging is permitted
only for privileged users (specifically, those with read access to
.IR L.sys (5) .
.TP .5i
.B \-z
Notify the user only if the command fails.
.TP .5i
.B \-L
Start up
.I uucico
with the \fB-L\fP flag. This will force
calls to be made to local sites only (see
.IR uucico (8C)).
.SH FILES
.PD 0
.TP 22
/usr/spool/uucp
spool directories
.TP
/usr/lib/uucp/\(**
UUCP configuration data and daemons
.PD
.SH SEE ALSO
uucp(1C), uucico(8C), uuxqt(8C).
.SH WARNING
For security reasons, many installations will
limit the list of
commands executable on behalf of an incoming request from
.IR uux .
Many sites will permit little more than
the receipt of mail (see
.IR mail (1))
via 
.IR uux .
.SH BUGS
Only the first command of a shell pipeline may
have a
.IB system-name !\fR.
All other commands are executed on the system of the first
command.
.PP
The use of the shell metacharacter
.B \(**
will probably not do what you want it to do.
.PP
The shell tokens
.B <<
and
.B >>
are not implemented.
.PP
When invoking
.I uux
from
.IR csh (1),
the `!' character must be prefixed by the `\\' escape to inhibit
.IR csh 's
history mechanism. (Quotes are not sufficient.)
