.\"	@(#)uuq.1c	6.2 (Berkeley) 4/24/86
.\"
.TH UUQ 1C "April 24, 1986"
.UC 6
.SH NAME
uuq \- examine or manipulate the uucp queue
.SH SYNOPSIS
.B uuq
[
.B -l
] [
.B -h
] [
.BI -s system
] [
.BI -u user
] [
.BI -d jobno
] [
.BI -r sdir
] [
.BI -b baud
]
.SH DESCRIPTION
.I Uuq
is used to examine (and possibly delete) entries in the uucp queue.
.PP
When listing jobs,
.I uuq
uses a format reminiscent of
.IR ls .
For the long format,
information for each job listed includes
job number, number of files to transfer, user who
spooled the job, number of bytes to send, type of command requested
(S for sending files, R for receiving files, X for remote uucp),
and file or command desired.
.PP
Several options are available:
.TP 10
.B \-h
Print only the summary lines for each system.  Summary lines give system
name, number of jobs for the system, and total number of bytes to send.
.TP 10
.B \-l
Specifies a long format listing.  The default is to list only the
job numbers sorted across the page.
.TP 10
.BI \-s system
Limit output to jobs for systems whose system names begin with \fIsystem\fP.
.TP 10
.BI \-u user
Limit output to jobs for users whose login names begin with \fIuser\fP.
.TP 10
.BI \-d jobno
Delete job number \fIjobno\fP (as obtained from a previous \fIuuq\fP command)
from the uucp queue.
Only the UUCP Administrator is permitted to delete jobs.
.TP 10
.BI \-r sdir
Look for files in the spooling directory \fIsdir\fP instead of the default
directory.
.TP 10
.BI \-b baud
Use \fIbaud\fP to compute the transfer time instead of the default
1200 baud.
.SH FILES
.ta \w'/usr/spool/uucp/D.hostname/D.*   'u
/usr/spool/uucp/	Default spool directory
/usr/spool/uucp/C./C.*	Control files
.br
/usr/spool/uucp/D\fIhostname\fP./D.*	Outgoing data files
/usr/spool/uucp/X./X.*	Outgoing execution files
.SH SEE ALSO
uucp(1C), uux(1C), uulog(1C), uusnap(8C)
.SH BUGS
No information is available on work requested by the remote machine.
.PP
The user who requests a remote uucp command is unknown.
.PP
.B "Uuq -l"
can be horrendously slow.
.SH AUTHOR
Lou Salkind, New York University
