.\" Copyright (c) 1986 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)uupoll.8c	6.2 (Berkeley) 7/7/86
.\"
.TH UUPOLL 8C "July 7, 1986"
.UC 6
.SH NAME
uupoll \- poll a remote \s-1UUCP\s+1 site
.SH SYNOPSIS
.B uupoll
[
.BI \-g grade
] [
.B \-n
]
.I system
.SH DESCRIPTION
.I Uupoll
is used to force a poll of a remote system. It queues a null job for the
remote system and then invokes
.IR uucico (8C).
.PP
The following options are available:
.TP 8
.BI \-g grade
Only send jobs of grade
.I grade
or higher on this call.
.TP 8
.B \-n
Queue the null job, but do not invoke
.IR uucico .
.PP
.I Uupoll
is usually run by
.IR cron (5)
or by a user who wants to hurry a job along. A typical entry in
.I crontab
could be:
.PP
.nf
	0	0,8,16	*	*	*	daemon	/usr/bin/uupoll ihnp4
	0	4,12,20	*	*	*	daemon	/usr/bin/uupoll ucbvax
.fi
This will poll
.B ihnp4
at midnight, 0800, and 1600, and
.B ucbvax
at 0400, noon, and 2000.
.PP
If the local machine is already running
.I uucico
every
hour and has a limited number of outgoing modems, a more elegant approach
might be:
.PP
.nf
	0	0,8,16	*	*	*	daemon	/usr/bin/uupoll -n ihnp4
	0	4,12,20	*	*	*	daemon	/usr/bin/uupoll -n ucbvax
	5		*	*	*	*	daemon	/usr/lib/uucp/uucico -r1
.fi
This will queue null jobs for the remote sites at the top of hour; they
will be processed by
.I uucico
when it runs five minutes later.
.SH FILES
.ta \w'/usr/spool/uucp/   'u
.nf
/usr/lib/uucp/	UUCP internal files/utilities
/usr/spool/uucp/	Spool directory
.fi
.SH SEE ALSO
uucp(1C), uux(1C), uucico(8C)
