.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)uuencode.1c	6.2 (Berkeley) 4/24/86
.\"
.TH UUENCODE 1C "April 24, 1986"
.UC 4
.SH NAME
uuencode, uudecode \- encode/decode a binary file for transmission via mail
.SH SYNOPSIS
.B uuencode
[ source ] remotedest |
.B mail
sys1!sys2!..!decode
.br
.B uudecode
[ file ]
.SH DESCRIPTION
.I Uuencode
and
.I uudecode
are used to send a binary file via uucp (or other) mail.
This combination can be used over indirect mail links
even when
.IR uusend (1C)
is not available.
.PP
.I Uuencode
takes the named source file (default standard input) and
produces an encoded version on the standard output.
The encoding uses only printing ASCII characters,
and includes the mode of the file and the
.I remotedest
for recreation on the remote system.
.PP
.I Uudecode
reads an encoded file,
strips off any leading and trailing lines added by mailers,
and recreates the original file with the specified mode and name.
.PP
The intent is that all mail to the user ``decode'' should be filtered
through the
.I uudecode
program.  This way the file is created automatically
without human intervention.
This is possible on the uucp network by either using
.I sendmail
or by making
.I rmail
be a link to
.I Mail
instead of
.IR mail .
In each case, an alias must be created in a master file to get
the automatic invocation of
.IR uudecode .
.PP
If these facilities are not available, the file can be sent to a
user on the remote machine who can uudecode it manually.
.PP
The encode file has an ordinary text form and can be edited
by any text editor to change the mode or remote name.
.SH SEE ALSO
atob(n), uusend(1C), uucp(1C), uux(1C), mail(1), uuencode(5)
.SH BUGS
The file is expanded by 35% (3 bytes become 4 plus control information)
causing it to take longer to transmit.
.PP
The user on the remote system who is invoking
.I uudecode
(often
.IR uucp )
must have write permission on the specified file.
