.\"	@(#)uucp.1c	6.3 (Berkeley) 4/24/86
.\"
.TH UUCP 1C "April 24, 1986"
.AT 3
.SH NAME
uucp \- unix to unix copy
.SH SYNOPSIS
.B uucp
[
.B \-acCdfmr
] [
.BI \-n user
] [
.BI \-g grade
] [
.BI \-s spool
] [
.BI \-x debug
] source-file....  destination-file
.SH DESCRIPTION
.I Uucp
copies files named by the source-file arguments
to the destination-file argument.
A file name may be a pathname on your machine, or may 
have the form
.IP
system-name!pathname
.LP
where `system-name' is taken from a list of system names
that
.I uucp
knows about.
Shell metacharacters ?*[] appearing in the pathname part
will be expanded on the appropriate system.
.PP
Pathnames may be one of:
.IP (1)
a full pathname;
.IP (2)
a pathname preceded by
.BI ~ user;
where
.I user
is a userid on the specified system
and is replaced by that user's login directory;
.IP (3)
a pathname prefixed by
.BR ~ ,
where
.B ~
is expanded into the system's public directory (usually /usr/spool/uucppublic);
.IP (4)
a partial pathname, which is prefixed by the current directory.
.PP
If the result is an erroneous pathname for the remote system,
the copy will fail.
If the destination-file is a directory, the last part of the
source-file name is used.
.ig
If a simple
.I ~user
destination is inaccessible to 
.IR uucp ,
data is copied to a spool directory and the user
is notified by
.IR mail (1).
..
.PP
.I Uucp
preserves execute permissions across the transmission
and gives 0666 read and write permissions (see
.IR chmod (2)).
.PP
The following options are interpreted by
.IR uucp .
.TP
.B \-a
Avoid doing a
.I getwd
to find the current directory.
(This is sometimes used for efficiency.)
.TP 
.B \-c
Use the source file when copying out rather than
copying the file to the spool directory.
(This is the default.)
.TP
.B \-C
Copy the source file to the spool directory and transmit
the copy.
.TP 
.B \-d
Make all necessary directories for the file copy.
(This is the default.)
.TP
.B \-f
Do not make intermediate directories for the file copy.
.TP
.BI \-g grade
.I Grade
is a single letter/number; lower ASCII sequence characters
will cause a job to be transmitted earlier during a particular conversation.
Default is `n'. By way of comparison,
.IR uux (1C)
defaults to `A'; mail is usually sent at `C'.
.TP 
.B \-m
Send mail to the requester when the copy is complete.
.TP
.BI \-n user
Notify
.I user
on remote system (i.e., send
.I user
mail) that a file was sent.
.TP
.B \-r
Do not start the transfer, just queue the job.
.TP
.BI \-s spool
Use
.I spool
as the spool directory instead of the default.
.TP
.BI \-x debug
Turn on the debugging at level
.I debug.
.SH FILES
/usr/spool/uucp - spool directory
.br
/usr/lib/uucp/* - other data and program files
.SH SEE ALSO
uux(1C), mail(1)
.PP
D. A. Nowitz and M. E. Lesk,
.IR "A Dial-Up Network of UNIX Systems" .
.PP
D. A. Nowitz,
.IR "Uucp Implementation Description" .
.SH WARNING
The domain of remotely accessible files can
(and for obvious security reasons, usually should)
be severely restricted.
You will very likely not be able to fetch files
by pathname;
ask a responsible person on the remote system to
send them to you.
For the same reasons you will probably not be able
to send files to arbitrary pathnames.
.SH BUGS
.br
All files received by
.I uucp
will be owned by the uucp administrator (usually UID 5).
.PP
The 
.B \-m
option will only work sending files or receiving
a single file.
(Receiving multiple files specified by special shell
characters ?*[] will not activate
the
.B \-m
option.)
.PP
At present
.I uucp
cannot copy to a system several "hops" away, that is, a command of
the form
.PP
.nf
	uucp myfile system1!system2!system3!yourfile
.fi
.PP
is not permitted. Use
.IR uusend (1C)
instead.
.PP
When invoking
.I uucp
from
.IR csh (1),
the `!' character must be prefixed by the `\e' escape to inhibit
.IR csh 's
history mechanism. (Quotes are not sufficient.)
.PP
.I Uucp
refuses to copy a file that does not give read access to ``other'';
that is, the file must have at least 0444 modes.
