.\"	@(#)tr.1	6.1 (Berkeley) 4/29/85
.\"
.TH TR 1 "April 29, 1985"
.AT 3
.SH NAME
tr \- translate characters
.SH SYNOPSIS
.B tr
[
.B \-cds
] [ string1 [ string2 ] ]
.SH DESCRIPTION
.I Tr
copies the standard input to the standard output with 
substitution or deletion of selected characters.
Input characters found in 
.I string1
are mapped into the corresponding characters of
.IR string2 .
When 
.I string2
is short it is padded to the length of 
.I string1
by duplicating its last character.
Any combination of the options
.B \-cds
may be used:
.B \-c
complements the set of characters in
.I string1
with respect to the universe of characters
whose ASCII codes are 01 through 0377 octal;
.B \-d
deletes all input characters in
.I string1;
.B \-s
squeezes all strings of repeated output characters that are
in 
.I string2
to single characters.
.PP
In either string the notation
.IB a \- b
means a range of characters from
.I a
to
.I b
in increasing ASCII order.
The character
`\e' followed by 1, 2 or 3 octal digits stands for the
character whose ASCII code is given by those digits.
A `\e' followed by any other character stands
for that character.
.PP
The following example creates a list of all
the words in `file1' one per line in `file2',
where a word is taken to be a maximal string of alphabetics.
The second string is quoted
to protect `\e' from the Shell.
012 is the ASCII code for newline.
.IP
tr \-cs A\-Za\-z \'\e012\' <file1 >file2
.SH "SEE ALSO"
ed(1), ascii(7), expand(1)
.SH BUGS
Won't handle ASCII NUL in
.I string1
or
.I string2;
always deletes NUL from input.
