.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)tip.1c	6.3 (Berkeley) 5/5/86
.\"
.TH TIP 1C "May 5, 1986"
.UC 4
.SH NAME
tip, cu \- connect to a remote system
.SH SYNOPSIS
.B tip
[
.B \-v
] [
.BI \- speed
] system-name
.br
.B tip
[
.B \-v
] [
.BI \- speed
] phone-number
.br
.B cu
phone-number
[
.B \-t
] [
.B \-s
.I speed
] [
.B \ -a
.I acu
] [
.B \-l
.I line
] [
.B \-#
]
.SH DESCRIPTION
.I Tip
and
.I cu
establish a full-duplex connection to another machine,
giving the appearance of being logged in directly on the
remote cpu.  It goes without saying that you must have a login
on the machine (or equivalent) to which you wish to connect.
The preferred interface is
.IR tip .
The
.I cu
interface is included for those people attached to the
``call UNIX'' command of version 7.  This manual page
describes only 
.IR tip .
.PP
Typed characters are normally transmitted directly to the remote
machine (which does the echoing as well).  A tilde (`~') appearing
as the first character of a line is an escape signal; the following
are recognized:
.TP 10
.B ~^D ~.
Drop the connection and exit
(you may still be logged in on the
remote machine).
.TP 10
\fB~c \fP [\fIname\fP]
Change directory to name (no argument
implies change to your home directory).
.TP 10
.B ~!
Escape to a shell (exiting the shell will
return you to tip).
.TP 10
.B ~>
Copy file from local to remote.
.I Tip
prompts for the name of a local file to transmit.
.TP 10
.B ~<
Copy file from remote to local.
.I Tip
prompts first for the name of the file to be sent, then for
a command to be executed on the remote machine.
.TP 10
\fB~p\fP \fIfrom\fP [ \fIto\fP ]
Send a file to a remote UNIX host.  The put command causes the remote UNIX
system to run the command string ``cat > 'to''', while
.I tip
sends it the ``from''
file.  If the ``to'' file isn't specified the ``from'' file name is used.
This command is actually a UNIX specific version of the ``~>'' command.
.TP 10
\fB~t\fP \fIfrom\fP [ \fIto\fP ]
Take a file from a remote UNIX host. 
As in the put command the ``to'' file
defaults to the ``from'' file name if it isn't specified. 
The remote host
executes the command string ``cat 'from';echo ^A'' to send the file to
.IR tip .
.TP 10
.B ~|
Pipe the output from a remote command to a local UNIX process.
The command string sent to the local UNIX system is processed by the shell.
.TP 10
.B ~$
Pipe the output from a local UNIX process to the remote host.
The command string sent to the local UNIX system is processed by the shell.
.TP 10
.B ~#
Send a BREAK to the remote system. 
For systems which don't support the
necessary
.I ioctl
call the break is simulated by a sequence of line speed changes
and DEL characters.
.TP 10
.B ~s
Set a variable (see the discussion below).
.TP 10
.B ~^Z
Stop
.I tip
(only available with job control).
.TP 10
.B ~^Y
Stop only the ``local side'' of
.I tip
(only available with job control);
the ``remote side'' of
.IR tip ,
the side that displays output from the remote host, is left running.
.TP 10
.B ~?
Get a summary of the tilde escapes
.sp
.PP
.I Tip
uses the file /etc/remote to find how to reach a particular
system and to find out how it should operate while talking
to the system;
refer to
.IR remote (5)
for a full description.
Each system has a default baud rate with which to
establish a connection.  If this value is not suitable, the baud rate
to be used may be specified on the command line, e.g. ``tip -300 mds''.
.PP
When
.I tip
establishes a connection it sends out a
connection message to the remote system; the default value, if any,
is defined in /etc/remote.
.PP
When
.I tip
prompts for an argument (e.g. during setup of
a file transfer) the line typed may be edited with the standard
erase and kill characters.  A null line in response to a prompt,
or an interrupt, will abort the dialogue and return you to the
remote machine.
.PP
.I Tip
guards against multiple users connecting to a remote system
by opening modems and terminal lines with exclusive access,
and by honoring the locking protocol used by
.IR uucp (1C).
.PP
During file transfers 
.I tip
provides a running count of the number of lines transferred.
When using the ~> and ~< commands, the ``eofread'' and ``eofwrite''
variables are used to recognize end-of-file when reading, and
specify end-of-file when writing (see below).  File transfers
normally depend on tandem mode for flow control.  If the remote
system does not support tandem mode, ``echocheck'' may be set
to indicate
.I tip
should synchronize with the remote system on the echo of each
transmitted character.
.PP
When
.I tip
must dial a phone number to connect to a system it will print
various messages indicating its actions.
.I Tip
supports the DEC DN-11 and Racal-Vadic 831 auto-call-units;
the DEC DF02 and DF03, Ventel 212+, Racal-Vadic 3451, and
Bizcomp 1031 and 1032 integral call unit/modems.
.PP
.SM
.B VARIABLES
.PP
.I Tip
maintains a set of
.I variables
which control its operation.
Some of these variable are read-only to normal users (root is allowed
to change anything of interest).  Variables may be displayed
and set through the ``s'' escape.  The syntax for variables is patterned
after
.IR vi (1)
and
.IR Mail (1).
Supplying ``all''
as an argument to the set command displays all variables readable by
the user.  Alternatively, the user may request display of a particular
variable by attaching a `?' to the end.  For example ``escape?''
displays the current escape character.
.PP
Variables are numeric, string, character, or boolean values.  Boolean
variables are set merely by specifying their name; they may be reset
by prepending a `!' to the name.  Other variable types are set by
concatenating an `=' and the value.  The entire assignment must not
have any blanks in it.  A single set command may be used to interrogate
as well as set a number of variables.
Variables may be initialized at run time by placing set commands
(without the ``~s'' prefix in a file
.I .tiprc
in one's home directory).  The
.B \-v
option causes
.I tip
to display the sets as they are made.
Certain common variables have abbreviations. 
The following is a list of common variables,
their abbreviations, and their default values.
.TP
.B beautify
.br
(bool) Discard unprintable characters when a session is being scripted;
abbreviated 
.IR be .
.TP
.B baudrate
.br
(num) The baud rate at which the connection was established;
abbreviated
.IR ba .
.TP
.B dialtimeout
.br
(num) When dialing a phone number, the time (in seconds)
to wait for a connection to be established; abbreviated
.IR dial .
.TP
.B echocheck
.br
(bool) Synchronize with the remote host during file transfer by
waiting for the echo of the last character transmitted; default is
.IR off .
.TP
.B eofread
.br
(str) The set of characters which signify and end-of-tranmission
during a ~< file transfer command; abbreviated
.IR eofr .
.TP
.B eofwrite
.br
(str) The string sent to indicate end-of-transmission during
a ~> file transfer command; abbreviated
.IR eofw .
.TP
.B eol
.br
(str) The set of characters which indicate an end-of-line.
.I Tip
will recognize escape characters only after an end-of-line.
.TP
.B escape
.br
(char) The command prefix (escape) character; abbreviated
.IR es ;
default value is `~'.
.TP
.B exceptions
.br
(str) The set of characters which should not be discarded
due to the beautification switch; abbreviated
.IR ex ;
default value is ``\et\en\ef\eb''.
.TP
.B force
.br
(char) The character used to force literal data transmission;
abbreviated
.IR fo ;
default value is `^P'.
.TP
.B framesize
.br
(num) The amount of data (in bytes) to buffer between file system
writes when receiving files; abbreviated
.IR fr .
.TP
.B host
.br
(str) The name of the host to which you are connected; abbreviated
.IR ho .
.TP
.B prompt
.br
(char) The character which indicates and end-of-line on the remote
host; abbreviated
.IR pr ;
default value is `\en'.  This value is used to synchronize during
data transfers.  The count of lines transferred during a file transfer
command is based on recipt of this character.
.TP
.B raise
.br
(bool) Upper case mapping mode; abbreviated 
.IR ra ;
default value is 
.IR off .
When this mode is enabled, all lower case letters will be mapped to
upper case by
.I tip
for transmission to the remote machine.
.TP
.B raisechar
.br
(char) The input character used to toggle upper case mapping mode;
abbreviated
.IR rc ;
default value is `^A'.
.TP
.B record
.br
(str) The name of the file in which a session script is recorded;
abbreviated
.IR rec ;
default value is ``tip.record''.
.TP
.B script
.br
(bool) Session scripting mode; abbreviated
.IR sc ;
default is 
.IR off .
When
.I script
is 
.IR true ,
.I tip
will record everything transmitted by the remote machine in
the script record file specified in
.IR record .
If the
.I beautify
switch is on, only printable ASCII characters will be included in
the script file (those characters betwee 040 and 0177).  The
variable
.I exceptions
is used to indicate characters which are an exception to the normal
beautification rules.
.TP
.B tabexpand
.br
(bool) Expand tabs to spaces during file transfers; abbreviated
.IR tab ;
default value is
.IR false .
Each tab is expanded to 8 spaces.
.TP
.B verbose
.br
(bool) Verbose mode; abbreviated
.IR verb ;
default is 
.IR true .
When verbose mode is enabled, 
.I tip
prints messages while dialing, shows the current number
of lines transferred during a file transfer operations,
and more.
.TP
.B SHELL
.br
(str) The name of the shell to use for the ~! command; default
value is ``/bin/sh'', or taken from the environment.
.TP
.B HOME
.br
(str) The home directory to use for the ~c command; default
value is taken from the environment.
.PP
.SH FILES
.ta \w'/usr/spool/uucp/LCK..*   'u
.nf
/etc/remote	global system descriptions
/etc/phones	global phone number data base
${REMOTE}	private system descriptions
${PHONES}	private phone numbers
~/.tiprc	initialization file.
/usr/spool/uucp/LCK..*	lock file to avoid conflicts with \fIuucp\fP
.fi
.SH DIAGNOSTICS
Diagnostics are, hopefully, self explanatory.
.SH "SEE ALSO"
remote(5),
phones(5)
.SH BUGS
The full set of variables is undocumented and should, probably, be
paired down.
