.\"
.\" $Id: sup.1,v 1.3 89/12/29 13:12:34 bww Exp $
.\"
.\" HISTORY
.\" $Log:	sup.1,v $
.\" Revision 1.3  89/12/29  13:12:34  bww
.\" 	Revised for 2.6 MSD release.
.\" 	[89/12/29            bww]
.\" 
.\" 10-May-86  Glenn Marcy (gm0w) at Carnegie-Mellon University
.\"	Replaced reference to /usr/cmu with /usr/cs.
.\"
.\" 29-Mar-86  Glenn Marcy (gm0w) at Carnegie-Mellon University
.\"	Updated manual entry to version 5.14 of sup.
.\"
.\" 14-Jan-86  Glenn Marcy (gm0w) at Carnegie-Mellon University
.\"	Updated manual entry to version 5.7 of sup.
.\"
.\" 04-Apr-85  Steven Shafer (sas) at Carnegie-Mellon University
.\"	Created.
.\"
.TH SUP 1 5/10/86
.CM 4
.SH "NAME"
sup \- software upgrade protocol
.SH "SYNOPSIS"
\fBsup\fR [ \fIflags\fR ] [ \fIsupfile\fR ] [ \fIcollection\fR ...]
.SH "DESCRIPTION"
.I Sup
is a program used for upgrading collections of files from other machines
to your machine.  You execute
.IR sup ,
the
.I client
program, which talks over the network using IP/TCP to a
.I file server
and possibly a
.I name server
process.  The name server
process determines appropriate
.I repository
machines from which to
request upgrades.  The file server process cooperates with
.I sup
to determine which files of the collection need to be upgraded on
your machine.

In performing an upgrade, the file server constructs a list of
files included in the collection.  The list is sent to your machine,
which determines which files are needed.  Those files are then sent
from the file server.
It will be most useful to run
.I sup
as a daemon each night so you will continually have the latest version of the
files in the needed collections.

The only required argument to
.I sup
is the name of a supfile.  It must either be given explicitly on the command
line, or the
.B -s
flag must be specified.  If the
.B -s
flag is given, the system supfile will be used and a supfile command argument
should not be specified.  The list of collections is optional and if specified
will be the only collections upgraded.  The following flags affect all
collections specified:
.TP
.B -s
As described above.
.TP
.B -t
When this flag is given,
.I sup
will print the time
that each collection was last upgraded, rather than
performing actual upgrades.
.TP
.B -N
.I Sup
will trace network messages sent and received that implement the
.I sup
network protocol.
.TP
.B -P
Sup will use a set of non-privileged network
ports reserved for debugging purposes.
.i0
.DT
.PP

The remaining flags affect all collections unless an explicit list
of collections are given with the flags.  Multiple flags may be
specified together that affect the same collections.  For the sake
of convience, any flags that always affect all collections can be
specified with flags that affect only some collections.  For
example,
.B sup -sde=coll1,coll2
would perform a system upgrade,
and the first two collections would allow both file deletions and
command executions.  Note that this is not the same command as
.B sup -sde=coll1 coll2,
which would perform a system upgrade of
just the coll2 collection and would ignore the flags given for the
coll1 collection.
.TP
.B -a
All files in the collection will be copied from
the repository, regardless of their status on the
current machine.  Because of this, it is a very
expensive operation and should only be done for
small collections if data corruption is suspected
and been confirmed.  In most cases, the
.B -o
flag should be sufficient.
.TP
.B -b
If the
.B -b
flag if given, or the 
.B backup
supfile
option is specified, the contents of regular files
on the local system will be saved before they are
overwritten with new data.  The file collection maintainer
can designate specific files to be
worthy of backing up whenever they are upgraded.
However, such
backup will only take place if you specify this flag or the
.B backup
option to allow
backups for a file collection on your machine.
The backup mechanism
will create a copy of the current version of a file immediately
before a new copy is received from the file server; the copy is
given the same name as the original file but is put into a directory
called
.B 
BACKUP
within the directory containing the original file.
For example,
.B 
/usr/sas/src/foo.c
would have a backup copy called
.B 
/usr/sas/src/BACKUP/foo.c.
There is no provision for automatically maintaining multiple old
versions of files; you would have to do this yourself.
.TP
.B -B
The
.B -B
flag overrides and disables the
.B -b
flag and the
.B backup
supfile option.
.TP
.B -d
Files that are no longer in the collection on the
repository will be deleted if present on the local
machine.  This may also be specified in a supfile
with the
.B delete
option.
.TP
.B -D
The
.B -D
flag overrides and disables the
.B -d
flag and the
.B delete
supfile option.
.TP
.B -e
Sup will execute commands sent from the repository
that should be run when a file is upgraded.  If
the
.B -e
flag is omitted, Sup will print a message
that specifies the command to execute.  This may
also be specified in a supfile with the
.B execute
option.
.TP
.B -E
The
.B -E
flag overrides and disables the
.B -e
flag and the
.B execute
supfile option.
.TP
.B -f
A
.I list-only
upgrade will be performed.  Messages
will be printed that indicate what would happen if
an actual upgrade were done.
.TP
.B -l
Normally,
.I sup
will not upgrade a collection if the
repository is on the same machine.  This allows
users to run upgrades on all machines without
having to make special checks for the repository
machine.  If the
.B -l
flag is specified, collections
will be upgraded even if the repository is local.
.TP
.B -m
Normally,
.I sup
used standard output for messages.
If the
.B -m
flag if given,
.I sup
will send mail to the user running
.IR sup ,
or a user specified with the
.B notify
supfile option, that contains messages
printed by
.IR sup .
.TP
.B -o
.I Sup
will normally only upgrade files that have
changed on the repository since the last time an
upgrade was performed.  The
.B -o
flag, or the
.B old
supfile option, will cause
.I sup
to check all files
in the collection for changes instead of just the
new ones.
.TP
.B -O
The
.B -O
flag overrides and disables the
.B -o
flag and the
.B old
supfile option.
.TP
.B -v
Normally,
.I sup
will only print messages if there
are problems.  This flag causes
.I sup
to also print
messages during normal progress showing what
.I sup
is doing.
.i0
.DT
.PP
.SH "SETTING UP UPGRADES"
Each file collection to be upgraded must have a
.I base directory
which contains a subdirectory called
.B sup
that will be used by the
.I sup
program; it will be created automatically if you do not create it.
.I Sup
will put subdirectories and files into this directory as needed.

.I Sup
will look for a subdirectory with the same name as the
collection within the
.B sup
subdirectory of the
.I base directory.
If it exists it may contain any of the following files:
.TP
.B when
This file is automatically updated by
.I sup
when a collection is successfully upgraded and contains the
time that the file server, or possibly
.IR supscan ,
created the list of files in the upgrade list.
.I Sup
will send this time to the file server for generating the list
of files that have been changed on the repository machine.
.TP
.B refuse
This file contains a list of files and directories, one per line, that
the client is not interested in that should not be upgraded.
.TP
.B lock
This file is used by
.I sup
to lock a collection while it is being upgraded.
.I Sup
will get exclusive access to the lock file using
.IR flock (2),
preventing more than one
.I sup
from upgrading the same collection at the same time.
.TP
.B last
This file contains a list of files and directories, one per line, that
have been upgraded by
.I sup
in the past.  This information is used when the
.B delete
option, or the
.B -d
flag is used to locate files previously upgraded that are no longer
in the collection that should be deleted.
.i0
.DT
.PP

Each file collection must also be described in one or more supfiles.
When
.I sup
is executed, it reads the specified supfile to determine what file
collections to upgrade.
Each collection is described by a single
line of text in the supfile; this line must contain the name of the
collection, and possibly one or more options separated by spaces.
The options are:
.TP
.BI base= directory
The usual default name of the base directory for a collection is
described below (see FILES); if you want to specify another
directory name, use this option specifying the desired
directory.
.TP
.BI prefix= directory
Each collection may also have an associated
.I prefix directory
which is used instead of the base directory for references to
files within the collection.
.TP
.BI host= hostname
.br
.ns
.TP
.BI hostbase= directory
.br
.I System
collections are supported by the system maintainers, and
.I sup
will automatically find out the name of the host machine and
base directory on that machine.
However, you can also upgrade
.I private
collections; you simply specify with these options
the
.I hostname
of the machine containing the files and the
.I directory
used as a base directory for the file server on that machine.
Details of setting up a file collection are given in the section
below.
.TP
.BI login= accountid
.br
.ns
.TP
.BI password= password
.br
.br
.ns
.TP
.BI crypt= key
.br
Files on the file server may be protected, and network transmissions
may be encrypted.
This prevents unauthorized access to files via
.IR sup .
When files are not accessible to the default account (e.g.
the
.B anon
anonymous account), you can specify an alternative
.I accountid
and
.I password
for the file server to use on the repository host.
Network
transmission of the password will be always be encrypted.
You can
also have the actual file data encrypted by specifying a
.IR key ;
the file collection on the repository must specify the same key
or else
.I sup
will not be able to upgrade files from that collection.
In this case, the default account used by the file server on the
repository machine will be the owner of the encryption key
file (see FILES) rather than the
.B anon
anonymous account.
.TP
.BI notify= address
If you use the
.B 
-m
option to receive log messages by mail, you can have the mail
sent to different user, possibly on another host, than the user
running the sup program.
Messages will be sent to the specified
.IR address ,
which can be any legal netmail address.
In particular, a
project maintainer can be designated to receive mail for that
project's file collection from all users running
.I sup
to upgrade that collection.
.TP
.B backup
As described above under the
.B -b
flag.
.TP
.B delete
As described above under the
.B -d
flag.
.TP
.B execute
As described above under the
.B -e
flag.
.TP
.B old
As described above under the
.B -o
flag.
.i0
.DT
.PP
.SH "PREPARING A FILE COLLECTION REPOSITORY"
A set of files residing on a repository must be prepared before
.I sup
client processes can upgrade those files.
The collection must
be given a
.I name
and a
.I base directory.
If it is a private collection, client users
must be told the name of the collection, repository host, and
base directory;
these will be specified in the supfile via the
.B host
and
.B hostbase
options.
For a system-maintained file collection, entries must be
placed into the host list file and directory list file as described
in
.IR supfilesrv (8).

Within the base directory, a subdirectory must be created called
.B sup .
Within this directory there must be a subdirectory for each
collection using that base directory, whose name is the name of the
collection; within each of these directories will be a
list file and possibly a prefix file, a host file, an encryption key
file, a log file and
a scan file.
The filenames are listed under FILES below.
.TP
.B prefix
Normally, all files in the collection are relative to the base directory.
This file contains a single line which is the name of a directory to be
used in place of the base directory for file references.
.TP
.B host
Normally,
all remote host machines are allowed access to a file collection.
If you wish to restrict access to specific remote hosts for this
collection,
put each allowed hostname on a
separate line of text in this file.
If a host has more than one name, only one of its names needs to be
listed.
The name
.B LOCAL
can be used to grant access to all hosts on the local
network.
.TP
.B crypt
If you wish to use the
.I sup
data encryption mechanism, create an encryption file containing,
on a single line of text, the desired encryption key.
Client
processes must then specify the same key with the
.B crypt
option in the supfile or they will be denied access to the files.
In addition, actual network transmission of file contents and
filenames will be encrypted.
.TP
.B list
This file describes the actual list of files to be included in this
file collection, in a format described below.
.TP
.B scan
This file, created by
.IR supscan ,
is the list of filenames that correspond to the instructions in the
list file.  The scan file is only used for frequently-updated file
collections; it makes the file server run much faster.  See
.IR supservers (8)
for more information.
.TP
.B lock
As previously mentioned, this file is used to indicate that the
collection should be locked while upgrades are in progress.  All
file servers will try to get shared access to the lock file with
.IR flock (2).
.TP
.B logfile
If a log file exists in the collection directory, the file server
will append the last time an upgrade was successfully completed,
the time the last upgrade started and finished, and the name of
the host requesting the upgrade.
.i0
.DT
.PP
It should be noted that
.I sup
allows several different named collections to use the same base
directory.  Separate encryption, remote host access, and file lists
are then used for each collection.

The list file is a text file with one command on each line.
Each command
contains a keyword and a number of operands separated by spaces.
All filenames in the list file are evaluated on the repository machine
relative to the host's base directory, or prefix directory if one is
specified, and on your machine with respect
to the base, or prefix, directory for the client.
The
.I filenames
below (except \fIexec-command\fR)
may all include wild-cards and meta-characters as used by
.IR csh (1)
including *, ?, [...], and {...}.  The commands are:
.TP
\fBupgrade\fR \fIfilename\fR ...
The specified file(s) (or directories) will be included in the list
of files to be upgraded.
If a directory name is given, it recursively
includes all subdirectories and files within that directory.
.TP
\fBalways\fR \fIfilename\fR ...
The always command is identical to upgrade, except that omit and
omitany commands do not affect filenames specified with the always
command.
.TP
\fBomit\fR \fIfilename\fR ...
The specified file(s) (or directories) will be excluded from the
list of files to be upgraded.
For example, by specifying
.B upgrade /usr/vision
and
.B omit /usr/vision/exp,
the generated list
of files would include all subdirectories and files of /usr/vision
except /usr/vision/exp (and its subdirectories and files).
.TP
\fBomitany\fR \fIpattern\fR ...
The specified patterns are compared against the files in the upgrade
list.  If a pattern matches, the file is omitted.  The omitany command
currently supports all wild-card patterns except {...}.  Also, the
pattern must match the entire filename, so a leading */, or a trailing /*,
may be necessary in the pattern.
.TP
\fBbackup\fR \fIfilename\fR ...
The specified file(s) are marked for backup; if they are upgraded
and the client has specified the
.B backup
option in the corresponding
line of the supfile, then backup copies will be created as described
above.
Directories may not be specified, and no recursive filename
construction is performed; you must specify the names of the specific
files to be backed up before upgrading.
.TP
\fBnoaccount\fR \fIfilename\fR ...
The accounting information of the specified file(s) will not be
preserved by
.IR sup .
Accounting information consists of the owner,
group, mode and modified time of a file.
.TP
\fBsymlink\fR \fIfilename\fR ...
The specified file(s) are to be treated as symbolic links
and will be transfered as such and not followed.  By default,
.I sup
will follow symbolic links.
.TP
\fBexecute\fR \fIexec-command\fR (\fIfilename\fR ...)
The
.I exec-command
you specified will be executed on the client process
whenever any of the files listed in parentheses are upgraded.
A special token,
.B %s,
may be specified in the
.I exec-command
and will be replaced by the name of the file that was upgraded.
For example, if you say
\fBexecute ranlib %s (libc.a)\fR,
then whenever libc.a is upgraded, the client machine will execute
.B 
ranlib libc.a.
As described above, the client must invoke
.I sup
with the
.B -e
flag to allow the automatic execution of command files.
.TP
\fBinclude\fR \fIlistfile\fR ...
The specified
.I listfiles
will be read at this point.  This is useful
when one collection subsumes other collections; the larger collection
can simply specify the listfiles for the smaller collections contained
within it.
.i0
.DT
.PP
The order in which the command lines appear in the list file does not
matter.  Blank lines may appear freely in the list file.
.SH "FILES"
Files on the client machine for
.IR sup :
.TP
.B /usr/lib/supfiles/name.host
list of names of host machines acting
as name servers
.TP
.B /usr/lib/supfiles/coll.list
supfile used for -s flag
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/last
recorded list of files in collection as of last upgrade
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/lock
file used to lock collection
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/refuse
list of files to refuse in collection
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/when
recorded time of last upgrade
.TP
\fB/usr/\fR<\fIcollection\fR>
default base directory for file collection
.i0
.DT
.PP

Files needed on each name-server machine for the name server:
.TP
.B /usr/lib/supservers/coll.host
host name list for system collections
.i0
.DT
.PP

Files needed on each repository machine for the file server:
.TP
.B /usr/lib/supservers/coll.dir
base directory list for system
collections
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/crypt
data encryption key for a
collection. the owner of this file is the
default account used when data encryption is specified
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/host
list of remote hosts allowed to
upgrade a collection
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/list
list file for a collection
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/lock
lock file for a collection
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/logfile
log file for a collection
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/prefix
file containing the name of the prefix directory
for a collection
.TP
<\fIbase-directory\fR>\fB/sup/\fR<\fIcollection\fR>\fB/scan
scan file for a collection
.TP
\fB/usr/\fR<\fIcollection\fR>
default base directory for a file collection
.i0
.DT
.PP
.SH "SEE ALSO"
.IR supservers (8)
.br
\fIThe SUP Software Upgrade Protocol\fR, S. A. Shafer,
CMU Computer Science Department, 1985.
.SH "EXAMPLE"
<example>
.SH "BUGS"
The encryption mechanism should be strengthened, although it's
not trivial.
