.\"	@(#)spell.1	6.1 (Berkeley) 4/29/85
.\"
.TH SPELL 1 "April 29, 1985"
.AT 3
.SH NAME
spell, spellin, spellout \- find spelling errors
.SH SYNOPSIS
.B spell
[
.B \-v
] [
.B \-b
] [
.B \-x
] [
.B \-d
hlist ] [
.B \-s
hstop ] [
.B \-h
spellhist
] [ file ] ...
.PP
.B spellin
[ list ]
.PP
.B spellout
[
.B \-d
] list
.SH DESCRIPTION
.I Spell
collects words from the named documents,
and looks them up in a spelling list.
Words that neither occur among nor are derivable
(by applying certain inflections,
prefixes or suffixes) from words in the spelling list
are printed on the standard output.
If no files are named,
words are collected from the standard input.
.PP
.I Spell
ignores most
.I troff,
.I tbl
and
.IR  eqn (1)
constructions.
.PP
Under the
.B \-v
option, all words not literally in the spelling list are printed,
and plausible derivations from spelling list words are indicated.
.PP
Under the 
.B \-b
option, British spelling is checked.
Besides preferring
.ft I
centre, colour, speciality, travelled,
.ft R
etc.,
this option insists upon
.I -ise
in words like
.I standardise,
Fowler and the OED to the contrary notwithstanding.
.PP
Under the 
.B \-x
option, every plausible stem is printed with `=' for each word.
.PP
The spelling list is based on many sources.
While it is more haphazard than an ordinary
dictionary, it is also more effective with
proper names and popular technical words.
Coverage of
the specialized vocabularies of biology,
medicine and chemistry is light.
.PP
The auxiliary files used for the spelling list,
stop list, and history file may be specified by
arguments following the
.BR \-d ,
.BR \-s ,
and
.B \-h
options.
The default files are indicated below.
Copies of all output
may be accumulated in the history file.
The stop list filters out misspellings (e.g. thier=thy\-y+ier)
that would otherwise pass.
.PP
Two routines help maintain the hash lists used by
.I spell.
Both expect a set of words, one per line,
from the standard input.
.I Spellin
combines the words from the standard input and the
preexisting
.I list
file and places a new list on the standard output.
If no 
.I list
file is specified, the new list is created from scratch.
.I Spellout
looks up each word from the standard input and prints
on the standard output
those that are missing from (or present on, with
option
.BR \-d )
the hashed
.I list
file.
For example, to verify that
.I hookey
is not on the default spelling list, add it to your own
private list, and then use it with
.IR spell ,
.PP
.RS
.nf
echo  hookey  |  spellout  /usr/dict/hlista
echo  hookey  |  spellin  /usr/dict/hlista  >  myhlist
spell  \-d  myhlist  huckfinn
.RE
.SH FILES
/usr/dict/hlist[ab]	hashed spelling lists, American & British, default for
.B \-d
.br
/usr/dict/hstop		hashed stop list, default for
.B \-s
.br
/dev/null		history file, default for
.B \-h
.br
/tmp/spell.$$\(**		temporary files
.br
/usr/lib/spell
.br
.SH SEE ALSO
deroff(1), sort(1), tee(1), sed(1)
.SH BUGS
The spelling list's coverage is uneven;
new installations will probably wish to 
monitor the output for several months to gather
local additions.
.br
British spelling was done by an American.
