.\"	@(#)troff.1	6.1 (Berkeley) 4/29/85
.\"
.TH TROFF 1 "April 29, 1985"
.AT 3
.SH NAME
troff, nroff \- text formatting and typesetting
.SH SYNOPSIS
.B troff
[ option ] ...
[ file ] ...
.PP
.B nroff
[ option ] ...
[ file ] ...
.SH DESCRIPTION
.I Troff
formats text in the named
.I files
for printing on a Graphic Systems C/A/T phototypesetter;
.I nroff
is used for for typewriter-like devices.
Their capabilities are described in the
.I Nroff/Troff user's manual.
.PP
If no
.I file
argument is present, the standard input is read.
An argument consisting of a single minus
.RB ( \- )
is taken to be a file name corresponding to the standard input.
The options, which may appear in any order so long as they appear
before the files, are:
.TP "\w'\f3\-m\f1name 'u"
.BI \-o list
Print only pages whose page numbers appear in the comma-separated
.I list
of numbers and ranges.
A range
.IB N \- M
means pages
.I N
through
.IR M ;
an initial
.I \-N
means from the beginning to page
.IR N ;
and a final
.IR N \-
means from
.I N
to the end.
.TP
.BI \-n N
Number first generated page
.IR N .
.TP
.BI \-s N
Stop every
.I N
pages.
.I Nroff
will halt prior to every
.I N
pages (default
.IR N =1)
to allow paper loading or changing, and will resume upon receipt of a newline.
.I Troff
will stop the phototypesetter every
.I N
pages, produce a trailer to allow changing cassettes,
and resume when the typesetter's start button is pressed.
.TP
.BI \-m name
Prepend the macro file
.BI /usr/lib/tmac/tmac. name
to the input
.IR files .
.TP
.BI \-r aN
Set register
.I a
(one-character) to
.IR N .
.TP
.B \-i
Read standard input after the input files are exhausted.
.TP
.B \-q
Invoke the simultaneous input-output mode of the
.B rd
request.
.HP
.bd I 3
.I Troff only
.br
.bd I
.TP
.B \-t
Direct output to the standard output instead of the phototypesetter.
.TP
.B \-f
Refrain from feeding out paper and stopping
phototypesetter at the end of the run.
.TP
.B \-w
Wait until phototypesetter is available, if currently busy.
.TP
.B \-b
Report whether the phototypesetter is busy or available.
No text processing is done.
.TP
.B \-a
Send a printable ASCII approximation of the results to the standard output.
.TP
.BR \-p N
Print all characters in point size
.I  N
while retaining all prescribed spacings and motions,
to reduce phototypesetter elapsed time.
.TP
.BI \-F fontdir
The directory
.I fontdir
contains the font width tables instead of the default directory
/usr/lib/fonts. This option can be used to produce output for devices
besides the phototypesetter.
.PP
If the file
.I /usr/adm/tracct
is writable,
.I troff
keeps phototypesetter accounting records there.
The integrity of that file may be secured by making
.I troff
a 'set user-id' program.
.SH FILES
.ta \w'/usr/lib/tmac/tmac.*  'u
/tmp/ta*	temporary file
.br
/usr/lib/tmac/tmac.*	standard macro files
.br
/usr/lib/term/*	terminal driving tables for
.I nroff
.br
/usr/lib/font/*	font width tables for
.I troff
.br
/dev/cat	phototypesetter
.br
/usr/adm/tracct	accounting statistics for /dev/cat
.SH "SEE ALSO"
J. F. Ossanna,
.I Nroff/Troff user's manual
.br
B. W. Kernighan,
.I
A TROFF Tutorial
.br
eqn(1), tbl(1), ms(7), me(7), man(7), col(1)
