.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)nroff.1	6.2 (Berkeley) 9/17/87
.\"
.TH NROFF 1 "September 17, 1987"
.UC 5
.SH NAME
nroff \- text formatting
.SH SYNOPSIS
.B nroff
[ option ] ...
[ file ] ...
.SH DESCRIPTION
.I Nroff
formats text in the named
.I files
for typewriter-like devices.  See also 
.I troff(1).
The full capabilities of
.I nroff
are described in the
.I Nroff/Troff User's Manual.
.PP
If no
.I file
argument is present, the standard input is read.
An argument consisting of a single minus
.RB ( \- )
is taken to be a file name corresponding to the standard input.
.PP
The options, which may appear in any order so long as they appear
.I before
the files, are:
.TP "\w'\f3\-m\f1name 'u"
.BI \-o list
Print only pages whose page numbers appear in the comma-separated
.I list
of numbers and ranges.  A range
.IB N \- M
means pages
.I N
through
.IR M ;
an initial
.I \-N
means from the beginning to page
.IR N ;
and a final
.IR N \-
means from
.I N
to the end.
.TP
.BI \-n N
Number first generated page
.IR N .
.TP
.BI \-s N
Stop every
.I N
pages.
.I Nroff
will halt prior to every
.I N
pages (default
.IR N =1)
to allow paper loading or changing, and will resume upon receipt of a newline.
.TP
.BI \-m name
Prepend the macro file
.BI /usr/lib/tmac/tmac. name
to the input
.IR files .
.TP
.BI \-r aN
Set register
.I a
(one-character) to
.IR N .
.TP
.B \-i
Read standard input after the input files are exhausted.
.TP
.B \-q
Invoke the simultaneous input-output mode of the
.B rd
request.
.TP
.BI \-T name
Prepare output for specified terminal.  Known \fInames\fP are:
.PP
.RS
.TP
.BR 37
for the Teletype Corporation Model 37 terminal,
.TP
.BR crt
the default; linked to lpr and tn300, for the GE TermiNet 300 (or any
terminal without reverse-line or half-line capability),
.TP
.BR 300
for the DTC 300,
.TP
.BR 302
for the DTC 302S and the DTC 300S,
.TP
.BR 382
for the DTC 382,
.TP
.BR 450
for the DTC 450 and the IPSI 1622,
.TP
.BR 833
for the AJ 832/833,
.TP
.BR epson
for the Epson FX80,
.TP
.BR itoh
for the C:ITOH Prowriter
.TP
.BR nec
for the NEC-55?0/77?0 Spinwriter, with the Courier-72/Manifold
thimble,
.TP
.BR nec-t
for the NEC-55?0/77?0 Spinwriter, with the Tech-Math/Times-Roman
thimble,
.TP
.BR nec25-t
for the NEC-5525/7725 Spinwriter, with the Tech-Math/Times-Roman
thimble,
.TP
.BR qume
for the Qume Sprint 5 or 9,
.TP
.BR x-ecs
for the Xerox/Diablo 1730/630, extended character set,
.TP
.BR xerox
for the Xerox 17?0 or the Diablo 16?0.

Most of these also have versions for 12 pitch; see
\fI/usr/lib/term/README\fP for more information.
.RE
.PP
.TP
.B \-e
Produce equally-spaced words in adjusted lines, using full terminal resolution.
.TP
.B \-h
Use output tabs during horizontal spacing
to speed output and reduce output character count.
Tab settings are assumed to be every 8 nominal character widths.
.SH FILES
.ta \w'/usr/lib/tmac/tmac.*  'u
/tmp/ta*	temporary file
.br
/usr/lib/tmac/tmac.*	standard macro files
.br
/usr/lib/term/*	terminal driving tables for
.I nroff
.br
.SH "SEE ALSO"
J. F. Ossanna,
.I Nroff/Troff user's manual
.br
B. W. Kernighan,
.I A TROFF Tutorial
.br
troff(1),
eqn(1),
tbl(1),
ms(7),
me(7),
man(7),
col(1)
