.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)sortbib.1	6.1 (Berkeley) 4/29/85
.\"
.TH SORTBIB 1 "April 29, 1985"
.UC 5
.SH NAME
sortbib \- sort bibliographic database
.SH SYNOPSIS
.B sortbib
[
.BR \-s KEYS
] database  ...
.SH DESCRIPTION
.I Sortbib
sorts files of records containing
.I refer
key-letters by user-specified keys.
Records may be separated by blank lines,
or by \&.[ and \&.] delimiters,
but the two styles may not be mixed together.
This program reads through each
.I database
and pulls out key fields, which are sorted separately.
The sorted key fields contain the file pointer,
byte offset, and length of corresponding records.
These records are delivered using disk seeks and reads, so
.I sortbib
may not be used in a pipeline to read standard input.
.PP
By default,
.I sortbib
alphabetizes by the first %A and the %D fields,
which contain the senior author and date.
The
.B \-s
option is used to specify new
.IR \s-1KEYS\s0 .
For instance,
.BR \-s ATD
will sort by author, title, and date,
while
.BR \-s A+D
will sort by all authors, and date.
Sort keys past the fourth are not meaningful.
No more than 16 databases may be sorted together at one time.
Records longer than 4096 characters will be truncated.
.PP
.I Sortbib
sorts on the last word on the %A line,
which is assumed to be the author's last name.
A word in the final position, such as ``jr.'' or ``ed.'',
will be ignored if the name beforehand ends with a comma.
Authors with two-word last names or unusual constructions
can be sorted correctly by using the
.I nroff
convention ``\e0'' in place of a blank.
A %Q field is considered to be the same as %A,
except sorting begins with the first, not the last, word.
.I Sortbib
sorts on the last word of the %D line, usually the year.
It also ignores leading articles (like ``A'' or ``The'')
when sorting by titles in the %T or %J fields;
it will ignore articles of any modern European language.
If a sort-significant field is absent from a record,
.I sortbib
places that record before other records containing that field.
.SH SEE ALSO
refer(1), addbib(1), roffbib(1), indxbib(1), lookbib(1)
.SH AUTHORS
Greg Shenaut, Bill Tuthill
.SH BUGS
Records with missing author fields
should probably be sorted by title.
