.TH RCS 1 6/29/83 "Purdue University"
.SH NAME
rcs \- change RCS file attributes
.SH SYNOPSIS
.B rcs
[ options ]
file ... 
.SH DESCRIPTION
.I Rcs
creates new RCS files or changes attributes of existing ones.
An RCS file contains multiple revisions of text,
an access list, a change log, 
descriptive text,
and some control attributes.
For \fIrcs\fR to work, the caller's login name must be on the access list,
except if the access list is empty, the caller is the owner of the file
or the superuser, or
the \fB-i\fR option is present. 
.PP
Files ending in `,v' are RCS files, all others are working files. If
a working file is given, \fIrcs\fR tries to find the corresponding
RCS file first in directory ./RCS and then in the current directory,
as explained in \fIco\fR (1).
.TP 11
.B \-i
creates and initializes a new RCS file, but does not deposit any revision.
If the RCS file has no path prefix, \fIrcs\fR tries to place it
first into the subdirectory ./RCS, and then into the current directory.
If the RCS file
already exists, an error message is printed.
.TP
.BI \-a "logins"
appends the login names appearing in the comma-separated list \fIlogins\fR
to the access list of the RCS file.
.TP
.BI \-A "oldfile"
appends the access list of \fIoldfile\fR to the access list of the RCS file. 
.TP
.B \-e\fR[\fIlogins\fR]
erases the login names appearing in the comma-separated list \fIlogins\fR
from the access list of the RCS file.
If \fIlogins\fR is omitted, the entire access list is erased.
.TP
.BI \-c "string"
sets the comment leader to \fIstring\fR. The comment leader
is printed before every log message line generated by the keyword 
$\&Log$  during checkout (see \fIco\fR). This is useful for programming 
languages without multi-line comments. During \fIrcs -i\fR or initial 
\fIci\fR, the comment leader is guessed from the suffix of the working file. 
.TP
.B \-l\fR[\fIrev\fR]
locks the revision with number \fIrev\fR.
If a branch is given, the latest revision on that branch is locked.
If \fIrev\fR is omitted, the latest revision on the trunk is locked.
Locking prevents overlapping changes.
A lock is removed with \fIci\fR or \fIrcs -u\fR (see below).
.TP
.B \-u\fR[\fIrev\fR]
unlocks the revision with number \fIrev\fR.
If a branch is given, the latest revision on that branch is unlocked.
If \fIrev\fR is omitted, the latest lock held by the caller is removed.
Normally, only the locker of a revision may unlock it.
Somebody else unlocking a revision breaks the lock. 
This causes a mail message to be sent to the original locker.
The message contains a commentary solicited from the breaker.
The commentary is terminated with a line containing a single `.' or
control-D.
.TP
.B \-L
sets locking to \fIstrict\fR. Strict locking means that the owner
of an RCS file is not exempt from locking for checkin.
This option should be used for files that are shared.
.TP
.B \-U
sets locking to non-strict. Non-strict locking means that the owner of
a file need not lock a revision for checkin. 
This option should NOT be used for files that are shared.
The default (\fB-L\fR or \fB-U\fR) is determined by your system administrator.
.TP
.B \-n\fIname\fR[:\fIrev\fR]
associates the symbolic name \fIname\fR with the branch or
revision \fIrev\fR. 
\fIRcs\fR prints an error message if \fIname\fR is already associated with
another number.
If \fIrev\fR is omitted, the symbolic name is deleted.
.TP
.B \-N\fIname\fR[:\fIrev\fR]
same as \fB-n\fR, except that it overrides a previous assignment of 
\fIname\fR.
.TP
.BI \-o "range"
deletes ("outdates") the revisions given by \fIrange\fR.
A range consisting of a single revision number means that revision.
A range consisting of a branch number means the latest revision on that
branch.
A range of the form \fIrev1\-rev2\fR means 
revisions \fIrev1\fR to \fIrev2\fR on the same branch, 
\fI\-rev\fR means from the beginning of the branch containing
\fIrev\fR up to and including \fIrev\fR, and \fIrev\-\fR means
from revision \fIrev\fR to the end of the branch containing \fIrev\fR.
None of the outdated revisions may have branches or locks.
.TP
.B \-q
quiet mode; diagnostics are not printed.
.TP
.B \-s\fIstate\fR[:\fIrev\fR]
sets the state attribute of the revision \fIrev\fR to \fIstate\fR. 
If \fIrev\fR is omitted, the latest revision on the trunk is assumed;
If \fIrev\fR is a branch number, the latest revision on that branch is
assumed.
Any identifier is acceptable for \fIstate\fR.
A useful set of states
is \fIExp\fR (for experimental), \fIStab\fR (for stable), and \fIRel\fR (for
released).
By default, \fIci\fR sets the state of a revision to \fIExp\fR.
.TP
.B \-t\fR[\fItxtfile\fR]
writes descriptive text into the RCS file (deletes the existing text).
If \fItxtfile\fR is omitted, 
\fIrcs\fR prompts the user for text supplied from the std. input,
terminated with a line containing a single `.' or control-D.
Otherwise, the descriptive text is copied from the file \fItxtfile\fR.
If the \fB-i\fR option is present, descriptive text is requested
even if \fB-t\fR is not given.
The prompt is suppressed if the std. input is not a terminal.
.SH DIAGNOSTICS
The RCS file name and the revisions outdated are written to
the diagnostic output.
The exit status always refers to the last RCS file operated upon,
and is 0 if the operation was successful, 1 otherwise.
.SH FILES
The caller of the command
must have read/write permission for the directory containing
the RCS file and read permission for the RCS file itself.
.I Rcs
creates a semaphore file in the same directory as the RCS
file to prevent simultaneous update.
For changes, \fIrcs\fR always creates a new file. On successful completion,
\fIrcs\fR deletes the old one and renames the new one.
This strategy makes links to RCS files useless.
.SH IDENTIFICATION
.de VL
\\$2
..
Author: Walter F. Tichy,
Purdue University, West Lafayette, IN, 47907.
.sp 0
Revision Number:
.VL $Revision: 1.1 $
; Release Date:
.VL $Date: 89/10/12 16:24:31 $
\&.
.sp 0
Copyright \(co 1982 by Walter F. Tichy.
.SH SEE ALSO
co (1), ci (1), ident(1), rcsdiff (1), rcsintro (1), rcsmerge (1), rlog (1), rcsfile (5), sccstorcs (8).
.sp 0
Walter F. Tichy, "Design, Implementation, and Evaluation of a Revision Control
System," in \fIProceedings of the 6th International Conference on Software
Engineering\fR, IEEE, Tokyo, Sept. 1982.
.SH BUGS




