.\"	@(#)ptx.1	6.1 (Berkeley) 4/29/85
.\"
.TH PTX 1 "April 29, 1985"
.AT 3
.SH NAME
ptx \- permuted index
.SH SYNOPSIS
.B ptx
[ option ] ...
[ input [ output ] ]
.SH DESCRIPTION
.I Ptx
generates a permuted index to file
.I input
on file
.I output
(standard input and output default).
It has three phases: the first does the permutation, generating
one line for each keyword in an input line.
The keyword is rotated to the front.
The permuted file is then
sorted.
Finally, the sorted lines are rotated so the keyword
comes at the middle of the page.
.I Ptx
produces output in the form:
.br
.IP
\&.xx "tail" "before keyword" "keyword and after" "head"
.LP
where .xx may be an
.I nroff
or
.IR troff (1)
macro
for user-defined formatting.
The
.I before keyword
and
.I keyword and after
fields incorporate as much of the line as will fit
around the keyword when it is printed at the middle of the page.
.I Tail
and
.I head,
at least one of which is an empty string "",
are wrapped-around pieces small enough to fit
in the unused space at the opposite end of the line.
When original text must be discarded, `/' marks the spot.
.PP
The following options can be applied:
.TP
.BR \-f
Fold upper and lower case letters for sorting.
.TP 
.BR \-t
Prepare the output for the phototypesetter;
the default line length is 100 characters.
.TP 
.BI \-w " n"
Use the next argument,
.I n,
as the width of the output line.
The default line length is 72 characters.
.TP
.BI \-g " n"
Use the next argument,
.I n,
as the number of characters to allow for each gap
among the four parts of the line as finally printed.
The default gap is 3 characters.
.TP 
.BR \-o " only"
Use as keywords only the words given in the \fIonly\fR file.
.TP 
.BR \-i " ignore"
Do not use as keywords any words given in the
.I
ignore
file.
If the \fB\-i\fR and \fB\-o\fR options are missing, use
.I /usr/lib/eign
as the 
.I
ignore
file.
.TP 
.BR \-b " break"
Use the characters in the 
.I
break
file to separate words.
In any case, tab, newline, and space characters are always used as break characters.
.TP
.BR \-r
Take any leading nonblank characters of each input line to
be a reference identifier (as to a page or chapter)
separate from the text of the line.
Attach that identifier as a 5th field on each output line.
.PP
The index for this manual was generated using
.I ptx.
.SH FILES
/usr/bin/sort
.br
/usr/lib/eign
.SH BUGS
Line length counts do not account for overstriking or
proportional spacing.
.br
