.\"	@(#)m4.1	6.1 (Berkeley) 4/29/85
.\"
.TH M4 1 "April 29, 1985"
.AT 3
.SH NAME
m4 \- macro processor
.SH SYNOPSIS
.B m4
[ files ]
.SH DESCRIPTION
.I M4
is a macro processor intended as a front end for Ratfor, C, and other languages.
Each of the argument files is processed in order;
if there are no arguments, or if an argument is `\-',
the standard input is read.
The processed text is written on the standard output.
.PP
Macro calls have the form
.PP
	name(arg1,arg2, . . . , argn)
.br
.PP
The `(' must immediately follow the name of the macro.
If a defined macro name is not followed by a `(',
it is deemed to have no arguments.
Leading unquoted blanks, tabs, and newlines are ignored while collecting
arguments.  Potential macro names consist of alphabetic letters,
digits, and underscore `\_', where the first character is not a digit.
.PP
Left and right single quotes (\`\|\') are used to quote strings.
The value of a quoted string is the string stripped of the quotes.
.PP
When a macro name is recognized, its arguments are collected by searching
for a matching right parenthesis.
Macro evaluation proceeds normally during the collection of the arguments,
and any commas or right parentheses which happen to turn up within the value
of a nested call are as effective as those in the original input text.
After argument collection, the value of the macro is pushed back onto the
input stream and rescanned.
.PP
.I M4
makes available the following built-in macros.
They may be redefined, but once this is done the original meaning is lost.
Their values are null unless otherwise stated.
.TP 10
.B define
The second argument is installed as the value of the macro
whose name is the first argument.
Each occurrence of $\fIn\fR in the replacement text, where
.I n
is a digit, is replaced by the
.IR n -th
argument.  Argument 0 is the name of the macro;
missing arguments are replaced by the null string.
.TP
.B undefine
removes the definition of the macro named in its argument.
.TP
.B ifdef
If the first argument is defined, the value is the second argument,
otherwise the third.  If there is no third argument, the value is null.
The word
.I unix
is predefined on UNIX versions of
.IR m4 .
.TP
.B changequote
Change quote characters to the first and second arguments.
.I Changequote
without arguments restores the original values (i.e., \`\|\').
.TP
.B divert
.I M4
maintains 10 output streams, numbered 0-9.
The final output is the concatenation of the streams in numerical order;
initially stream 0 is the current stream.  The
.I divert
macro changes the current output stream to its (digit-string) argument.
Output diverted to a stream other than 0 through 9 is discarded.
.TP
.B undivert
causes immediate output of text from diversions named as
arguments, or all diversions if no argument.
Text may be undiverted into another diversion.
Undiverting discards the diverted text.
.TP
.B divnum
returns the value of the current output stream.
.TP
.B dnl
reads and discards characters up to and including the next newline.
.TP
.B ifelse
has three or more arguments.
If the first argument is the same string as the second,
then the value is the third argument.
If not, and if there are more than four arguments, the process is repeated with arguments 4, 5, 6 and 7.
Otherwise, the value is either the fourth string, or, if it is not present,
null.
.TP
.B incr
returns the value of its argument incremented by 1.
The value of the argument is calculated
by interpreting an initial digit-string as a decimal number.
.TP
.B eval
evaluates its argument as an arithmetic expression, using 32-bit arithmetic.
Operators include +, \-, \(**, /, %, ^ (exponentiation); relationals;
parentheses.
.TP
.B len
returns the number of characters in its argument.
.TP
.B index
returns the position in its first argument where the second argument
begins (zero origin), or \-1 if the second argument does not occur.
.TP
.B substr
returns a substring of its first argument.
The second argument is a zero origin number selecting the first character;
the third argument indicates the length of the substring.
A missing third argument is taken to be large enough to extend to
the end of the first string.
.TP
.B translit
transliterates the characters in its first argument
from the set given by the second argument to the set given by the third.
No abbreviations are permitted.
.TP
.B include
returns the contents of the file named in the argument.
.TP
.B sinclude
is identical to
.I include,
except that it says nothing if the file is inaccessible.
.TP
.B syscmd
executes the UNIX command given in the first argument.
No value is returned.
.TP
.B maketemp
fills in a string of XXXXX in its argument with the current process id.
.TP
.B errprint
prints its argument on the diagnostic output file.
.TP
.B dumpdef
prints current names and definitions,
for the named items, or for all if no arguments are given.
.dt
.SH "SEE ALSO"
B. W. Kernighan and D. M. Ritchie,
.I The M4 Macro Processor
