.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)lorder.1	6.1 (Berkeley) 4/29/85
.\"
.TH LORDER 1 "April 29, 1985"
.UC 4
.SH NAME
lorder \- find ordering relation for an object library
.SH SYNOPSIS
.B lorder
file ...
.SH DESCRIPTION
The input
is one or more object or library archive (see
.IR ar (1))
.I files.
The standard output
is a list of pairs of object file names,
meaning that the first file of the pair refers to
external identifiers defined in the second.
The output may be processed by
.IR  tsort (1)
to find an ordering of
a library suitable for one-pass access by
.IR  ld (1).
.PP
This brash one-liner intends to build a new library
from existing `.o' files.
.IP
ar cr library \`\|lorder *.o | tsort\`
.PP
The need for lorder may be vitiated by use of 
.IR ranlib (1),
which converts an ordered archive into a randomly
accessed library.
.SH FILES
*symref, *symdef
.br
nm(1), sed(1), sort(1), join(1)
.SH "SEE ALSO"
tsort(1),
ld(1),
ar(1),
ranlib(1)
.SH BUGS
The names of object files, in and out of libraries, must end with `.o';
nonsense results otherwise.
