.\"	@(#)learn.1	6.2 (Berkeley) 5/15/86
.\"
.TH LEARN 1 "May 15, 1986"
.AT 3
.SH NAME
learn \- computer aided instruction about UNIX
.SH SYNOPSIS
.B learn
[
.BR \- directory
]
[ subject [ lesson ] ]
.SH DESCRIPTION
.I Learn
gives Computer Aided Instruction courses and
practice in the use of UNIX, the C Shell,
and the Berkeley text editors.
To get started simply type
.BR learn .
If you had used
.I learn
before and left your last session without completing a subject,
the program will use information in $HOME/.learnrc to start you up
in the same place you left off.
Your first time through,
.I learn
will ask questions to find out what you want to do.
Some questions may be bypassed by naming a
.IR subject ,
and more yet by naming a
.IR lesson .
You may enter the
.I lesson
as a number that
.I learn
gave you in a previous session.
If you do not know the lesson number,
you may enter the
.I lesson
as a word, and
.I learn
will look for the first lesson containing it.
If the
.I lesson
is `\fB\-\fP',
.I learn
prompts for each lesson;
this is useful for debugging.
.PP
The
.IR subject \|'s
presently handled are
.if n .sp 1v
.if t .sp .5v
.nf
.in +0.5i
files
editor
vi
morefiles
macros
eqn
C
.in -0.5i
.fi
.PP
There are a few special commands.
The command `bye' terminates a 
.I learn
session and `where' tells you of your progress,
with `where\0m' telling you more.
The command `again' re-displays the text of the lesson
and `again\0\fIlesson\fP' lets you review
.IR lesson .
There is no way for
.I learn
to tell you the answers it expects in English, however,
the command `hint' prints the last part of the lesson script
used to evaluate a response, while `hint m' prints the
whole lesson script.
This is useful for debugging
lessons and might possibly give you an idea about what it expects.
.PP
The
.BI \- directory
option allows one to exercise a script in
a nonstandard place.
.SH FILES
/usr/lib/learn	subtree for all dependent directories and files
.br
/usr/tmp/pl\(**	playpen directories
.br
$HOME/.learnrc	startup information
.SH SEE ALSO
csh(1), ex(1)
.br
B. W. Kernighan and M. E. Lesk, \fILEARN \- Computer-Aided Instruction on UNIX\fR
.SH BUGS
The main strength of
.I learn,
that it asks the student to use the real UNIX,
also makes possible baffling mistakes.
It is helpful, especially for nonprogrammers,
to have a UNIX initiate near at hand during the first
sessions.
.PP
Occasionally lessons are incorrect, sometimes because the local version
of a command operates in a non-standard way.
Occasionally a lesson script does not recognize all the different
correct responses, in which case the `hint' command may be useful.
Such lessons may be skipped with the `skip' command,
but it takes some sophistication to recognize the situation.
.PP
To find a
.I lesson
given as a word,
.I learn
does a simple
.IR fgrep (1)
through the lessons.
It is unclear whether this sort
of subject indexing is better than none.
.PP
Spawning a new shell is required for each of many
user and internal functions.
.PP
The `vi' lessons are provided separately from the others.
To use them see your system administrator.
