.\"	@(#)graph.1g	6.1 (Berkeley) 4/29/85
.\"
.TH GRAPH 1G "April 29, 1985"
.AT 3
.SH NAME
graph \- draw a graph
.SH SYNOPSIS
.B graph
[ option ] ...
.SH DESCRIPTION
.I Graph
with no options takes pairs of numbers from the
standard input as abscissas and
ordinates of a graph.
Successive points are connected by straight lines.
The graph is encoded on the standard output
for display by the
.IR  plot (1G)
filters.
.PP
If the coordinates of a point are followed by
a nonnumeric string, that string is printed as a
label beginning on the point.
Labels may be surrounded with quotes "...", in
which case they may be empty or contain blanks
and numbers;
labels never contain newlines.
.PP
The following options are recognized,
each as a separate argument.
.TP
.B  \-a
Supply abscissas automatically (they are missing from
the input); spacing is given by the next
argument (default 1).
A second optional argument is the starting point for
automatic abscissas (default 0 or lower limit given by
.BR \-x ).
.TP
.B  \-b
Break (disconnect) the graph after each label in the input.
.TP
.B  \-c
Character string given by next argument
is default label for each point.
.TP
.B  \-g
Next argument is grid style,
0 no grid, 1 frame with ticks, 2 full grid (default).
.TP
.B  \-l
Next argument is label for graph.
.TP
.B  \-m
Next argument is mode (style)
of connecting lines:
0 disconnected, 1 connected (default).
Some devices give distinguishable line styles
for other small integers.
.TP
.B  \-s
Save screen, don't erase before plotting.
.TP
\fB\-x\fR [ \fBl\fR ]
If
.B l
is present, x axis is logarithmic.
Next 1 (or 2) arguments are lower (and upper)
.IR x ""
limits.
Third argument, if present, is grid spacing on 
.I x
axis.
Normally these quantities are determined automatically.
.TP
\fB\-y\fR [ \fBl\fR ]
Similarly for
.IR y .
.TP
.B  \-h
Next argument is fraction of space for height.
.TP
.B  \-w
Similarly for width.
.TP
.B  \-r
Next argument is fraction of space to move right before plotting.
.TP
.B  \-u
Similarly to move up before plotting.
.TP
.B  \-t
Transpose horizontal and vertical axes.
(Option
.B \-x
now applies to the vertical axis.)
.PP
A legend indicating grid range is produced
with a grid unless the
.B \-s
option is present.
.PP
If a specified lower limit exceeds the upper limit,
the axis
is reversed.
.SH "SEE ALSO"
spline(1G), plot(1G)
.SH BUGS
.I Graph
stores all points internally and drops those for which
there isn't room.
.br
Segments that run out of bounds are dropped, not windowed.
.br
Logarithmic axes may not be reversed.
