.\" Copyright (c) 1985 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)find.1	6.4 (Berkeley) 7/21/88
.\"
.TH FIND 1 "July 21, 1988"
.AT 3
.SH NAME
find \- find files
.SH SYNOPSIS
.B find
pathname-list expression
.br 
.B find
pattern
.SH DESCRIPTION
In the first form above,
.I find
recursively descends
the directory hierarchy for
each pathname in the
.I pathname-list
(i.e., one or more pathnames)
seeking files that match a boolean
.I expression
written in the primaries given below.
In the descriptions, the argument
.I n
is used as a decimal integer
where
.I +n
means more than
.I n,
.I \-n
means less than
.I n
and
.I n
means exactly
.IR n .
.PP
The second form rapidly searches a database for all pathnames
which match
.IR pattern .
Usually the database is recomputed
weekly and contains the pathnames
of all files which are publicly accessible.
If escaped, normal shell
\*(lqglobbing\*(rq characters (`*', `?', `[', and ']')
may be used in
.IR pattern ,
but the matching differs in that no characters
.RI ( e.g. " `/')"
have to be matched explicitly.
As a special case, a simple
.I pattern
containing no globbing characters
is matched as though it were
.IR *pattern* ;
if any globbing character appears
there are no implicit globbing characters.
.TP 10n
.BR \-name " filename"
True if the
.I filename
argument matches the current file name.
Normal
shell
argument syntax may be used if escaped (watch out for
`[', `?' and `*').
.TP
.BR \-perm " onum"
True if the file permission flags
exactly
match the
octal number
.I onum
(see
.IR  chmod (1)).
If
.I onum
is prefixed by a minus sign,
more flag bits (017777, see
.IR   stat (2))
become significant and
the flags are compared:
.IR (flags&onum)==onum .
.TP
.BR \-type " c"
True if the type of the file
is
.I c,
where
.I c
is
.B "b, c, d, f, l"
or
.B s
for
block special file, character special file,
directory, plain file, symbolic link, or socket.
.TP
.BR \-links " n"
True if the file has
.I n
links.
.TP
.BR \-user " uname"
True if the file belongs to the user
.I uname
(login name or numeric user ID).
.TP
.B \-nouser
True if the file belongs to a user
.I not
in the /etc/passwd database.
.TP
.BR \-group " gname"
True if the file belongs to group
.I gname
(group name or numeric group ID).
.TP
.B \-nogroup
True if the file belongs to a group
.I not
in the /etc/group database.
.TP
.BR \-size " n"
True if the file is
.I n
blocks long (512 bytes per block).
.TP
.BR \-inum " n"
True if the file has inode number
.I n.
.TP
.BR \-atime " n"
True if the file has been accessed in
.I n
days.
.TP
.BR \-mtime " n"
True if the file has been modified in
.I n
days.
.TP
.BR \-exec " command"
True if the executed command returns
a zero value as exit status.
The end of the command must be punctuated by an escaped
semicolon.
A command argument `{}' is replaced by the
current pathname.
.TP
.BR \-ok " command"
Like
.B \-exec
except that the generated command is written on
the standard output, then the standard input is read
and the command executed only upon response
.BR y .
.TP
.B  \-print
Always true;
causes the current pathname to be printed.
.TP
.B  \-ls
Always true;
causes current pathname to be printed together
with its associated statistics.
These include (respectively) inode number,
size in kilobytes (1024 bytes),
protection mode,
number of hard links,
user,
group,
size in bytes,
and modification time.
If the file is a special file
the size field will instead contain the major and minor
device numbers.
If the file is a symbolic link the
pathname of the linked-to file is printed preceded by ``->''.
The format is identical to that of ``ls -gilds''
(note however that formatting is done internally,
without executing the ls program).
.TP
.BR \-newer " file"
True if
the current file has been modified more recently than the argument
.I file.
.TP
.BR \-cpio " file"
Write the current file on the argument
.I file
in
.I cpio
format.
.TP
.B \-xdev
Always true;
causes find
.I not
to traverse down into a file system different
from the one on which current
.I argument
pathname resides.
.TP
.B \-follow
Always true;
causes find to traverse symbolic links to directories.
Normally find does not traverse symbolic links.
.PP
The primaries may be combined using the following operators
(in order of decreasing precedence):
.TP 4
1)
A parenthesized group of primaries and operators
(parentheses are special to the Shell and must be escaped).
.TP 4
2)
The negation of a primary
(`!' is the unary
.I not
operator).
.TP 4
3)
Concatenation of primaries
(the
.I and
operation
is implied by the juxtaposition of two primaries).
.TP 4
4)
Alternation of primaries
.RB "(`" \-o "' is the"
.I or
operator).
.SH EXAMPLES
.PP
To find all accessible files whose pathname contains `find':
.IP
find find
.PP
To typeset all variants of manual pages for `ls':
.IP 
vtroff -man `find '*man*/ls.?'`
.PP
To remove all files named
`a.out' or `*.o' that have not been accessed for a week:
.IP "" .2i
find / \e( \-name a.out \-o \-name '*.o' \e) \-atime +7 \-exec rm {} \e\;
.SH FILES
.nf
.ta \w'/usr/lib/find/find.codes     'u
/etc/passwd
/etc/group
/usr/lib/find/find.codes	coded pathnames database
.fi
.SH "SEE ALSO"
sh(1), test(1), fs(5)
.br
Relevant paper in February, 1983 issue of
.I ;login:.
.SH BUGS
The first form's syntax is painful, and
the second form's exact semantics is confusing and
can vary from site to site.
.PP
More than one `-newer' option does not work properly.
