.\"	@(#)efl.1	6.1 (Berkeley) 4/29/85
.\"
.TH EFL 1 "April 29, 1985"
.AT 3
.SH NAME
efl \- Extended Fortran Language
.SH SYNOPSIS
.B efl
[ option ... ]
[ filename ... ]
.SH DESCRIPTION
.I Efl
compiles a program written in the EFL language into clean Fortran.
.I Efl
provides the same control flow constructs as does
.IR ratfor (1),
which are essentially identical to those in C:
.TP
statement grouping with braces;
decision-making with if, if-else, and switch-case;
while,
for,
Fortran do,
repeat,
and repeat...until loops;
multi-level break and next.
In addition, EFL has C-like data structures,
and more uniform and convenient input/output syntax,
generic functions.
EFL also provides
some syntactic sugar to make programs easier to read and write:
.TP
free form input:
multiple statements/line; automatic continuation
statement label names (not just numbers),
.TP
comments:
# this is a comment
.TP
translation of relationals:
>, >=, etc., become .GT., .GE., etc.
.TP
return (expression)
returns expression to caller from function
.TP
define:
define name replacement
.TP
include:
include filename
.PP
.fi
The Efl command option
.B \-w
suppresses warning messages.
The option
.B \-C
causes comments to be copied through to the Fortran output (default);
.B \-#
prevents comments from being copied through.
If a command argument contains an embedded equal sign,
that argument is treated as if it had appeared in an
.B option
statement at the beginning of the program.
.I Efl
is best used with
.IR f77 (1).
.SH "SEE ALSO"
f77(1),
ratfor(1).
.br
S. I. Feldman,
.IR "The Programming Language EFL",
Bell Labs Computing Science Technical Report #78.
