.\"	@(#)diff3.1	6.2 (Berkeley) 8/20/85
.\"
.TH DIFF3 1 "August 20, 1985"
.AT 3
.SH NAME
diff3 \- 3-way differential file comparison
.SH SYNOPSIS
.B diff3
[
.B \-exEX3
]
file1 file2 file3
.SH DESCRIPTION
.I Diff3
compares three versions of a file,
and publishes disagreeing ranges of text
flagged with these codes:
.TP 16
====
all three files differ
.TP 16
====1
.IR file1 " is different"
.TP 16
====2
.IR file2 " is different"
.TP 16
====3
.IR file3 " is different"
.PP
The type of change suffered in converting a given range
of a given file to some other is
indicated in one of these ways:
.TP 16
.IB f " : " n1 " a"
Text is to be appended after line number
.I n1
in file
.I f,
where
.I f
= 1, 2, or 3.
.TP 16
.IB f " : " n1 " , " n2 " c"
Text is to be
changed in the range line
.I n1
to line
.IR n2 .
If 
.I n1
=
.I n2,
the range may be abbreviated to
.IR n1 .
.PP
The original contents of the range follows immediately
after a
.B c
indication.
When the contents of two
files are identical, the contents of the lower-numbered
file is suppressed.
.PP
Under the
.B \-e
option,
.I diff3
publishes a script for the editor
.I ed
that will incorporate into
.I file1
all changes between
.I file2
and
.I file3,
.IR i.e .
the changes that normally would be flagged ==== and ====3.
Option
.B \-x
(\fB\-3\fR)
produces a script to incorporate
only changes flagged ==== (====3).
The following command will apply the resulting script to
`file1'.
.PP
.ti 16n
(cat script; echo \'1,$p\') \(bv ed \- file1
.PP
The
.B \-E
and
.B \-X
are similar to
.B \-e
and
.BR \-x ,
respectively, but treat overlapping changes (i.e., changes that would
be flagged with ==== in the normal listing) differently.  The overlapping
lines from both files will be inserted by the edit script, bracketed
by "<<<<<<" and ">>>>>>" lines.
.PP
For example, suppose lines 7-8 are changed in both file1 and file2.
Applying the edit script generated by the command
.ce
"diff3 -E file1 file2 file3" 
.br
to file1 results in the file:
.RS
.nf

lines 1-6
of file1
<<<<<<< file1
lines 7-8
of file1
=======
lines 7-8
of file3
>>>>>>> file3
rest of file1
.fi
.RE
.PP
The
.B \-E
option is used by RCS
.IR merge (1)
to insure that overlapping changes in the merged files are preserved
and brought to someone's attention.
.SH FILES
/tmp/d3?????
.br
/usr/lib/diff3
.SH "SEE ALSO"
diff(1)
.SH BUGS
Text lines that consist of a single `.' will
defeat
.B \-e.
