.\"	@(#)crypt.1	6.2 (Berkeley) 7/14/87
.\"
.TH CRYPT 1 "July 14, 1987"
.AT 3
.SH NAME
crypt \- encode/decode
.SH SYNOPSIS
.B crypt
[ password ]
.SH DESCRIPTION
.I Crypt
reads from the standard input and writes
on the standard output.
The
.I password
is a key that selects a particular transformation.
If no
.I password 
is given,
.I crypt
demands a key from the terminal and turns
off printing while the key is being typed in.
.I Crypt
encrypts and decrypts with the same key:
.PP
	crypt key <clear >cypher
.br
	crypt key <cypher | pr
.PP
will print the clear.
.PP
Files encrypted by
.I crypt
are compatible with those treated by the editor
.I ed
in encryption mode.
.PP
The security of encrypted files depends on three factors:
the fundamental method must be hard to solve;
direct search of the key space must be infeasible;
`sneak paths' by which keys or cleartext can become
visible must be minimized.
.PP
.I Crypt
implements a one-rotor machine designed along the lines
of the German Enigma, but with a 256-element rotor.
Methods of attack on such machines are known, but not widely;
moreover the amount of work required is likely to be large.
.PP
The transformation of a key into the internal
settings of the machine is deliberately designed to
be expensive, i.e. to take a substantial fraction of
a second to compute.
However,
if keys are restricted to (say)
three lower-case letters,
then encrypted files can be read by expending only
a substantial fraction of
five minutes of machine time.
.PP
Since the key is an argument to the
.I crypt
command,
it is potentially visible to users executing
.IR ps (1)
or a derivative.
To minimize this possibility,
.I crypt
takes care to destroy any record of the key
immediately upon entry.
No doubt the choice of keys and key security
are the most vulnerable aspect of
.I crypt.
.SH FILES
/dev/tty for typed key
.SH "SEE ALSO"
ed(1),
crypt(3),
makekey(8)
.SH BUGS
There is no warranty of merchantability nor any warranty
of fitness for a particular purpose nor any other warranty,
either express or implied, as to the accuracy of the
enclosed materials or as to their suitability for any
particular purpose.  Accordingly, Bell Telephone
Laboratories assumes no responsibility for their use by the
recipient.   Further, Bell Laboratories assumes no obligation
to furnish any assistance of any kind whatsoever, or to
furnish any additional information or documentation.
