.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)at.1	6.2 (Berkeley) 3/20/86
.\"
.TH AT 1 "March 20, 1986"
.UC 4
.SH NAME
at \- execute commands at a later time
.SH SYNOPSIS
.B "at [ -c ] [ -s ] [ -m ]"
time
[ day ]
[ file ]
.SH DESCRIPTION
.I At
spools away a copy of the named
.I file
to be used as input to
.IR sh (1)
or
.IR csh (1).
If the
.B \-c
flag (for 
.IR (csh (1)))
or the
.B \-s
flag (for
.IR (sh (1)))
is specified, then that shell will be used to execute the job;
if no shell is specified, 
the current environment shell is used.
If no file name is specified, 
.I at
prompts for commands from standard input until a ^D is typed. 
.PP
If the 
.B \-m
flag is specified, mail will be sent to the user after the job
has been run. If errors occur during execution of the job, then
a copy of the error diagnostics will be sent to the user. If
no errors occur, then a short message is sent informing the
user that no errors occurred.
.PP
The format of the spool file is as follows:
A four line header that includes the owner of the job, the name of the job,
the shell used to run the job, and whether mail will be
set after the job is executed. The header is followed by a
.I cd
command to the current directory and a 
.I umask
command to set the modes on any files created by the job.
Then 
.I at
copies all relevant environment variables to the spool file.
When the script is run, it uses the user and group ID
of the creator of the spool file.
.PP
The
.I time
is 1 to 4 digits, with an optional following
`A', `P', `N' or `M' for
AM, PM, noon or midnight.
One and two digit numbers are taken to be hours, three and four digits
to be hours and minutes.
If no letters follow the digits, a 24 hour clock time is understood.
.PP
The optional
.I day
is either
(1) a month name followed by a day number,
or
(2) a day of the week; 
if the word `week' follows, invocation is moved
seven days further off.
Names of months and days may be recognizably truncated.
Examples of legitimate commands are
.IP
at 8am jan 24
.br
at -c -m 1530 fr week
.br
at -s -m 1200n week
.PP
.I At
programs are executed by periodic execution 
of the command 
.IR
/usr/lib/atrun 
from 
.IR cron (8).
The granularity of
.I at
depends upon the how often atrun is executed.
.PP
Error output is lost unless redirected or the
.I \-m
flag is requested, in which case a copy of the errors is sent to
the user via 
.IR mail (1).
.SH FILES
.nf
/usr/spool/at                spooling area
/usr/spool/at/yy.ddd.hhhh.*  job file
/usr/spool/at/past           directory where jobs are executed from
/usr/spool/at/lasttimedone   last time atrun was run
/usr/lib/atrun               executor (run by cron(8))
.fi
.SH "SEE ALSO"
atq(1),
atrm(1),
calendar(1),
sleep(1),
cron(8)
.SH DIAGNOSTICS
Complains about various syntax errors and times out of range.
.SH BUGS
Due to the granularity of the execution of
.IR /usr/lib/atrun,
there may be bugs in scheduling things almost
exactly 24 hours into the future.

If the system crashes, mail is not sent to the user informing them that
the job was not completed.

Sometimes old spool files are not removed from the directory
/usr/spool/at/past. This is usually due to a system crash,
and requires that they be removed by hand.
