.\" Copyright (c) 1987 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)install.1	6.5 (Berkeley) 7/9/88
.\"
.TH INSTALL 1 "July 9, 1988"
.UC 5
.SH NAME
install \- install binaries
.SH SYNOPSIS
.B install
[
.B \-c
] [
.B \-m
mode ] [
.B \-o
owner ] [
.B \-g
group ] [
.B \-s
] file1 file2; or file1 ... fileN directory
.SH DESCRIPTION
The file(s) are moved (or copied if the \fB-c\fP option is specified)
to the target file or directory.  If the destination is a directory, then
the \fIfile\fP is moved into \fIdirectory\fP with its original file-name.
If the target file already exists, it is overwritten.
.PP
The mode is set to 755; the \fB-m\fP option may be used to specify
an alternate mode.
.PP
The \fB-o\fP and \fB-g\fP options may be used to specify an owner
and/or group, respectively.
.PP
The \fB-s\fP option causes the file to be stripped.  It is an error
to attempt to strip a file not in the \fIa.out\fP format, but not to
attempt to strip a file that has already been stripped.
.PP
\fIInstall\fP refuses to move a file onto itself.
.PP
Installing ``/dev/null'' creates an empty file.
.SH "RETURN VALUE"
Upon successful completion a value of 0 is returned.  Otherwise, a
value of 1 is returned.
.SH "SEE ALSO"
chgrp(1), chmod(1), cp(1), mv(1), strip(1), a.out(5), chown(8)
