#ifdef REV_INFO
#ifndef lint
static char SCCSID[] = "OSF/Motif: @(#)wmloutdat.c	2.5 90/03/14";
#endif /* lint */
#endif /* REV_INFO */
/******************************************************************************
*******************************************************************************
*
*  (c) Copyright 1989, 1990, OPEN SOFTWARE FOUNDATION, INC.
*  (c) Copyright 1989, DIGITAL EQUIPMENT CORPORATION, MAYNARD, MASS.
*  ALL RIGHTS RESERVED
*  
*  	THIS SOFTWARE IS FURNISHED UNDER A LICENSE AND MAY BE USED
*  AND COPIED ONLY IN ACCORDANCE WITH THE TERMS OF SUCH LICENSE AND
*  WITH THE INCLUSION OF THE ABOVE COPYRIGHT NOTICE.  THIS SOFTWARE OR
*  ANY OTHER COPIES THEREOF MAY NOT BE PROVIDED OR OTHERWISE MADE
*  AVAILABLE TO ANY OTHER PERSON.  NO TITLE TO AND OWNERSHIP OF THE
*  SOFTWARE IS HEREBY TRANSFERRED.
*  
*  	THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT
*  NOTICE AND SHOULD NOT BE CONSTRUED AS A COMMITMENT BY OPEN SOFTWARE
*  FOUNDATION, INC. OR ITS THIRD PARTY SUPPLIERS  
*  
*  	OPEN SOFTWARE FOUNDATION, INC. AND ITS THIRD PARTY SUPPLIERS,
*  ASSUME NO RESPONSIBILITY FOR THE USE OR INABILITY TO USE ANY OF ITS
*  SOFTWARE .   OSF SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
*  KIND, AND OSF EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES, INCLUDING
*  BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
*  FITNESS FOR A PARTICULAR PURPOSE.
*  
*  Notice:  Notwithstanding any other lease or license that may pertain to,
*  or accompany the delivery of, this computer software, the rights of the
*  Government regarding its use, reproduction and disclosure are as set
*  forth in Section 52.227-19 of the FARS Computer Software-Restricted
*  Rights clause.
*  
*  (c) Copyright 1989, 1990, Open Software Foundation, Inc.  Unpublished - all
*  rights reserved under the Copyright laws of the United States.
*  
*  RESTRICTED RIGHTS NOTICE:  Use, duplication, or disclosure by the
*  Government is subject to the restrictions as set forth in subparagraph
*  (c)(1)(ii) of the Rights in Technical Data and Computer Software clause
*  at DFARS 52.227-7013.
*  
*  Open Software Foundation, Inc.
*  11 Cambridge Center
*  Cambridge, MA   02142
*  (617)621-8700
*  
*  RESTRICTED RIGHTS LEGEND:  This computer software is submitted with
*  "restricted rights."  Use, duplication or disclosure is subject to the
*  restrictions as set forth in NASA FAR SUP 18-52.227-79 (April 1985)
*  "Commercial Computer Software- Restricted Rights (April 1985)."  Open
*  Software Foundation, Inc., 11 Cambridge Center, Cambridge, MA  02142.  If
*  the contract contains the Clause at 18-52.227-74 "Rights in Data General"
*  then the "Alternate III" clause applies.
*  
*  (c) Copyright 1989, 1990, Open Software Foundation, Inc.
*  ALL RIGHTS RESERVED 
*  
*  
* Open Software Foundation is a trademark of The Open Software Foundation, Inc.
* OSF is a trademark of Open Software Foundation, Inc.
* OSF/Motif is a trademark of Open Software Foundation, Inc.
* Motif is a trademark of Open Software Foundation, Inc.
* DEC is a registered trademark of Digital Equipment Corporation
* DIGITAL is a registered trademark of Digital Equipment Corporation
* X Window System is a trademark of the Massachusetts Institute of Technology
*
*******************************************************************************
******************************************************************************/

/*
 * This module contains routines responsible for writing the .dat files
 * produced by WML. All files are written into the current directory.
 *
 * Input:
 *	The resolved objects
 *
 * Output:
 *	argument.dat
 *	reason.dat
 *	grammar.dat
 *
 *   The following empty files are also created, one for each token subclass
 *	color.dat
 *	font.dat
 *	identifier.dat
 *	keyword.dat
 *	literal.dat
 *	reserved.dat
 *	special.dat
 *	unused.dat
 *
 *   The following are also created, although not used by the main line WML
 *   processes
 *	value.dat
 *	boolean.dat
 *
 *    The charset.dat file is maintained manually.
 *
 */


#include "wml.h"

#ifdef NULL
#undef NULL
#endif
#include <stdio.h>


/*
 * Routines used only in this module
 */
void wmlOutputArgument ();
void wmlOutputReason ();
void wmlOutputGrammar ();
void wmlOutputEmpty ();
void wmlOutputValue ();
void wmlOutputBoolean ();

/*
 * globals
 */

static char		*canned_warn =
"/*\n\
**\tThis file is automatically generated.  Do not edit it by hand.\n\
**/\n\n";



/*
 * Output control routine, which simply outputs each file in turn.
 */

void wmlOutputDatFiles ()

{

wmlOutputArgument ();
wmlOutputReason ();
wmlOutputGrammar ();
wmlOutputEmpty ();
wmlOutputValue ();
wmlOutputBoolean ();

}



/*
 * Routine to write out Argument.dat
 */

void wmlOutputArgument ()

{

char			*canned1 =
"\n\
/*\n\
 *\tFormat:\n\
 *\t\t'{' argument-name sym_k-code internal-literal '}'\n\
 */\n";

FILE			*outfil;	/* output file */
int			ndx;		/* loop index */
WmlResourceDefPtr	resobj;		/* resource object */
WmlSynResourceDefPtr	synobj;		/* syntactic object */


/*
 * Open the output file.
 */
outfil = fopen ( "argument.dat", "w");
fprintf (outfil, canned_warn);
fprintf (outfil, canned1);

for ( ndx=0 ; ndx<wml_obj_arg_ptr->cnt ; ndx++ )
    {
    resobj = (WmlResourceDefPtr) wml_obj_arg_ptr->hvec[ndx].objptr;
    synobj = resobj->syndef;
    if ( synobj->int_lit != NULL )
	fprintf (outfil,
		 "\t{\t%s\t%d\t%s\t}\n",
		 synobj->name,
		 resobj->sym_code,
		 synobj->int_lit);
    else
	fprintf (outfil,
		 "\t{\t%s\t%d\t%s\t}\n",
		 synobj->name,
		 resobj->sym_code,
		 synobj->name);
    }

/*
 * close the output file
 */
printf ("\nCreated argument.dat");
fclose (outfil);

}



/*
 * Routine to write out Reason.dat
 */

void wmlOutputReason ()

{

char			*canned1 =
"\n\
/*\n\
 *\tFormat:\n\
 *\t\t'{' reason-name sym_k-code internal-literal '}'\n\
 */\n";

FILE			*outfil;	/* output file */
int			ndx;		/* loop index */
WmlResourceDefPtr	resobj;		/* resource object */
WmlSynResourceDefPtr	synobj;		/* syntactic object */


/*
 * Open the output file.
 */
outfil = fopen ( "reason.dat", "w");
fprintf (outfil, canned_warn);
fprintf (outfil, canned1);

for ( ndx=0 ; ndx<wml_obj_reason_ptr->cnt ; ndx++ )
    {
    resobj = (WmlResourceDefPtr) wml_obj_reason_ptr->hvec[ndx].objptr;
    synobj = resobj->syndef;
    if ( synobj->int_lit != NULL )
	fprintf (outfil,
		 "\t{\t%s\t%d\t%s\t}\n",
		 synobj->name,
		 resobj->sym_code,
		 synobj->int_lit);
    else
	fprintf (outfil,
		 "\t{\t%s\t%d\t%s\t}\n",
		 synobj->name,
		 resobj->sym_code,
		 synobj->name);
    }

/*
 * close the output file
 */
printf ("\nCreated reason.dat");
fclose (outfil);

}



/*
 * Routine to write out Grammar.dat
 */

void wmlOutputGrammar ()

{

char			*canned1 =
"\n\
/*\n\
 *\tFormat:\n\
 *\t\t'{' widget-class-name sym_k-code internal-literal '}'\n\
 */\n";

FILE			*outfil;	/* output file */
int			ndx;		/* loop index */
int			max;		/* maximum code value */
WmlClassDefPtr		clsobj;		/* class object */
WmlSynClassDefPtr	synobj;		/* syntactic object */


/*
 * Open the output file.
 */
outfil = fopen ( "grammar.dat", "w");
fprintf (outfil, canned_warn);
fprintf (outfil, canned1);

/*
 * create an entry for each widget
 */
for ( ndx=0 ; ndx<wml_obj_widget_ptr->cnt ; ndx++ )
    {
    clsobj = (WmlClassDefPtr) wml_obj_widget_ptr->hvec[ndx].objptr;
    synobj = clsobj->syndef;
    if ( synobj->int_lit != NULL )
	fprintf (outfil, "\t{\t%s\t%d\t%s\t}\n",
		 synobj->name,
		 clsobj->sym_code,
		 synobj->int_lit);
    else
	fprintf (outfil, "\t{\t%s\t%d\t%s\t}\n",
		 synobj->name,
		 clsobj->sym_code,
		 synobj->name);
    }

/*
 * close the output file
 */
printf ("\nCreated grammar.dat");
fclose (outfil);

}



/*
 * Routine to write all empty files.
 */

void wmlOutputEmpty ()

{

FILE			*outfil;	/* output file */

/*
 * Open and close each empty file
 */
outfil = fopen ("color.dat", "w");
fclose (outfil);
printf ("\nCreated color.dat (empty)");

outfil = fopen ("font.dat", "w");
fclose (outfil);
printf ("\nCreated font.dat (empty)");

outfil = fopen ("identifier.dat", "w");
fclose (outfil);
printf ("\nCreated identifier.dat (empty)");

outfil = fopen ("keyword.dat", "w");
fclose (outfil);
printf ("\nCreated keyword.dat (empty)");

outfil = fopen ("literal.dat", "w");
fclose (outfil);
printf ("\nCreated literal.dat (empty)");

outfil = fopen ("reserved.dat", "w");
fclose (outfil);
printf ("\nCreated reserved.dat (empty)");

outfil = fopen ("special.dat", "w");
fclose (outfil);
printf ("\nCreated special.dat (empty)");

outfil = fopen ("unused.dat", "w");
fclose (outfil);
printf ("\nCreated unused.dat (empty)");

}



/*
 * Routine to write out Value.dat
 */

void wmlOutputValue ()

{

FILE			*outfil;	/* output file */
int			ndx;		/* loop index */
WmlDataTypeDefPtr	datobj;		/* data type object */


/*
 * Open the output file.
 */
outfil = fopen ( "value.dat", "w");
fprintf (outfil, canned_warn);

/*
 * Write an entry for each datatype
 */
for ( ndx=0 ; ndx<wml_obj_datatype_ptr->cnt ; ndx++ )
    {
    datobj = (WmlDataTypeDefPtr) wml_obj_datatype_ptr->hvec[ndx].objptr;
    fprintf (outfil, "\t{\t%s\t}\n",
	     datobj->syndef->name);
    }

/*
 * close the output file
 */
printf ("\nCreated value.dat");
fclose (outfil);

}



/*
 * Routine to write out Boolean.dat
 */

void wmlOutputBoolean ()

{

char			*canned1 =
"\n\
        {       false   }\n\
        {       off     }\n\
        {       on      }\n\
        {       true    }\n\
\n";

FILE			*outfil;	/* output file */
int			ndx;		/* loop index */
WmlResourceDefPtr	resobj;		/* resource object */
WmlSynResourceDefPtr	synobj;		/* syntactic object */


/*
 * Open the output file and print the canned contents.
 */
outfil = fopen ( "boolean.dat", "w");
fprintf (outfil, canned_warn);
fprintf (outfil, canned1);

/*
 * close the output file
 */
printf ("\nCreated boolean.dat");
fclose (outfil);

}


