.\" **
.\" **  (c) Copyright 1989, 1990, 1991 Open Software Foundation, Inc.
.\" **      All Rights Reserved.
.\" **
.\" **  (c) Copyright 1987, 1988, 1989, by Hewlett-Packard Company
.\" **
.\" **  (c) Copyright 1987, 1988 by Digital Equipment Corporation,
.\" **      Maynard, MA.  All Rights Reserved.
.\" **
.\" **
.TH mwm 1X 
.SH NAME
\fBmwm\fP - The Motif Window Manager.
.iX "mwm"
.iX "window manager"
.SH SYNOPSIS
.B mwm
[\fIoptions\fP]
.SH DESCRIPTION
\fBmwm\fP
is an X Window System client that provides window
management functionality and some session management functionality.
It provides functions that facilitate control (by the user and the
programmer) of elements of window
states such as placement, size, icon/normal display, and input-focus ownership.
It also provides session management functions such as stopping a client.
.iX "session manager"
.SS Options
.IP "\fB\-display\fP \fIdisplay\fP" 8 
This option specifies the display to use; see \fIX(1)\fP.
.IP "\fB\-xrm\fP \fIresourcestring\fP" 8
This option specifies a resource string to use.
.IP "\fB\-multiscreen\fP" 8
This option causes \fBmwm\fP to manage all screens on the display.
The default is to manage only a single screen.
.sp 1
.IP "\fB\-name\fP \fIname\fP" 8
This option causes \fBmwm\fP to retrieve its resources using the
specified name, as in \fIname*resource\fP.
.sp 1
.IP "\fB\-screens\fP  \fIname [name [...]]/fP" 8
This option specifies the resource names to use for the screens managed
by \fBmwm\fP.
If \fBmwm\fP is managing a single screen, only the first name in the
list is used.
If \fBmwm\fP is managing multiple screens, the names are assigned to the
screens in order, starting with screen 0.
Screen 0 gets the first name, screen 1 the second name, and so on.
.SS Appearance
The following sections describe the basic default behaviors of windows,
icons, the icon box, input focus, and window stacking.  The appearance and
behavior of the window manager can be altered by changing the configuration
of specific resources.  Resources are defined under the heading "X DEFAULTS."
.PP
.SS Screens
By default, \fBmwm\fP manages only the single screen specified by the
\fB\-display\fP option or the DISPLAY environment variable (by default,
screen 0).
If the \fB\-multiscreen\fP option is specified or if the
\fBmultiScreen\fP resource is True, \fBmwm\fP tries to manage all the
screens on the display.
.PP
When \fBmwm\fP is managing multiple screens, the \fB\-screens\fP option
can be used to give each screen a unique resource name.
The names are separated by blanks, for example, \fB\-screens\fP mwm0 mwm1.
If there are more screens than names, resources for the remaining
screens will be retrieved using the first name.
.br
.ne 15
.SS Windows
Default \fBmwm\fP window frames have distinct components with associated functions:
.IP "\fBTitle Area\fP" 1.75i
In addition to displaying the client's title, the title area is used to
move the 
window.  To move the window, place the pointer over the title area, press
button 1 and drag the window to a new location.  A wire frame is moved
during the drag to indicate the new location.  When the button is released,
the window is moved to the new location.
.IP "\fBTitle Bar\fP" 1.75i
.iX "title bar"
The title bar includes the title area, the minimize button, the maximize
button, and the window menu button.
.IP "\fBMinimize Button\fP" 1.75i
.iX "minimize button"
.iX "minimize"
To turn the window into an icon, click button 1 on the minimize
button (the frame box with a \fIsmall\fR square in it).
.IP "\fBMaximize Button\fP" 1.75i
.iX "maximize button"
.iX "maximize"
To make the window fill the screen (or enlarge to the largest size allowed
by the configuration files), click button 1 on the maximize button 
(the frame box with a \fIlarge\fR square in it).
.IP "\fBWindow Menu Button\fP" 1.75i
.iX "menu button"
.iX "window menu"
.iX "menu"
The window menu button is the frame box with a horizontal bar in it.
To pull down the window menu, press button 1.
While pressing, drag the
pointer on the menu to your selection, then release the button when your
selection is highlighted.  Alternately, you can click button 1 to pull down
the menu and keep it posted; then position the pointer and select.
.PP
.ne 3i
.TS
center, allbox, tab(;);
cbss
lb lb lb
l l l.
Default Window Menu
Selection;Accelerator;Description
_
Restore;Alt+F5;T{
Restores the window to its size
.br
before minimizing or maximizing
T}
Move;Alt+F7;T{
Allows the window to be moved with
.br
keys or mouse
T}
Size;Alt+F8;Allows the window to be resized
Minimize;Alt+F9;Turns the window into an icon
Maximize;Alt+F10;Makes the window fill the screen
Lower;Alt+F3;T{
Moves window to bottom of window
.br
stack
T}
Close;Alt+F4;Causes client to terminate
.TE
.sp
.IP "\fBResize Border Handles\fP" 1.75i
.iX "resize borders"
.iX "borders" "resize"
To change the size of a window, move the pointer over a resize border
handle (the cursor changes), press button 1, and drag the window to a
new size.  When the button is released, the window is resized.  While
dragging is being done, a rubber-band outline is displayed to indicate the
new window size.
.IP "\fBMatte\fP" 1.75i
An optional matte decoration can be added between the client area and the
window frame.  A matte is not actually part of the window frame.
There is no functionality associated with a matte.
.SS Icons
.iX "icons"
Icons are small graphic representations of windows.  A window can be
minimized (iconified) using the minimize button on the window frame.
Icons provide a way to reduce clutter on the screen.  
.PP
.ne 6
Pressing mouse button 1 when the pointer is over an icon 
causes the icon's window menu to pop up.  Releasing the button (press +
release without moving mouse = click) causes the menu to stay posted.
The menu contains the following selections:
.sp 1
.ne 2.5i
.TS
center, allbox, tab(;);
cbss
lb lb lb
l l l .
Icon Window Menu
Selection;Accelerator;Description
_
Restore;Alt+F5;Opens the associated window
Move;Alt+F7;Allows the icon to be moved with keys
Size;Alt+F8;Inactive (not an option for icons)
Minimize;Alt+F9;Inactive (not an option for icons)
Maximize;Alt+F10;T{
Opens the associated window and makes it fill the screen
T}
Lower;Alt+F3;Moves icon to bottom of icon stack
Close;Alt+F4;Removes client from \f3mwm\fP management
.TE
.PP
Note that pressing button 3 over an icon also causes the
icon's window menu to pop up.
To make a menu selection, drag the pointer over
the menu and release button 3 when the desired item is highlighted.
.PP
Double-clicking button 1 on an icon normalizes the icon into its
associated window.  Double-clicking button 1 on the icon box's icon
opens the icon box and allows access to the contained icons.  (In general,
double-clicking a mouse button is a quick way to perform a function.)
Double-clicking button 1 with the pointer on the window 
menu button closes the window.
.SS "Icon Box"
.iX "icon box"
When icons begin to clutter the screen, they can be packed into an icon
box.  (To use an icon box, \fBmwm\fP must be started with the icon box
configuration already set.)  
The icon box is a \fBmwm\fP window that holds client
icons.
It includes one or more scroll bars when there are more window icons
than the icon box can show at the same time.
.PP
.ne 2i
Icons in the icon box can be manipulated with the mouse.
The following table summarizes the behavior of this interface.  Button
actions apply whenever the pointer 
.ne 4
is on any part of the icon. 
Note that invoking the \fBf.raise\fP function on an icon in the icon box
raises an already open window to the top of the stack.
.sp 1
.ne 2.5i
.TS
tab(~),center,box;
lb | lb
l | l.
Button Action~Description
=
Button 1 click~Selects the icon
_
Button 1 double-click~Normalizes (opens) the associated window
_
Button 1 double-click~T{
Raises an already open window to the top of the stack
T}
_
Button 1 drag~Moves the icon
_
Button 3 press~Causes the menu for that icon to pop up
_
Button 3 drag~T{
Highlights items as the pointer moves across the menu
T}
.TE
.PP
Pressing mouse button 3 when the pointer is over an icon causes the menu
for that icon to pop up.
.sp 1
.ne 3i
.in 0
.TS
center, allbox, tab(;);
cbss
lb | lb | lb
l | l | l .
Icon Menu for the Icon Box
Selection;Accelerator;Description
_
Restore;Alt+F5;Opens the associated window (if not already open)
Move;Alt+F7;Allows the icon to be moved with keys
Size\;Alt+F8;Inactive
Minimize;Alt+F9;Inactive
Maximize;Alt+F10;T{
Opens the associated window (if
not already open) and maximizes its size
T}
Lower;Alt+F3;Inactive
Close;Alt+F4;Removes client from \fBmwm\fP management
.TE
.in
.PP
To pull down the window menu for the icon box itself,
press button 1 with the pointer
over the menu button for the
icon box.  
The window menu of the icon box
differs from the window menu of a client
window: The "Close"
selection is replaced with the "PackIcons Shift+Alt+F7" selection.
When selected,
PackIcons packs the icons in the box to achieve
neat rows with no empty slots.
.PP
.ne 3
Pressing [Shift][Escape] when the icon box has the input
focus causes the 
window menu of the icon box to pop up.
Pressing F4 (the pop-up menu key)
causes the 
window menu of the currently selected icon to pop up.
.SS "Input Focus"
.iX "input focus"
.iX "input focus" "explicit"
.iX "input focus" "click to type"
.iX "focus policy" "explicit"
.iX "focus policy" "real estate"
.iX "explicit"
.iX "real estate"
\fBmwm\fP supports (by default) a keyboard input focus policy of explicit selection.
.iX "focus policy" "click to type"
This means when a window is selected to get keyboard input, it continues to
get keyboard input until the window is withdrawn from window management,
another window is explicitly selected to get keyboard input, or the window
is iconified.  Several resources control the input focus.
The client window with the keyboard input focus has the
active window appearance with a
visually distinct window frame.
.PP
The following tables summarize the keyboard input focus selection
behavior:
.sp 1
.ne 2i
.TS
tab(~),center,allbox;
lb lb lb
l l l.
Button Action~Object~Function Description
_
Button 1 press~Window / window frame~Keyboard focus selection
Button 1 press~Icon~Keyboard focus selection
.TE
.sp 1
.TS
tab(~),center,allbox;
lb lb
l l.
Key Action~Function Description
_
[Alt][Tab]~Move input focus to next window in window stack
[Alt][Shift][Tab]~Move input focus to previous window in window stack
.TE
.sp
.PP
.SS "X Defaults"
.iX ".Xdefaults"
.iX "resources"
\fBmwm\fP is configured from its resource database.
This database is built from the following sources. They are listed in order of
precedence, low to high:
.sp
.nf
.in +3n
  /usr/lib/X11/app-defaults/Mwm
  $HOME/Mwm
  RESOURCE_MANAGER root window property or $HOME/.Xdefaults
  XENVIRONMENT variable or $HOME/.Xdefaults-\fIhost\fP
  \fBmwm\fP command line options
.fi
.in -3n
.sp
The file names /usr/lib/X11/app-defaults/Mwm and $HOME/Mwm represent
customary locations for these files.
The actual location of the system-wide class resource file may depend
on the XFILESEARCHPATH environment variable and the current language
environment.
The actual location of the user-specific class resource file may depend
on the XUSERFILESEARCHPATH and XAPPLRESDIR environment variables and the
current language environment.
.PP
Entries in the resource database may refer to other resource files 
for specific types of resources.
These include files that contain bitmaps, fonts, and \fBmwm\fP
specific resources such as menus and behavior specifications
(for example, button and key bindings).
.PP
\fBMwm\fP is the resource class name of \fBmwm\fP
and \fBmwm\fP is the resource
name used by \fBmwm\fP to look up resources. 
(For looking up resources of multiple screens,
the \fB\-screens\fP command line option
specifies resource names, such as "mwm_b+w" and "mwm_color".)
In the following discussion of resource specification,
"Mwm" and "mwm" (and
the aliased \fBmwm\fP resource names) can be used interchangeably,
but "mwm" takes precedence over "Mwm".
.PP
\fBmwm\fP uses the following types of resources:
.iX "resources"
.PP
.I "Component Appearance Resources:"
.iX "mwm" "resources"
.PP
These resources specify appearance attributes of
window manager user interface components.
They can be applied to the appearance of window manager menus,
feedback windows (for example, the window reconfiguration feedback window),
client window frames, and icons.
.PP
.I "Specific Appearance and Behavior Resources:"
.iX "mwm" "resources"
.PP
These resources specify \fBmwm\fP appearance and 
behavior (for example, window management policies).
They are not set separately for different \fBmwm\fP user interface components.
.PP
.ne 4i
.I "Client Specific Resources:"
.iX "mwm" "resources"
.PP
These \fBmwm\fP resources can be set for a particular client window or
class of client windows.
They specify client-specific icon and client window frame 
appearance and behavior.
.PP
.ne 6
Resource identifiers can be either a resource name (for example, foreground)
or a resource 
class (for example, Foreground).
If the value of a resource is a filename and if the filename is
prefixed by "~/", then it is relative to the path contained in the HOME
environment variable
(generally the user's home directory).  
.SS "Component Appearance Resources"
.iX "resources"
The syntax for specifying component appearance resources that apply
to window manager icons, menus, and client window frames is
.sp
.nf
.in +5n
  \fBMwm*\fP\fIresource_id\fP
.fi
.in -5n
.sp
For example, \fBMwm*foreground\fP is used to specify the foreground color
for \fBmwm\fP menus, icons, client window frames, and feedback dialogs.
.PP
The syntax for specifying component appearance resources that apply
to a particular \fBmwm\fP component is
.sp
.nf
.in +5n
  \fBMwm*\fP[\fBmenu\fP|\fBicon\fP|\fBclient\fP|\fBfeedback\fP]\fB*\fP\fIresource_id\fP
.fi
.in -5n
.PP
If \fImenu\fP is specified, the resource is applied only to \fBmwm\fP
.iX "mwm" "resources"
If \fImenu\fP is specified, the resource is applied only to MWM
menus; if \fIicon\fP is specified, the resource is applied to icons;
and if \fIclient\fP is specified, the resource is applied to
client window frames.
For example, \fBMwm*icon*foreground\fP is used to specify the foreground color
for \fBmwm\fP icons, \fBMwm*menu*foreground\fP specifies the foreground color
for \fBmwm\fP menus, and \fBMwm*client*foreground\fP is used to specify the
foreground color for \fBmwm\fP client window frames.
.PP
The appearance of the title area of a client window frame
(including window management buttons)
can be separately configured.
.iX "resources"
The syntax for configuring the title area of a client window frame is
.PP
.in+4
\fBMwm*client*title*\fIresource_id\fR
.in-4
.PP
.iX "mwm" "resources"
For example, \fBMwm*client*title*foreground\fP specifies the foreground color
for the title area.
Defaults for title area resources are based on the values of the
corresponding client window frame resources.
.PP
.ne 6
The appearance of menus can be configured based on the name of the menu.
The syntax for specifying menu appearance by name is
.PP
.in+4
\fBMwm*menu*\fImenu_name\fB*\fIresource_id\fP
.in-4
.PP
For example, \fBMwm*menu*my_menu*foreground\fP specifies the foreground color
for the menu named \fBmy_menu\fP.
.br
.PP
.iX "mwm" "resources"
The following component appearance resources that apply to 
all window manager parts can be specified:
.iX "resources"
.sp 1
.ne 3.5i
.in -1
.TS
allbox, tab(;);
cb sss
lb  lb  lb  lb
l  l  l  l.
Component Appearance Resources \(em All Window Manager Parts
Name;Class;Value Type;Default
_
background;Background;color;varies\fR\(dg\fP
backgroundPixmap;BackgroundPixmap;string\fR\(dg\(dg\fP;varies\fR\(dg\fP
bottomShadowColor;Foreground;color;varies\fR\(dg\fP
bottomShadowPixmap;BottomShadowPixmap;string\fR\(dg\(dg\fP;varies\fR\(dg\fP
fontList;FontList;string\fR\(dg\(dg\(dg\fP;"fixed"
foreground;Foreground;color;varies\fR\(dg\fP
saveUnder;SaveUnder;T/F;F
topShadowColor;Background;color;varies\fR\(dg\fP
topShadowPixmap;TopShadowPixmap;string\fR\(dg\(dg\fP;varies\fR\(df\fP
.TE
.sp
\(dgThe default is chosen based on the visual type of the screen.
.br
\(dg\(dgImage name.  See XmInstallImage(3X).
.br
\(dg\(dg\(dgX11 R4 Font description.
.in 
.IP "\fBbackground\fP (class \fBBackground\fP)" 8
This resource specifies the background color. Any legal X color may be 
specified.  The default value is chosen based on the visual type of the screen.
.sp
.ne 2i
.IP "\fBbackgroundPixmap\fP (class \fBBackgroundPixmap\fP)" 8
This resource specifies the background Pixmap of the \fBmwm\fP decoration
when the window is inactive (does not have the keyboard focus). 
The default value is chosen based on the visual type of the screen.
.IP "\fBbottomShadowColor\fP (class \fBForeground\fP)" 8
This resource specifies the bottom shadow color. This color is used for the
lower and right bevels of the window manager decoration. 
Any legal X color may be specified.  The default value is chosen based on
the visual type of the screen.  
.IP "\fBbottomShadowPixmap\fP (class \fBBottomShadowPixmap\fP)" 8
This resource specifies the bottom shadow Pixmap. 
This Pixmap is used for the lower and right bevels of the window 
manager decoration. 
The default is chosen based on the visual type of the screen.
.iX "mwm" "resources"
.IP "\fBfontList\fP (class \fBFontList\fP)" 8
This resource specifies the font used in the window manager decoration.
The character encoding of the
font should match the character encoding of the strings that are used.
The default is "fixed."
.iX "resources"
.IP "\fBforeground\fP (class \fBForeground\fP)" 8
This resource specifies the foreground color.
The default is chosen based on the visual type of the screen.
.IP "\fBsaveUnder\fP (class \fBSaveUnder\fP)" 8
This is used to indicate whether "save unders"
are used for \fBmwm\fP components.  For this to 
have any effect, save unders must
be implemented by the X server.  If save unders are implemented, the X
server saves the contents of windows obscured by windows that have the
save under attribute set.  If the saveUnder resource is 
True, \fBmwm\fP will set the save under attribute on the window manager frame
of any client that has it set.  If saveUnder is False, save unders will
not be used on any window manager frames.  The default value is False.
.IP "\fBtopShadowColor\fP (class \fBBackground\fP)" 8
This resource specifies the top shadow color. 
This color is used for the
upper and left bevels of the window manager decoration. 
The default is chosen based on the visual type of the screen.
.IP "\fBtopShadowPixmap (\fP class \fBTopShadowPixmap)\fP" 8
This resource specifies the top shadow Pixmap. 
This Pixmap is used for the
upper and left bevels of the window manager decoration. 
The default is chosen based on the visual type of the screen.
.PP
The following component appearance resources that apply to frame and
icons can be specified:
.iX "resources"
.ps
.sp 1
.ne 3i
.in -4
.TS
allbox, tab(;);
cb sss
lb  lb  lb  lb
l  l  l  l .
Frame and Icon Components
Name;Class;Value Type;Default
_
activeBackground;Background;color;varies\fR\(dg\fP
activeBackgroundPixmap;BackgroundPixmap;string \fR\(dg\(dg\fP;varies\fR\(dg\fP 
activeBottomShadowColor;Foreground;color;varies\fR\(dg\fP
activeBottomShadowPixmap;BottomShadowPixmap;string\fR\(dg\(dg\fP;variesfR\(dg\fP
activeForeground;Foreground;color;varies\fR\(dg\fPg
activeTopShadowColor;Background;color;varies\fR\(dg\fP
activeTopShadowPixmap;TopShadowPixmap;string\fR\(dg\(dg/fP;varies\fR\(dg\fP
.TE
.sp
\fR\(dg\fPThe default is chosen based on the visual type of the screen.
.br
\fR\(dg\(dg\fPSee XmInstallImage(3X).
.sp
.in
.iX "mwm" "resources"
.IP "\fBactiveBackground\fP (class \fBBackground\fP)" 8
This resource specifies the background color of the \fBmwm\fP decoration 
when the window is active (has the keyboard focus).  The default is chosen
based on the visual type of the screen. 
.IP "\fBactiveBackgroundPixmap\fP (class \fBActiveBackgroundPixmap\fP)" 8
This resource specifies the background Pixmap of the \fBmwm\fP decoration
when the window is active (has the keyboard focus).  The default is chosen
based on the visual type of the screen.
.IP "\fBactiveBottomShadowColor\fP (class \fBForeground\fP)" 8
This resource specifies the bottom shadow color of the \fBmwm\fP decoration 
when the window is active (has the keyboard focus).  The default is chosen
based on the visual type of the screen.
.IP "\fBactiveBottomShadowPixmap\fP (class \fBBottomShadowPixmap\fP)" 8
This resource specifies the bottom shadow Pixmap of the \fBmwm\fP decoration 
when the window is active (has the keyboard focus).  The default is chosen
based on the visual type of the screen.
.IP "\fBactiveForeground\fP (class \fBForeground\fP)" 8
This resource specifies the foreground color of the \fBmwm\fP decoration 
when the window is active (has the keyboard focus).  The default is chosen
based on the visual type of the screen.
.iX "resources"
.IP "\fBactiveTopShadowColor\fP (class \fBBackground\fP)" 8
This resource specifies the top shadow color of the \fBmwm\fP decoration 
when the window is active (has the keyboard focus).  The default is chosen
based on the visual type of the screen.
.iX "mwm" "resources"
.IP "\fBactiveTopShadowPixmap\fP (class \fBTopShadowPixmap\fP)" 8
This resource specifies the top shadow Pixmap of the \fBmwm\fP decoration 
when the window is active (has the keyboard focus).  The default is chosen
based on the visual type of the screen.
.SS "Specific Appearance and Behavior Resources"
The syntax for specifying specific appearance and behavior
resources is
.sp
.nf
.in +5n
    \fBMwm*\fP\fIresource_id\fP
.fi
.in -5n
.PP
For example, \fBMwm*keyboardFocusPolicy\fP specifies the window
manager policy for setting the keyboard focus to a particular client
window.
.PP
.ne 30
.iX "mwm" "resources"
The following specific appearance and behavior resources can be
specified: 
.iX "resources"
.P
.in 0
.TS
center, allbox, tab(;);
cb sss
lb lb  lb  lb
l  l  l  l .
Specific Appearance and Behavior Resources
Name;Class;Value Type;Default
_
autoKeyFocus;AutoKeyFocus;T/F;T
autoRaiseDelay;AutoRaiseDelay;millisec;500
bitmapDirectory;BitmapDirectory;directory;T{
/usr/include/\e
.br
X11/bitmaps
T}
buttonBindings;ButtonBindings;string;T{
"DefaultBut\e
.br
tonBindings"
T}
cleanText;CleanText;T/F;T
clientAutoPlace;ClientAutoPlace;T/F;T
colormapFocusPolicy;ColormapFocusPolicy;string;keyboard
configFile;ConfigFile;file;.mwmrc
deiconifyKeyFocus;DeiconifyKeyFocus;T/F;T
doubleClickTime;DoubleClickTime;millisec.;T{
multi-click
.br
time
T}
enableWarp;enableWarp;T/F;T
enforceKeyFocus;EnforceKeyFocus;T/F;T
fadeNormalIcon;FadeNormalIcon;T/F;F
frameBorderWidth;FrameBorderWidth;pixels;5
iconAutoPlace;IconAutoPlace;T/F;T
iconBoxGeometry;IconBoxGeometry;string;6x1+0-0
iconBoxName;IconBoxName;string;iconbox
iconBoxSBDisplayPolicy;IconBoxSBDisplayPolicy;string;all
iconBoxTitle;IconBoxTitle;XmString;Icons
iconClick;IconClick;T/F;T
iconDecoration;IconDecoration;string;varies
iconImageMaximum;IconImageMaximum;wxh;50x50
iconImageMinimum;IconImageMinimum;wxh;16x16
.TE
.in
.bp
.in 0
.TS
center, allbox, tab(;);
cb sss
lb lb  lb  lb
l  l  l  l .
Specific Appearance and Behavior Resources (Continued)
Name;Class;Value Type;Default
_
iconPlacement;IconPlacement;string;left bottom    
iconPlacementMargin;IconPlacementMargin;pixels;varies
interactivePlacement;InteractivePlacement;T/F;F
keyBindings;KeyBindings;string;T{
"DefaultKey\e
.br
Bindings"
T}
keyboardFocusPolicy;KeyboardFocusPolicy;string;explicit
limitResize;LimitResize;T/F;T
lowerOnIconify;LowerOnIconify;T/F;T
maximumMaximumSize;MaximumMaximumSize;wxh (pixels);T{
2X screen  
.br
w&h
T}
moveThreshold;MoveThreshold;pixels;4
multiScreen;MultiScreen;T/F;F
passButtons;PassButtons;T/F;F
passSelectButton;PassSelectButton;T/F;T
positionIsFrame;PositionIsFrame;T/F;T
positionOnScreen;PositionOnScreen;T/F;T
quitTimeout;QuitTimeout;millisec.;1000
raiseKeyFocus;RaiseKeyFocus;T/F;F
resizeBorderWidth;ResizeBorderWidth;pixels;10
resizeCursors;ResizeCursors;T/F;T
screens;Screens;string;varies
showFeedback;ShowFeedback;string;\-kill
startupKeyFocus;StartupKeyFocus;T/F;T
transientDecoration;TransientDecoration;string;T{
system
.br
title
T}
.TE
.in 
.bp
.in 0
.TS
center, allbox, tab(;);
cb sss
lb lb  lb  lb
l  l  l  l .
Specific Appearance and Behavior Resources (Continued)
Name;Class;Value Type;Default
_
transientFunctions;TransientFunctions;string;T{
\-minimize
.br
\-maximize
T}
useIconBox;UseIconBox;T/F;F
wMenuButtonClick;WMenuButtonClick;T/F;T
wMenuButtonClick2;WMenuButtonClick2;T/F;T
.TE
.in
.sp
.IP "\fBautoKeyFocus\fP (class \fBAutoKeyFocus\fP)" 8
.iX "resources"
This resource is available only when the keyboard input
focus policy is explicit.  If autoKeyFocus is given a value of
True, then when a window with the keyboard input focus is withdrawn from
window management or is iconified, the focus is set to the previous window
.ne 4
that had the focus.  If the value given is False, there is no
automatic setting of the keyboard input focus.  The default value is True.
.iX "mwm" "resources"
.IP "\fBautoRaiseDelay\fP (class \fBAutoRaiseDelay\fP)" 8
This resource is available only when the focusAutoRaise resource is True
and the keyboard focus policy is pointer.  
The autoRaiseDelay resource specifies the amount of time (in milliseconds)
that \fBmwm\fP  
will wait before raising a window after it gets the keyboard focus.  
The default value of this resource is 500 (ms).
.IP "\fBbitmapDirectory\fP (class \fBBitmapDirectory\fP)" 8
This resource identifies a directory to be searched for bitmaps
referenced by \fBmwm\fP resources.
This directory is searched if a bitmap is specified without an absolute 
pathname.
The default value for this resource is /usr/include/X11/bitmaps.
.IP "\fBbuttonBindings\fP (class \fBButtonBindings\fP)" 8
This resource identifies the set of button bindings
for window management functions.
The named set of button bindings is specified in the 
\fBmwm\fP resource description file.
These button bindings are \fImerged\fP with the built-in default
bindings.
The default value for this resource is "DefaultButtonBindings".
.iX "mwm" "resources"
.IP "\fBcleanText\fP (class \fBCleanText\fP)" 8
.iX "resources"
This resource controls the display of window manager text in the client
title and feedback windows.
If the default value of True is used, the text is drawn with a clear (no
stipple) background.  This makes text easier to read on monochrome systems
where a backgroundPixmap is specified. Only the stippling in the area
immediately around the text is cleared.  If False, the text is drawn
directly on top of the existing background.
.IP "\fBclientAutoPlace\fP (class \fBClientAutoPlace\fP)" 8
This resource determines the
position of a window when the window has not been given a user-specified
position.  With a value of True, windows are positioned with the top
left corners of the frames offset horizontally and vertically.  A value of
False causes the currently configured 
.ne 4
position of the window to be
used.  In either case, \fBmwm\fP will attempt to place the windows totally on-screen.
The default value is True.
.IP "\fBcolormapFocusPolicy\fP (class \fBColormapFocusPolicy\fP)" 8
This resource indicates the colormap focus policy that is to be used.
If the resource value is explicit, a colormap selection action
is done on a client window to set the colormap focus to that window.
If the value is pointer, the client window containing
the pointer has the colormap focus.
If the value is keyboard, the client window that has the
keyboard input focus has the colormap focus.
The default value for this resource is keyboard.
.IP "\fBconfigFile\fP (class \fBConfigFile\fP)" 8
.iX "resources"
.iX ".mwmrc"
.iX "resource description file"
The resource value is the pathname for an \fBmwm\fP
resource description file.
.IP
If the pathname begins with "~/", \fBmwm\fP considers it to be relative to the
user's home directory (as specified by the HOME environment variable).
If the LANG environment variable is set, \fBmwm\fP looks for
$HOME/$LANG/\fIconfigFile\fP.
If that file does not exist or if LANG is not set, \fBmwm\fP looks for
$HOME/\fIconfigFile\fP.
.IP
If the \fBconfigFile\fR pathname does not begin with "~/", \fBmwm\fP considers
it to be relative to the current working directory.
.IP
If the \fBconfigFile\fP resource is not specified or if that file does
not exist, \fBmwm\fP uses several default paths to find a configuration file.
If the LANG environment variable is set, \fBmwm\fP looks for the
configuration file first in $HOME/$LANG/.mwmrc.
If that file does not exist or if LANG is not set, \fBmwm\fP looks for
$HOME/.mwmrc.
If that file does not exist and if LANG is set, \fBmwm\fP next looks for
/usr/lib/X11/$LANG/system.mwmrc.
If that file does not exist or if LANG is not set, \fBmwm\fP looks for
/usr/lib/X11/system.mwmrc.
.IP "\fBdeiconifyKeyFocus\fP (class \fBDeiconifyKeyFocus\fP)" 8
.iX "mwm" "resources"
This resource applies only
when the keyboard input focus policy is explicit.  If a value of
True is used, a window receives the keyboard input focus when it is
normalized (deiconified).  True is the default value.
.br
.ne 4
.IP "\fBdoubleClickTime\fP (class \fBDoubleClickTime\fP)" 8
This resource is used to set the maximum time (in ms) between the clicks
(button presses) that make up a double-click.
The default value of this resource is the display's multi-click time.
.IP "\fBenableWarp\fP (class \fBEnableWarp\fP)" 8
The default value of this resource, True, causes \fBmwm\fP to "warp"
the pointer to the center of
the selected window during keyboard-controlled resize and
move operations.  Setting the value to False causes \fBmwm\fP to leave
the pointer at its original place on the screen, unless the
user explicitly moves it with the cursor keys or pointing device.
.IP "\fBenforceKeyFocus\fP (class \fBEnforceKeyFocus\fP)" 8
If this resource is given a value of True,
the keyboard input focus is always explicitly set to selected windows
even if there is an indication that they are "globally active" input
windows.  (An example of a globally active window is a scroll bar that 
can be operated without setting the focus to that client.)  If the resource
is False, the keyboard input focus is not 
explicitly set to globally active windows.  The default value is True.
.IP "\fBfadeNormalIcon\fP (class \fBFadeNormalIcon\fP)" 8
If this resource is given a
value of True, an icon is grayed out whenever it has been normalized
(its window has been opened).  The default value is False.
.IP "\fBframeBorderWidth\fP (class \fBFrameBorderWidth\fP)" 8
This resource specifies
the width (in pixels) of a client window frame border without resize
handles.  The border width includes the 3-D shadows.  The default value is
5 pixels.
.IP "\fBiconAutoPlace\fP (class \fBIconAutoPlace\fP)" 8
.iX "resources"
This resource indicates whether the window manager arranges icons in a
particular area of the screen or places each icon where the window was
when it was iconified.
The value True indicates that icons are arranged in a particular area of
the screen, determined by the iconPlacement resource.
The value False indicates that an icon is placed at the location of the
window when it is iconified.
The default is True.
.iX "mwm" "resources"
.IP "\fBiconBoxGeometry\fP (class \fBIconBoxGeometry\fP)" 8
This resource indicates the
initial position and size of the icon box.  The value of the resource is a
standard window geometry string with the following syntax:
.sp 1
.TS
tab(;);
l l .
;[\fB=\fP][\fIwidth\fP\fBx\fP\fIheight\fP][{\fB+-\fP}\fIxoffset\fP{\fB+-\fP}\fIyoffset\fP]
.TE
.IP "" 8
.iX "mwm" "resources"
If the offsets are not provided, the iconPlacement policy is used to
determine the initial placement.  The units for width and
height are columns and rows.
.IP "" 8
The actual screen size of the icon box window depends on the
iconImageMaximum (size) and iconDecoration resources.  The
default value for size is (6 * iconWidth + padding) wide by (1 * iconHeight
+ padding) high.  The default value of the location is +0 -0.
.IP "\fBiconBoxName\fP (class \fBIconBoxName\fP)" 8
This resource specifies the name
that is used to look up icon box resources.  The default name is
"iconbox".
.IP "\fBiconBoxSBDisplayPolicy\fP (class \fBIconBoxSBDisplayPolicy\fP)" 8
This resource specifies the scroll bar display policy of
the window manager in the icon box. 
The resource
has three possible values:  all, vertical, and horizontal.
The default value, "all", causes both vertical
and horizontal scroll bars always to appear.
The value "vertical" causes a single vertical scroll bar to appear
in the icon box and sets the orientation of the icon box to
horizontal (regardless of the iconBoxGeometry specification).
The value "horizontal" causes 
.ne 3
a single horizontal scroll bar to appear
in the icon box and sets the orientation of the icon box to
vertical (regardless of the iconBoxGeometry specification).
.IP "\fBiconBoxTitle\fP (class \fBIconBoxTitle\fP)" 8
This resource specifies the name
that is used in the title area of the icon box frame.  The default value is
"Icons".
.iX "resources"
.IP "\fBiconClick\fP (class \fBIconClick\fP)" 8
When this resource is given the value of
True, the system menu is posted and left posted when an icon is
clicked.  The default value is True.
.iX "mwm" "resources"
.IP "\fBiconDecoration\fP (class \fBIconDecoration\fP)" 8
This resource specifies the general icon decoration.
The resource value is label (only the label part is displayed)
or image (only the image part is displayed) or label image 
(both the label and image parts are displayed).
A value of activelabel can also be specified to get a label
(not truncated to the width of the icon)
when the icon is selected.
The default icon decoration for icon box icons is that each icon has a
label part and an image part (label image).
The default icon decoration for stand alone icons is that each icon has an
active label part, a label part, and
an image part (activelabel label image).
.IP "\fBiconImageMaximum\fP (class \fBIconImageMaximum\fP)" 8
This resource specifies the maximum size of the icon \fIimage\fP.
The resource value is \fIwidth\fP\fBx\fP\fIheight\fP (for example, 64x64).
The maximum supported size is 128x128.
The default value of this resource is 50x50.
.iX "mwm" "resources"
.IP "\fBiconImageMinimum\fP (class \fBIconImageMinimum\fP)" 8
This resource specifies the minimum size of the icon \fIimage\fP.
The resource value is \fIwidth\fBx\fIheight\fR (for example, 32x50).
The minimum supported size is 16x16.
The default value of this resource is 16x16.
.IP "\fBiconPlacement\fP (class \fBIconPlacement\fP)" 8
This resource specifies the icon placement scheme to be used.
The resource value has the following syntax:
.sp .5
.nf
.in +5n
 \fIprimary_layout  secondary_layout\fP
.fi
.in -5n
.sp
.iX "resources"
The layout values are one of the following:
.sp 1
.ne 1.5i
.TS
tab(~), center, allbox;
lb lb
l l.
Value~Description
_
top~Lay the icons out top to bottom.
bottom~Lay the icons out bottom to top.
left~Lay the icons out left to right.
right~Lay the icons out right to left.
.TE
.IP
A horizontal (vertical) layout value should not be used for both the
\fIprimary_layout\fP and the \fIsecondary_layout\fP
(for example, don't use top for the \fIprimary_layout\fP and bottom for the
\fIsecondary_layout\fP).
The \fIprimary_layout\fP indicates whether, when an icon placement is done,
the icon is placed in a row or a column and the direction of placement.
The \fIsecondary_layout\fP indicates where to place new rows or columns.
For example, top right indicates that icons should be placed top to bottom
on the screen and that columns should be added from right to left on the
screen.
The default placement is left bottom
(icons are placed left to right on the screen, with the first row on the
bottom of the screen, and new rows added from the bottom of the screen
to the top of the screen).
.iX "mwm" "resources"
.IP "\fBiconPlacementMargin\fP (class \fBIconPlacementMargin\fP)" 8
This resource sets the distance between the edge of the screen and the
icons that are placed along the edge of the screen.
The value should be greater than or equal to 0.
A default value (see below) is used if the value specified is invalid.
The default value for this resource is equal to the space between
icons as they are placed on the screen (this space is based on maximizing
the number of icons in each row and column).
.IP "\fBinteractivePlacement\fP (class \fBInteractivePlacement\fP)" 8
.iX "resources"
This resource controls the initial placement of new windows on the screen. 
If the value is True, the pointer shape changes before a new window is 
placed on the screen to indicate to the user that 
a position should be selected for the upper-left hand corner of the 
window.
If the value is False, windows are placed according to the
initial window configuration attributes.
The default value of this resource is False.
.IP "\fBkeyBindings\fP (class \fBKeyBindings\fP)" 8
This resource identifies the set of key bindings
for window management functions.
If specified,
these key bindings \fIreplace\fP the built-in
default bindings. 
The named set of key bindings is specified in 
\fBmwm\fP resource description file.
The default value for this resource is "DefaultKeyBindings".
.iX "mwm" "resources"
.IP "\fBkeyboardFocusPolicy\fP (class \fBKeyboardFocusPolicy\fP)" 8
.iX "input focus"
.iX "input focus" "explicit"
.iX "input focus" "click to type"
.iX "focus policy" "explicit"
.iX "focus policy" "click to type"
.iX "input focus" "pointer"
.iX "input focus" "real estate"
.iX "focus policy" "real estate"
.iX "focus policy" "pointer"
.iX "focus policy" "click to type"
.iX "explicit"
.iX "real estate"
.iX "pointer"
.iX "click to type"
If set to pointer, the keyboard focus policy is to have the keyboard focus set
to the client window that contains the pointer
(the pointer could also be in the client window decoration that \fBmwm\fP adds).
If set to explicit, the policy is to have the keyboard focus
set to a client window when the user presses button 1 with the pointer
on the client window or any part of the associated \fBmwm\fP decoration.
The default value for this resource is explicit.
.IP "\fBlimitResize\fP (class \fBLimitResize\fP)" 8
If this resource is True, the user is not allowed to resize a window 
to greater than the maximum size.
The default value for this resource is True.
.IP "\fBlowerOnIconify\fP (class \fBLowerOnIconify\fP)" 8
If this resource is given the default
value of True, a window's icon appears on the bottom of the window
stack when the window is minimized (iconified).  A value of False
places the icon in the stacking order at the same place as its associated
window.
The default value of this resource is True.
.IP "\fBmaximumMaximumSize\fP (class \fBMaximumMaximumSize\fP)" 8
.iX "resources"
This resource is used to limit the maximum size of a client window
as set by the user or client.
The resource value is \fIwidth\fBx\fIheight\fR (for example, 1024x1024)
where the width and height are in pixels.
The default value of this resource is twice the screen width and height.
.iX "mwm" "resources"
.IP "\fBmoveThreshold\fP (class \fBMoveThreshold\fP)" 8
This resource is used to control the sensitivity of dragging operations
that move windows and icons.
The value of this resource is the number of pixels that the locator is
moved with a button down before the move operation is initiated.
This is used to prevent window/icon 
.ne 3
movement when you click or
double-click and there is unintentional pointer movement with
the button down.
The default value of this resource is 4 (pixels).
.IP "\fBmultiScreen\fP (class \fBMultiScreen\fP)" 8
This resource, if True, causes \fBmwm\fP to manage all the screens on
the display.
If False, \fBmwm\fP manages only a single screen.
The default value is False.
.IP "\fBpassButtons\fP (class \fBPassButtons\fP)" 8
This resource indicates whether or not button press events are passed to
clients after they are used to do a window manager function in the client
context.
If the resource value is False, the button press is not passed
to the client.
If the value is True, the button press is passed to the
client window.
The window manager function is done in either case.
The default value for this resource is False.
.IP "\fBpassSelectButton\fP (class \fBPassSelectButton\fP)" 8
This resource indicates whether or not to pass the select button press events 
to clients after they are used to do a window manager function in the
client context.  If the resource value is False, then the button press will
not be passed to the client.  If the value is True, the button press is
passed to the client window.  The window manager function is done in either
case.  The default value for this resource is True.
.iX "mwm" "resources"
.IP "\fBpositionIsFrame\fP (class \fBPositionIsFrame\fP)" 8
.iX "resources"
This resource indicates how client window position information 
(from the WM_NORMAL_HINTS property and from configuration requests)
is to be interpreted.
If the resource value is True, the information is interpreted as
the position of the MWM client window frame.  If the value is False,
it is interpreted as being the position of the client area of the window.
The default value of this resource is True.
.IP "\fBpositionOnScreen\fP (class \fBPositionOnScreen\fP)" 8
This resource is used to indicate that windows should initially be
placed (if possible) so that they are not clipped by the edge of the 
screen (if the resource value is True).
If a window is larger than the size of the screen,
at least the upper-left corner of the window is on-screen.
If the resource value is False, windows are placed in the 
requested position even if totally off-screen.
The default value of this resource is True.
.IP "\fBquitTimeout\fP (class \fBQuitTimeout\fP)" 8
This resource specifies the amount of time (in milliseconds) that \fBmwm\fP
will wait for a client to update the WM_COMMAND property after \fBmwm\fP has
sent the WM_SAVE_YOURSELF message.
This protocol is used only for
those clients that have a WM_SAVE_YOURSELF atom and no WM_DELETE_WINDOW
atom in the WM_PROTOCOLS client window property.
The default value of this resource is 1000 (ms). (Refer to the f.kill
function for additional information.)
.IP "\fBraiseKeyFocus\fP (class \fBRaiseKeyFocus\fP)" 8
This resource is available
only when the keyboard input focus policy is explicit.
When set to True,
this resource specifies that a window raised by
means of the f.normalize_and_raise function also receives
the input focus.
The default value of this resource is False.
.iX "mwm" "resources"
.IP "\fBresizeBorderWidth\fP (class \fBResizeBorderWidth\fP)" 8 
This resource specifies the width (in pixels) of a client window frame
border with resize handles.  The specified border width includes the 3-D
shadows.  
The default is 10 (pixels). 
.IP "\fBresizeCursors\fP (class \fBResizeCursors\fP)" 8
This is used to indicate whether the resize cursors are always displayed
when the pointer is in the window size border.
If True, the cursors are shown, otherwise the window manager cursor is
shown.
The default value is True.
.IP "\fBscreens\fP (class \fBScreens\fP)" 8
This resource specifies the resource names to use for the screens
mananged by \fBmwm\fP.
If \fBmwm\fP is managing a single screen, only the first name in the
list is used.
If \fBmwm\fP is managing multiple screens, the names are assigned to the
screens in order, starting with screen 0.
Screen 0 gets the first name, screen 1 the second name, and so on.
The default screen names are 0, 1, and so on.
.br
.ne 6
.IP "\fBshowFeedback\fP (class \fBShowFeedback\fP)" 8
.iX "resources"
This resource controls when
feedback information is displayed.  It controls both window position and
size feedback during move or resize operations and initial client
placement.  It also controls window manager message and dialog boxes.
.IP
The
value for this resource is a list of names of the feedback options to be
enabled or disabled; the names must be separated by a space.
If an option is preceded by a minus sign, that option is
excluded from the list.
The \fIsign\fR of the first item in the list
determines the initial set of options.
If the sign of the first
option is minus, \fBmwm\fP assumes all options are present and starts
subtracting from that set.
If the sign of the first decoration is plus (or not
specified), \fBmwm\fP starts with no options and builds up a list from
the resource.
.IP
The names of the feedback options are shown below:
.iX "mwm" "resources"
.sp 1
.ne 2i
.TS
center, allbox, tab(;);
lB  lB
l l.
Name;Description
_
all;Show all feedback (Default value)
behavior;Confirm behavior switch
kill;Confirm on receipt of KILL signal
move;Show position during move
none;Show no feedback
placement;Show position and size during initial placement
quit;Confirm quitting \f3mwm\fP
resize;Show size during resize
restart;Confirm \f3mwm\fP restart
.TE
.IP
.ne 15
The following command line illustrates the syntax for showFeedback:
.IP
.TS
tab(;);
l l .
;\fBMwm*showFeedback: placement resize behavior restart\fP
.TE
.IP
.iX "resources"
This resource specification provides feedback for initial client
placement and
resize, and enables the dialog boxes to confirm the restart and set
behavior functions.  It disables feedback for the move function.
The default value for this resource is all.
.iX "mwm" "resources"
.IP "\fBstartupKeyFocus\fP (class \fBStartupKeyFocus\fP)" 8
This resource is available only
when the keyboard input focus policy is explicit.  When given
the default 
value of True, a window gets the keyboard input focus when the window
is mapped (that is, initially managed by the window manager).
.IP "\fBtransientDecoration\fP (class \fBTransientDecoration\fP)" 8
This controls the amount of decoration that \fBmwm\fP puts on transient windows.
The decoration specification is exactly the same as for
the \fBclientDecoration\fR
(client specific) resource.
Transient windows are identified by the WM_TRANSIENT_FOR property, which
is added by the client to indicate a relatively temporary window.
The default value for this resource is menu title
(that is, transient windows have resize borders and a titlebar with
a window menu button).
.IP "\fBtransientFunctions\fP (class \fBTransientFunctions\fP)" 8
This resource is used to indicate which window management functions are
applicable (or not applicable) to transient windows.
The function specification is exactly the same as for
the \fBclientFunctions\fR (client specific) resource.
The default value for this resource is -minimize -maximize.
.iX "mwm" "resources"
.IP "\fBuseIconBox\fP (class \fBUseIconBox\fP)" 8
If this resource is given a value of
True, icons are placed in an icon box.  When an icon box is not used,
the icons are placed on the root window (default value).
.br
.ne 15
.IP "\fBwMenuButtonClick\fP (class \fBWMenuButtonClick\fP)" 8
.iX "resources"
This resource
indicates whether a click of the mouse when the pointer is over
the window menu button posts and leaves posted the window
menu.  If the value given this resource is True, the menu
remains posted.  True is the default value for this
resource.
.IP "\fBwMenuButtonClick2\fP (class \fBWMenuButtonClick2\fP)" 8
When this resource is
given the default value of True, a double-click action on the window menu
button does an f.kill function.
.br
.ne 2i
.SS "Client Specific Resources"
The syntax for specifying client specific resources is
.sp
.nf
.in +5n
    \fBMwm*\fIclient_name_or_class\fB*\fIresource_id\fR
.fi
.in -5n
.sp
.iX "mwm" "resources"
For example, \fBMwm*mterm*windowMenu\fP is used to specify the window menu to
be used with mterm clients.
  
The syntax for specifying client specific resources for
all classes of clients is
.sp
.nf
.in +5n
    \fBMwm*\fIresource_id\fR
.fi
.in -5n
.sp
Specific client specifications take precedence over the specifications
for all clients.
For example, \fBMwm*windowMenu\fP is used to specify the window menu to
be used for all classes of clients that don't have a window 
menu specified.
.iX "resources"
.sp  
The syntax for specifying resource values for windows that have an
unknown name and class (that is, windows that do not have a WM_CLASS 
property associated with them) is
.sp
.nf
.in +5n
    \fBMwm*defaults*\fIresource_id\fR
.fi
.in -5n
.PP
.iX "mwm" "resources"
For example, \fBMwm*defaults*iconImage\fP is used to specify the icon image
to be used for windows that have an unknown name and class.
.PP
.ne 4
The following client specific resources can be specified:
.P
.in 0
.TS
center, allbox, tab(;);
cb sss
lb lb lb lb
l l l l .
Client Specific Resources
Name;Class;Value Type;Default
_
clientDecoration;ClientDecoration;string;all
clientFunctions;ClientFunctions;string;all
focusAutoRaise;FocusAutoRaise;T/F;varies
iconImage;IconImage;pathname;(image)
iconImageBackground;Background;color;T{
icon 
.br
background
T}
iconImageBottomShadowColor;Foreground;color;T{
icon bottom
.br
shadow
T}
iconImageBottomShadowPixmap;T{
BottomShadow-
.br
Pixmap
T};color;T{
icon bottom
.br 
shadow 
.br
pixmap
T}
iconImageForeground;Foreground;color;varies
iconImageTopShadowColor;Background;color;T{
icon top 
.br
shadow 
.br
color
T}
iconImageTopShadowPixmap;T{
TopShadow-
.br
Pixmap
T};color;T{
icon top 
.br
shadow 
.br
pixmap
T}
matteBackground;Background;color;background
matteBottomShadowColor;Foreground;color;T{
bottom 
.br
shadow 
.br
color
T}
matteBottomShadowPixmap;T{
BottomShadow-
.br
Pixmap
T};color;T{
bottom 
.br
shadow 
.br
pixmap
T}
matteForeground;Foreground;color;foreground
.TE
.in
.bp
.in 0
.TS
center, allbox, tab(;);
cb sss
lb lb  lb  lb
l  l  l  l .
Client Specific Resources (Continued)
Name;Class;Value Type;Default
_
matteTopShadowColor;Background;color;T{
top shadow
.br
color
T}
matteTopShadowPixmap;T{
TopShadow-
.br
Pixmap
T};color;T{
top shadow
.br
pixmap
T}
matteWidth;MatteWidth;pixels;0
maximumClientSize;MaximumClientSize;wxh;T{
fill the
.br
screen
T}
useClientIcon;UseClientIcon;T/F;F
windowMenu;WindowMenu;string;T{
"Default-
.br
Window-
.br
Menu"
T}
.TE
.in
.PP
.iX "resources"
.iX "mwm" "resources"
.IP "\fBclientDecoration\fP (class \fBClientDecoration\fP)" 8
This resource controls the amount of window frame decoration.
The resource is specified as a list of decorations to specify their
inclusion in the frame.  
If a decoration is preceded by a minus sign, that decoration is
excluded from the frame.
The \fIsign\fR of the first item in the list
determines the initial amount of decoration.
If the sign of the first
decoration is minus, \fBmwm\fP assumes all decorations are present and starts
subtracting from that set.
If the sign of the first decoration is plus (or not
specified), then \fBmwm\fP starts with no decoration and builds up a list from
the resource. 
.ne 2.5i 
.br
.ne 25
.iX "mwm" "resources"
.TS
center, allbox, tab(~);
lb  lb
l  l.
Name~Description
_
all~Include all decorations (default value)
border~Window border
maximize~Maximize button (includes title bar)
minimize~Minimize button (includes title bar)
none~No decorations
resizeh~Border resize handles (includes border)
menu~Window menu button (includes title bar)
title~Title bar (includes border)
.TE   
.IP "" 8
Examples:
.sp
    \fBMwm*XClock.clientDecoration: -resizeh -maximize\fP
.sp
This removes the resize handles and maximize button from
XClock windows. 
.sp
    \fBMwm*XClock.clientDecoration: menu minimize border\fP
.sp
This does the same thing as above. Note that either \fBmenu\fR or
\fBminimize\fR implies \fBtitle\fR. 
.PP
.IP "\fBclientFunctions\fP (class \fBClientFunctions\fP)" 8
.iX "mwm" "resources"
This resource is used to
indicate which \fBmwm\fP functions are applicable (or not applicable) to the
client window.  The value for the resource is a list of functions.  If the
first function in the list has a minus sign in front of it, then \fBmwm\fP starts
with all functions and subtracts from that set.  If the first function in
the list has a plus sign in front of it, then \fBmwm\fP starts with no functions
and builds up a list.  Each function in the list must be preceded by the
appropriate plus or minus sign and separated from the next function by
a space. 
.PP
.ne 25
.iX "resources"
The table below lists the functions available for this resource:
.sp 1
.ne 2.5i
.TS
center, allbox, tab(;);
lb | lb
l | l.
Name;Description
_
all;Include all functions (default value)
none;No functions
resize;f.resize
move;f.move
minimize;f.minimize
maximize;f.maximize
close;f.kill
.TE
.sp
.ne 3i
.IP "\fBfocusAutoRaise\fP (class \fBFocusAutoRaise\fP)" 8
When the value of this resource is True, clients are raised when
they get the keyboard input focus.  If
the value is False,  the stacking of windows on the display is
not changed when a window gets the keyboard input focus.
The default value is True when the keyboardFocusPolicy is explicit and
False when the keyboardFocusPolicy is pointer.
.iX "resources"
.IP "\fBiconImage\fP (class \fBIconImage\fP)" 8
.iX "mwm" "resources"
This resource can be used to specify an icon image for a client (for example, 
"Mwm*myclock*iconImage").  The resource value is a pathname for a bitmap file.
The value of the (client specific) useClientIcon resource is used
to determine whether or not user supplied icon images are used instead of
client supplied icon images.    
The default value is to display a built-in window manager icon image.
.IP "\fBiconImageBackground\fP (class \fBBackground\fP)" 
This resource specifies the background color of the icon image that
is displayed in the image part of an icon.
The default value of this resource is the icon background color
(that is, specified by "Mwm*background or Mwm*icon*background).
.br
.ne 15
.IP "\fBiconImageBottomShadowColor\fP (class \fBForeground\fP)" 8
This resource specifies the bottom shadow color of the icon image that
is displayed in the image part of an icon.
The default value of this resource is the icon bottom shadow color
(that is, specified by Mwm*icon*bottomShadowColor).
.IP "\fBiconImageBottomShadowPixmap\fP (class \fBBottomShadowPixmap\fP)" 8
This resource specifies the bottom shadow Pixmap of the icon image that
is displayed in the image part of an icon.
The default value of this resource is the icon bottom shadow Pixmap
(that is, specified by Mwm*icon*bottomShadowPixmap).
.IP "\fBiconImageForeground\fP (class \fBForeground\fP)" 8
This resource specifies the foreground color of the icon image that
is displayed in the image part of an icon.
The default value of this resource varies depending on the icon
background.
.br
.ne 3i
.IP "\fBiconImageTopShadowColor\fP (class \fBBackground\fP)" 8
This resource specifies the top shadow color of the icon image that
is displayed in the image part of an icon.
The default value of this resource is the icon top shadow color
(that is, specified by Mwm*icon*topShadowColor).
.iX "mwm" "resources"
.IP "\fBiconImageTopShadowPixmap\fP (class \fBTopShadowPixmap\fP)" 8
This resource specifies the top shadow Pixmap of the icon image that
is displayed in the image part of an icon.
The default value of this resource is the icon top shadow pixmap
(that is, specified by Mwm*icon*topShadowPixmap).
.IP "\fBmatteBackground\fP (class \fBBackground\fP)" 8
This resource specifies the background color of the matte, when 
\fBmatteWidth\fR is positive.
The default value of this resource is the client background color
(that is, specified by "Mwm*background or Mwm*client*background).
.IP "\fBmatteBottomShadowColor\fP (class \fBForeground\fP)" 8
This resource specifies the bottom shadow color of the matte, when 
\fBmatteWidth\fR is positive.
The default value of this resource is the client bottom shadow color
(that is, specified by "Mwm*bottomShadowColor or Mwm*client*bottomShadowColor).
.br
.ne 15
.IP "\fBmatteBottomShadowPixmap\fP (class \fBBottomShadowPixmap\fP)" 8
This resource specifies the bottom shadow Pixmap of the matte, when 
\fBmatteWidth\fR is positive.
The default value of this resource is the client bottom shadow pixmap
(that is, specified by 
.na
"Mwm*bottomShadowPixmap or Mwm*client*bottomShadowPixmap).
.ad
.IP "\fBmatteForeground\fP (class \fBForeground\fP)" 8
This resource specifies the foreground color of the matte, when 
\fBmatteWidth\fR is positive.
The default value of this resource is the client foreground color
(that is, specified by "Mwm*foreground or Mwm*client*foreground).
.br
.ne 3i
.IP "\fBmatteTopShadowColor\fP (class \fBBackground\fP)" 8
This resource specifies the top shadow color of the matte, when 
\fBmatteWidth\fR is positive.
The default value of this resource is the client top shadow color
(that is, specified by "Mwm*topShadowColor or Mwm*client*topShadowColor).
.iX "resources"
.IP "\fBmatteTopShadowPixmap\fP (class \fBTopShadowPixmap\fP)" 8
This resource specifies the top shadow pixmap of the matte, when 
\fBmatteWidth\fR is positive.
The default value of this resource is the client top shadow 
.ne 10
pixmap
(that is, specified by "Mwm*topShadowPixmap or Mwm*client*topShadowPixmap).
.iX "mwm" "resources"
.IP "\fBmatteWidth\fP (class \fBMatteWidth\fP)" 8
This resource specifies the width of the optional matte.  
The default value is 0, which effectively disables the matte.
.IP "\fBmaximumClientSize\fP (class \fBMaximumClientSize\fP)" 8
This is a size specification that indicates the client size to be used
when an application is maximized.
The resource value is specified as \fIwidth\fBx\fIheight\fR.  The width and
height are interpreted in the units that the client uses
(for example, for terminal emulators this is generally characters).
If this resource is not specified, the maximum size from the
WM_NORMAL_HINTS property is used if set.
Otherwise the default value is the size where the client window with
window management borders fills the screen.  When the maximum client size
is not determined by the maximumClientSize resource, the maximumMaximumSize
resource value is used as a constraint on the maximum size.
.IP "\fBuseClientIcon\fP (class \fBUseClientIcon\fP)" 8
If the value given for this 
resource is True, a client-supplied icon image takes precedence
over a user-supplied icon image.  The default value is False, giving the
user-supplied icon image higher precedence than the client-supplied
icon image. 
.IP "\fBwindowMenu\fP (class \fBWindowMenu\fP)" 8
.iX "resources"
.iX "mwm" "resources"
This resource indicates the name of the menu pane that is posted when
the window menu is popped up (usually by pressing button 1 on the window
menu button on the client window frame).
Menu panes are specified in the MWM resource description file.
Window menus can be customized
on a client class basis by specifying resources of the form 
\fBMwm*\fIclient_name_or_class\fB*windowMenu\fR
(see "Mwm Resource Description File Syntax").
The default value of this resource is "DefaultWindowMenu".
.sp
.PP
.SS "Resource Description File"
.iX "resource description file"
.iX ".mwmrc"
.PP
The MWM resource description file is a supplementary resource file
that contains resource descriptions that are referred to by entries in 
the defaults files (.Xdefaults, app-defaults/Mwm).
It contains descriptions of resources that are to be used by \fBmwm\fP,
and that cannot be easily encoded in the defaults files
(a bitmap file is an analogous type of resource description file).
A particular \fBmwm resource description
file\fP can be selected using the \fBconfigFile\fP resource.
.sp
.br
.ne 20
The following types of resources can be described in the \fBmwm\fP
resource description file:
.IP "\fBButtons\fP" 15
Window manager functions can be bound (associated) with button events.
.IP "\fBKeys\fP" 15
Window manager functions can be bound (associated) with key press events.
.IP "\fBMenus\fP" 15
Menu panes can be used for the window menu and other menus posted
with key bindings and button bindings.
.SS "mwm Resource Description File Syntax"
.iX "resource description file"
.iX ".mwmrc"
The \fBmwm\fP resource description file
is a standard text file that contains items
of information separated by blanks, tabs, and newline characters.
Blank lines are ignored.
Items or characters can be quoted to avoid special interpretation
(for example, the comment character can be quoted to prevent it from being
interpreted as the comment character).
A quoted item can be contained in double quotes (\fB"\fP).
Single characters can be quoted by preceding them by the backslash
character (\fB\\\fP).
All text from an unquoted \fB#\fP to the end of the line is regarded 
as a comment and is not interpreted as part of a resource description.
If \fB!\fP is the first character in a line, the line is regarded as a comment.
Window manager functions can be accessed with button and key bindings,
.ne 10
and
with window manager menus.
Functions are indicated as part of the specifications for button and key
binding sets, and menu panes.
The function specification has the following syntax:
.sp 1
.ne 1i
.TS
tab(~), center;
ll.
\fIfunction\fP =~\fIfunction_name\fP [\fIfunction_args\fP]
\fIfunction_name\fP =~\fIwindow manager function\fP
\fIfunction_args\fP =~{\fIquoted_item\fB | \fIunquoted_item\fR}
.TE
.sp
The following functions are supported.
If a function is specified that isn't one of the supported functions, then it
is interpreted by \fBmwm\fP as \fIf.nop\fP.
.IP \fBf.beep\fP
This function causes a beep.
.IP "\fBf.circle_down\fP [\fBicon | window\fP]"
This function causes the window or icon that is on the top of the window
stack to be put on the bottom of the window stack (so that it no
longer obscures any other window or icon).
This function affects only those windows and icons
that obscure other windows and icons,
or that are obscured by other windows and icons.
Secondary windows (that is, transient windows) are restacked with their
associated primary window.
Secondary windows always stay on top of the associated primary window and
there can be no other primary windows between the secondary windows and
their primary window.  If an \fBicon\fP function argument is specified,
the function applies only to icons.
If a \fBwindow\fP function argument is specified, the function applies
only to windows.
.IP "\fBf.circle_up\fP [\fBicon | window\fP]"
This function raises the window or icon on the bottom of the window stack
(so that it is not obscured by any other windows).
This function affects only those windows and icons
that obscure other windows and icons,
or that are obscured by other windows and icons.
Secondary windows (that is, transient windows) are restacked with their
associated primary window.
If an \fIicon\fP function argument is specified, the
function applies only to icons.
If a \fIwindow\fP function argument is specified, the function applies
only to windows.
.br
.ne 2i
.IP "\fBf.exec\fP or \fB!\fP"
This function causes \fIcommand\fP to be executed (using the
value of the MWMSHELL environment variable if it is set,
otherwise the value of the SHELL environment variable if it is set,
otherwise \fI/bin/sh\fP).
The \fB!\fP notation can be used in place of the \fBf.exec\fP function
name.
.IP "\fBf.focus_color\fP"
This function sets the colormap focus to a client window.
If this function is done in a root context, the default colormap
(set up by the \fIX Window System\fP for the screen where MWM is running)
is installed and there is no specific client window colormap focus.
This function is treated as \fIf.nop\fP if colormapFocusPolicy is not
explicit.
.IP "\fBf.focus_key\fP"
This function sets the keyboard input focus to a client window or icon.
This function is treated as \fIf.nop\fP if keyboardFocusPolicy is not
explicit or the function is executed in a root context.
.IP "\fBf.kill\fP"
This function is used to terminate a client.
If the WM_DELETE_WINDOW protocol is set up, the client is sent a
client message event, indicating that the client window should be deleted.
If the WM_SAVE_YOURSELF protocol is set up and the WM_DELETE_WINDOW
protocol is not set up, the client is sent a
client message event, indicating that the client needs to prepare to be
terminated.
If the client does not have the WM_DELETE_WINDOW or WM_SAVE_YOURSELF
protocol set up,
this function causes a client's X connection to be terminated
(usually resulting in termination of the client).
Refer to the description of the quitTimeout resource and the
WM_PROTOCOLS property.
.IP "\fBf.lower\fP [\fB-\fIclient\fP]"
This function lowers a client window to the bottom of the window stack
(where it obscures no other window).
Secondary windows (that is, transient windows) are restacked with their
associated primary window.
The \fIclient\fP argument indicates the name or class of a client to
lower.
If the \fIclient\fP argument is not specified, the context that the
function was invoked in indicates the window or icon to lower.
.IP "\fBf.maximize\fP"
This function causes a client window to be displayed with its maximum
size.
.IP "\fBf.menu\fP"
This function associates a cascading (pull-right) menu 
with a menu pane entry or a menu with a button or key binding.
The \fImenu_name\fP function argument identifies the menu to be used.
.IP "\fBf.minimize\fP"
This function causes a client window to be minimized (iconified).
When a window is minimized when no icon box is used, its icon is placed on
the bottom of the window
stack (so that it obscures no other window).  If an icon box is used,
the client's icon changes to its iconified form inside the icon box.
Secondary windows (that is, transient windows) are minimized with their
associated primary window.
There is only one icon for a primary window and all its secondary windows.
.IP "\fBf.move\fP"
This function causes a client window to be interactively moved.
.IP "\fBf.next_cmap\fP"
This function installs the next colormap in the list of colormaps for
the window with the colormap focus.
.IP "\fBf.next_key\fP [\fBicon | window | transient\fP]"
This function sets the keyboard input focus to the next window/icon in the set
of windows/icons managed by the window manager 
(the ordering of this set is based on the stacking of windows on the screen).
This function is treated as \fIf.nop\fP if keyboardFocusPolicy is not
explicit.
The keyboard input focus is moved only to windows that do not have an
associated secondary window that is application modal.
If the \fBtransient\fP argument is specified, transient (secondary)
windows are traversed (otherwise, if only \fBwindow\fP is specified,
traversal is done only to the last focused window in a transient
group).
If an \fBicon\fP function argument is specified, the
function applies only to icons.
If a \fBwindow\fP function argument is specified, the function applies
only to windows.
.IP "\fBf.nop\fP"
This function does nothing.
.IP "\fBf.normalize\fP"
This function causes a client window to be displayed with its normal size.
Secondary windows (that is, transient windows) are placed in their normal state
along with their associated primary window.
.br
.ne 10
.IP "\fBf.normalize_and_raise\fP"
This function causes the corresponding client
window to be displayed with its normal size
and raised to the top of the window stack.
Secondary windows (that is, transient windows) are placed in their normal state
along with their associated primary window.
.IP "\fBf.pack_icons\fP"
This function is used to relayout icons 
(based on the layout policy being used)
on the root window or in the icon box.
In general this causes icons to be "packed" into the icon grid.
.br
.ne 10
.IP "\fBf.pass_keys\fP"
This function is used to enable/disable (toggle) processing of key bindings
for window manager functions.  When it disables key binding processing, all
keys are passed on to the window with
the keyboard input focus and no window manager functions are invoked.
If the \fIf.pass_keys\fP function is invoked with a key binding to
disable key-binding processing, the
same key binding can be used to enable key-binding processing. 
.IP "\fBf.post_wmenu\fP"
This function is used to post the window menu.  If a key is used to post
the window menu and a window menu button is present, the window menu is
automatically
placed with its top-left corner at the bottom-left corner of the
window menu button for the client window.  If no window menu button is
present,  the window menu is placed
at the top-left corner of the client window.
.IP "\fBf.prev_cmap\fP"
This function installs the previous colormap in the list of colormaps for
the window with the colormap focus.
.IP "\fBf.prev_key\fP [\fBicon | window | transient\fP]"
This function sets the keyboard input focus to the previous window/icon in
the set of windows/icons managed by the window manager 
(the ordering of this set is based on the stacking of windows on the screen).
This function is treated as \fIf.nop\fP if keyboardFocusPolicy is not
explicit.
The keyboard input focus is moved only to windows that do not have an
associated secondary window that is application modal.
If the \fItransient\fP argument is specified, transient (secondary)
windows are traversed (otherwise, if only \fIwindow\fP is specified,
traversal is done only to the last focused window in a transient
group).
If an \fIicon\fP function argument is specified, the
function applies only to icons.
If an \fIwindow\fP function argument is specified, the function applies
only to windows.
.IP "\fBf.quit_mwm\fP"
This function terminates \fBmwm\fP (but NOT the X window system).
.br
.ne 8
.IP "\fBf.raise\fP [\fB-\fIclient\fP]"
This function raises a client window to the top of the window stack
(where it is obscured by no other window).  Secondary windows (that is,
transient windows) are restacked with their 
associated primary window.
The \fIclient\fP argument indicates the name or class of a client to
raise.
If the \fIclient\fP argument is not specified, the context that
the function was invoked in indicates the window or icon to raise.
.IP "\fBf.raise_lower\fP"
This function raises a client window to the top of the window stack if
it is partially obscured by another window, otherwise it lowers the window
to the bottom of the window stack.
Secondary windows (that is, transient windows) are restacked with their
associated primary window.
.IP "\fBf.refresh\fP"
This function causes all windows to be redrawn.
.IP "\fBf.refresh_win\fP"
This function causes a client window to be redrawn.
.IP "\fBf.resize\fP"
This function causes a client window to be interactively resized.
.IP "\fBf.restart\fP"
This function causes \fBmwm\fP to be restarted (effectively terminated
and re-executed).
.IP "\fBf.send_msg\fI message_number\fR"
This function sends a client message of the type _MOTIF_WM_MESSAGES with the
\fImessage_type\fP indicated by the \fImessage_number\fR function argument.
The
client message is sent only if \fImessage_number\fR is included in the
client's _MOTIF_WM_MESSAGES property.  A menu item label is grayed out if
the menu item is used to do \fIf.send_msg\fR of a message that is not
included in the client's _MOTIF_WM_MESSAGES property.  
.IP "\fBf.separator\fP"
This function causes a menu separator to be put in the menu pane at the
specified location (the label is ignored).
.br
.ne 10
.IP "\fBf.set_behavior\fP"
This function causes the window manager to restart with the default
behavior (if a custom behavior is configured) or revert to the
custom behavior.
By default this is bound to \fBShift\ Ctrl\ Meta\ <Key>!\fP.
.IP "\fBf.title\fP"
This function inserts a title in the menu pane at the specified location.
.PP
Each function may be constrained as to which resource types can specify 
the function (for example, menu pane) and also what context the function can
be used in (for example, the function is done to the selected client window).
Function contexts are
.PP
.IP "\fBroot\fP" 15
No client window or icon has been selected as an object for
the function.
.IP "\fBwindow\fP" 15
A client window has been selected as an object for the function.
This includes the window's title bar and frame.
Some functions are applied only when the window is
in its normalized state (for example, \fIf.maximize\fP) or its maximized state
(for example, \fIf.normalize\fP).
.IP "\fBicon\fP" 15 
An icon has been selected as an object for the function.
.PP
If a function's context has been specified as \fBicon|window\fP and the
function is invoked in an icon box, the function applies to the icon
box, not to the icons inside.
.PP
If a function is specified in a type of resource where it is not supported
or is invoked in a context that does not apply,
the function is treated as \fIf.nop\fP.
The following table indicates the resource types and function contexts in
which window manager functions apply.
.sp
.in 0
.TS
allbox, tab(~), center;
l l l.
\f3Function\fP~\f3Contexts\fP~\f3Resources\fP
_
f.beep~root, icon, window~button, key, menu
f.circle_down~root, icon, window~button, key, menu
f.circle_up~root, icon, window~button, key, menu
.TE
.bp
.TS
allbox, tab(~), center;
l l l.
\f3Function\fP~\f3Contexts\fP~\f3Resources\fP
_
f.exec~root, icon, window~button, key, menu
f.focus_color~root, icon, window~button, key, menu
f.focus_key~root, icon, window~button, key, menu
f.kill~icon, window~button, key, menu
f.lower~icon, window~button, key, menu
f.maximize~icon, window(normal)~button, key, menu
f.menu~root, icon, window~button, key, menu
f.minimize~window~button, key, menu
f.move~icon, window~button, key, menu
f.next_cmap~root, icon, window~button, key, menu
f.next_key~root, icon, window~button, key, menu
f.nop~root, icon, window~button, key, menu
f.normalize~icon, window(maximized)~button, key, menu
f.normalize_and_raise~icon, window~button, key, menu
f.pack_icons~root, icon, window~button, key, menu
f.pass_keys~root, icon, window~button, key, menu
f.post_wmenu~root, icon, window~button, key
f.prev_cmap~root, icon, window~button, key, menu
f.prev_key~root, icon, window~button, key, menu
f.quit_mwm~root~button, key, menu (root only)
f.raise~icon, window~button, key, menu
f.raise_lower~icon, window~button, key, menu
f.refresh~root, icon, window~button, key, menu
f.refresh_win~window~button, key, menu
f.resize~window~button, key, menu
f.restart~root~button, key, menu (root only)
f.send_msg~icon, window~button, key, menu
.TE
.in
.bp
.TS
allbox, tab(~), center;
l l l.
\f3Function\fP~\f3Contexts\fP~\f3Resources\fP
_
f.separator~root, icon, window~menu
f.set_behavior~root, icon, window~button, key, menu
f.title~root, icon, window~menu
.TE
.sp
.SS "Window Manager Event Specification"
Events are indicated as part of the specifications for button and
key-binding sets, and menu panes.
.PP
Button events have the following syntax:
.PP
.in+4
.TS
tab(~);
l l.
\fIbutton\fP =~[\fImodifier_list\fP]\fB<\fIbutton_event_name\fB>\fR
\fImodifier_list\fP =~\fImodifier_name\fP {\fImodifier_name\fP}
.TE
.in-4
.PP
All modifiers specified are interpreted as being exclusive
(this means that only the specified modifiers can be present when the
button event occurs).
The following table indicates the values that can be used
for \fImodifier_name\fP.\*F
.FS
The [Alt] key is frequently labeled [Extend] or [Meta].
Alt and Meta can be used interchangeably in event specification.
.FE
.sp 1
.ne 2.5i
.TS
tab(~),center,allbox;
lfI | lfI
l | l.
\f3Modifier\fP~\f3Description\fR
_
Ctrl~Control Key
Shift~Shift Key
Alt~Alt/Meta Key
Meta~Meta/Alt Key
Lock~Lock Key
Mod1~Modifier1
Mod2~Modifier2
Mod3~Modifier3
Mod4~Modifier4
Mod5~Modifier5
.TE
.PP
.ne 10
The following table indicates the values that can be used for
\fIbutton_event_name\fP.
.sp 1
.ne 4i
.TS
tab(~),center,allbox;
lfI | lfI
l | l.
\f3Button\fP~\f3Description\fR
_
Btn1Down~Button 1 Press
Btn1Up~Button 1 Release
Btn1Click~Button 1 Press and Release
Btn1Click2~Button 1 Double-Click
Btn2Down~Button 2 Press
Btn2Up~Button 2 Release
Btn2Click~Button 2 Press and Release
Btn2Click2~Button 2 Double-Click
Btn3Down~Button 3 Press
Btn3Up~Button 3 Release
Btn3Click~Button 3 Press and Release
Btn3Click2~Button 3 Double-Click
Btn4Down~Button 4 Press
Btn4Up~Button 4 Release
Btn4Click~Button 4 Press and Release
Btn4Click2~Button 4 Double-Click
Btn5Down~Button 5 Press
Btn5Up~Button 5 Release
Btn5Click~Button 5 Press and Release
Btn5Click2~Button 5 Double-Click
.TE
.PP
.ne 2i
Key events that are used by the window manager for menu mnemonics
and for binding to window manager functions are single key presses;
key releases are ignored.
Key events have the following syntax:
.PP
.in+4
.TS
tab(~);
l l.
\fIkey\fP =~[\fImodifier_list\fP]\fB<Key>\fIkey_name\fR
\fImodifier_list\fP =~\fImodifier_name\fP {\fImodifier_name\fP}
.TE
.in-4
.PP
All modifiers specified are interpreted as being exclusive
(this means that only the specified modifiers can be present when the
key event occurs).
Modifiers for keys 
.ne 7
are the same as those that apply to buttons.
The \fIkey_name\fP is an X11 keysym name.
Keysym names can be found in the keysymdef.h file
(remove the \fIXK_\fP prefix).
.SS "Button Bindings"
The \fBbuttonBindings\fP resource value is the name of a set of button 
bindings that are used to configure window manager behavior.
A window manager function can be done when a button press  occurs with 
the pointer over a framed client window,
an icon, or the root window.
The context for indicating where the button press applies is also the
context for invoking the window manager function when the button press
is done
(significant for functions that are context sensitive).  
.PP
The button binding syntax is
.sp
.nf
.in +5n
.B
\fBButtons\fP \fIbindings_set_name\fP
\fB{\fP
    \fIbutton\fP    \fIcontext\fP    \fIfunction\fP
    \fIbutton\fP    \fIcontext\fP    \fIfunction\fP
                         .
                         .
    \fIbutton\fP    \fIcontext\fP    \fIfunction\fP
\fB}\fP
.fi
.in -5n
.PP
.ne 2i
The syntax for the \fIcontext\fP specification is
.sp 1
.TS
tab(~), center;
ll.
\fIcontext\fP =~\fIobject\fP[\fB|\fIcontext\fR]
\fIobject\fP =~\fBroot | icon | window | title | frame | border | app\fR
.TE
.sp
The context specification indicates where the pointer must be for the
button binding to be effective.
For example, a context of \fBwindow\fP indicates that the pointer must
be over a client window or
window management frame for the button binding to be effective.
The \fBframe\fP context is for the window management frame around a
client window
(including the border and titlebar), the \fBborder\fP context is
for the border part of the window management frame
.ne 15
(not including the titlebar), the \fBtitle\fP
context is for the title area of the window management frame,
and the \fBapp\fP context is for the application window
(not including the window management frame).  
.sp
If an \fIf.nop\fP function is specified for a button binding, the button
binding is not done.
.sp
.SS "Key Bindings"
The \fBkeyBindings\fP resource value is the name of a set of key 
bindings that are used to configure window manager behavior.  A window
manager function can be done when a particular key is pressed. 
The context in which the key binding applies is indicated in the key
binding specification.
The valid contexts are the same as those that apply to button bindings.
.sp  
The key binding syntax is
.sp
.nf
.in +5n
.B
\fBKeys\fP \fIbindings_set_name\fP
\fB{\fP
    \fIkey\fP    \fIcontext\fP    \fIfunction\fP
    \fIkey\fP    \fIcontext\fP    \fIfunction\fP
                .
                .
    \fIkey\fP    \fIcontext\fP    \fIfunction\fP
\fB}\fP
.fi
.in -5n
.PP
If an \fIf.nop\fP function is specified for a key binding, the key
binding is not done.
If an \fIf.post_wmenu\fP or \fIf.menu\fP function is bound to a 
key, \fBmwm\fP will automatically use the same key for removing the menu from
the screen after it has been popped up.
.PP
The \fIcontext\fP specification syntax is the same as for button bindings.
For key bindings, the \fBframe\fP, \fBtitle\fP, \fBborder\fP, and \fBapp\fP 
contexts are equivalent to the \fBwindow\fP context.
The context for a key event is the window or icon that has the keyboard
input focus (\fBroot\fR if no window or icon has the keyboard input focus).
.br
.ne 8
.SS "Menu Panes"
Menus can be popped up using the \fIf.post_wmenu\fP and
\fIf.menu\fP window manager functions.
The context for window manager functions that are done from 
a menu is \fIroot\fP, \fIicon\fP or \fIwindow\fP depending on how the
menu was popped up.
In the case of the \fIwindow\fP menu or menus popped up with a key
binding, the location of the keyboard input
focus indicates the context.
For menus popped up using a button binding,
the context of the button binding is the context of the menu.
.sp  
The menu pane specification syntax is
.sp
.nf
.in +5n
.B
\fBMenu\fP \fImenu_name\fP
\fB{\fP
    \fIlabel\fP  [\fImnemonic\fR]  [\fIaccelerator\fR]   \fIfunction\fP
    \fIlabel\fP  [\fImnemonic\fR]  [\fIaccelerator\fR]   \fIfunction\fP
                .
                .
    \fIlabel\fP  [\fImnemonic\fR]  [\fIaccelerator\fR]   \fIfunction\fP
\fB}\fP
.fi
.in -5n
.PP
Each line in the \fIMenu\fP specification identifies the label for a menu
item and the function to be done if the menu item is selected.
Optionally a menu button mnemonic and a menu button keyboard accelerator
may be specified.
Mnemonics are functional only when the menu is posted
and keyboard traversal applies.
.PP
The \fIlabel\fP may be a string or a bitmap file.
The label specification has the following syntax:
.sp 1
.TS
tab(~), center;
ll.
\fIlabel\fP =~\fItext\fB | \fIbitmap_file\fR
\fIbitmap_file\fP =~\fB@\fIfile_name\fR
\fItext\fP =~\fIquoted_item\fB | \fIunquoted_item\fR
.TE
.sp  
The string encoding for labels must be compatible with the menu font that 
is used.
Labels are greyed out for menu items that do the \fIf.nop\fP function 
or an invalid function or a function that doesn't apply in the current
context.
.sp
.ne 5
A \fImnemonic\fP specification has the following syntax
.sp 1
.in+4
.TS
tab(~);
l l.
\fImnemonic\fP =~\fB_\fIcharacter\fR
.TE
.in-4
.PP
The first matching \fIcharacter\fP in the label is underlined.
If there is no matching \fIcharacter\fP in the label, no 
mnemonic is registered with the window manager for that label.
Although the \fIcharacter\fP must exactly match a character in the
label,
the mnemonic does not execute if any modifier (such as Shift) is pressed with 
the character key.
.PP
The \fIaccelerator\fP specification is a key event specification with
the same syntax as is used for key bindings to window manager functions.
.SS Environment
\fBmwm\fP uses the environment variable HOME specifying the user's 
home directory.
.PP
\fBmwm\fP uses the environment variable LANG specifying the
user's choice of language for the \fBmwm\fP message catalog and 
the \fBmwm\fP resource description file.
.PP
\fBmwm\fP uses the environment variables XFILESEARCHPATH,
XUSERFILESEARCHPATH, XAPPLRESDIR, XENVIRONMENT, LANG, and HOME in
determining search paths for resource defaults files.
.PP
\fBmwm\fP reads the $HOME/.motifbind file if it
exists to install a virtual
key bindings property on the root window.
For more information on the content of the \&.motifbind file, see
\fBVirtualBindings(3X)\fP.
.PP
.ne 2i
\fBmwm\fP uses the environment variable MWMSHELL (or SHELL, if MWMSHELL
is not set), specifying the shell to use when executing commands via the
\fIf.exec\fP function.
.br
.ne 15
.SH Files
\fB/usr/lib/X11/$LANG/system.mwmrc\fR 
\fB/usr/lib/X11/system.mwmrc\fR
\fB/usr/lib/X11/app-defaults/Mwm\fR
\fB$HOME/Mwm\fR
\fB$HOME/.Xdefaults\fR
\fB$HOME/$LANG/.mwmrc\fR
\fB$HOME/.mwmrc\fR
\fB$HOME/.motifbind\fR
.SH RELATED INFORMATION
\fBVendorShell(3X)\fP,
\fBVirtualBindings(3X)\fP,
\fBX(1)\fP, and
\fBXmInstallImage(3X)\fP.
