/*
 * Mach Operating System
 * Copyright (c) 1987 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 *
 */
/*
 **********************************************************************
 * HISTORY
 * $Log:	features.h,v $
 * Revision 2.1  89/08/04  14:45:19  rwd
 * Created.
 * 
 * 08-May-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Enclosed entire file in KERNEL_FEATURES conditional;  changed
 *	the default configuration to use the more natural DEFAULT
 *	rather than GENERIC configuration file; deleted CONFIG_MULTI
 *	case since this shouldn't differ from the default (I think).
 *	[ V5.1(XF11) ]
 *
 * 11-Mar-87  Mike Accetta (mja) at Carnegie-Mellon University
 *	Re-implemented to provide machine independence.
 *	[ V5.1(F6) ]
 *
 **********************************************************************
 *
 *  This file is used to pick up the various configuration options that affect
 *  the use of kernel include files by special user mode system applications.
 *  The machine dependent configuration files that ultimately end up being
 *  included below are generated by the configuration script.  Only those
 *  configurations which differ in some significant way or are used external to
 *  the kernel need be defined here.  When the default configuration isn't
 *  appropriate, an alternate configuration can be selected by defining the
 *  appropriate pre-processor symbol.
 *
 *  The entire file (and hence all configuration symbols which it indirectly
 *  defines) is enclosed in the KERNEL_FEATURES conditional to prevent
 *  accidental interference with normal user applications.  Only special system
 *  applications need to know the precise layout of internal kernel structures
 *  and they will explicitly set this flag to obtain the proper environment.
 */


#ifdef	KERNEL_FEATURES


#ifndef	CONFIG_SPECIAL
/*
 *  Use the default configuration if none is explicitly specified.
 */
#define	CONFIG_DEFAULT
#endif

#ifdef	CONFIG_DEFAULT
#include <machine/DEFAULT.h>
#endif

#ifdef	CONFIG_SPECIAL
#include <machine/SPECIAL.h>
#endif


#endif	KERNEL_FEATURES
