.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	vm_write.man,v $
.\" Revision 2.4  91/05/14  17:16:44  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:16:48  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:17:49  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:48:25  rpd
.\" 	Created.
.\" 
.TH vm_write 2 1/13/87
.CM 4
.SH NAME
.nf
vm_write  \-  allows a task's memory to be written by another task
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t vm_write(target_task, address, data, data_count)
	vm_task_t	target_task;
	vm_address_t	address;
	pointer_t	data;
	int		data_count;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
target_task
Task whose memory is to be written.
.TP 15
.B
address
Starting address in task to be affected
(must be a page boundary).
.TP 15
.B
data
An array of bytes to be written.
.TP 15
.B
data_count
The size of the 
.B data
array
(must be an integral number of pages).

.SH DESCRIPTION
.B vm_write
allows a task's virtual memory to be written
by another task. Use 
.B vm_page_size
or 
.B vm_statistics
to find out the
virtual page size.


.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
Memory written.
.TP 25
KERN_INVALID_ARGUMENT
Either the address does not start on a page
boundary or the size is not an integral number of pages.
.TP 25
KERN_PROTECTION_FAILURE
The address region in the target task
is protected against writing.
.TP 25
KERN_INVALID_ADDRESS
Illegal or non_allocated address specified or
there is not 
.B data_count
of allocated memory starting at 
.B address
.

.SH SEE ALSO
.B vm_copy, vm_protect, vm_read, vm_statistics


