.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	thread_special_ports.man,v $
.\" Revision 2.4  91/05/14  17:14:32  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:15:36  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:16:27  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:46:31  rpd
.\" 	Created.
.\" 
.TH thread_special_ports 2 1/20/88
.CM 4
.SH NAME
.nf
thread_get_special_port  \-  returns a special port of a thread
thread_set_special_port  \-  set a special port of a thread
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t thread_get_special_port(thread, which_port, special_port)
	thread_t 	thread;
	int 		which_port;
	port_t 		*special_port;


.fi
.ft P
.nf
.ft B
kern_return_t thread_set_special_port(thread, which_port, special_port)
	thread_t 	thread;
	int 		which_port;
	port_t 		special_port;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
thread
The thread for which to get the port
.TP 15
.B
which_port
the port that is requested. Is one of 
.B THREAD_EXCEPTION_PORT
.
.TP 15
.B
special_port
the value of the port that is being requested or
being set.

.SH DESCRIPTION

.B get_special_port
returns send rights to one of a set of special ports 
for the thread specified by 
.B thread
.

.B set_special_port
sets one of a set of special ports for the thread specified
by 
.B thread
. 

The following macros to call 
.B thread_get/set_special_port
for a specific
port are defined in 
.B <mach/thread_special_ports.h>
: 
.B thread_get_exception_port
and 
.B thread_set_exception_port
.

A thread also has access to its task's special ports.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The port was returned or set.
.TP 25
KERN_INVALID_ARGUMENT
.B thread
is not a thread or 
.B which_port
is an invalid port selector.

.SH SEE ALSO
.B task_special_ports,thread_create

.SH BUGS
.B THREAD_KERNEL_PORT
may be added to the set of ports that
.B thread_set_special_port
accepts.
