.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	processor_set_threads.man,v $
.\" Revision 2.4  91/05/14  17:12:12  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:14:20  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:15:13  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:43:16  rpd
.\" 	Created.
.\" 
.TH processor_set_threads 2 8/13/89
.CM 4
.SH NAME
.nf
processor_set_threads /- gets thread ports for threads assigned to a processor set \-
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t processor_set_threads(processor_set, thread_list, thread_count)
	processor_set_t	processor_set;
	thread_array_t	*thread_list;	/* out, ptr to array */
	int		*thread_count;	/* out */


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
processor_set
The processor_set to be affected.
.TP 15
.B
thread_list
The set of threads currently assigned to
.B processor_set
; no particular ordering is guaranteed. 
.TP 15
.B
thread_count
The number of threads in the 
.B thread_list.

.SH DESCRIPTION
.B processor_set_threads
gets send rights to  the  kernel port for each thread
currently assigned to 
.B processor_set
.  
.B thread_list
is an array that is created as a result of this call. The caller may wish to 
.B vm_deallocate
this array when the data is no longer needed.

.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_ARGUMENT
.B processor_set
is not a processor_set.

.SH BUGS
Availability limited.

.SH SEE ALSO
.B thread_assign, thread_assign, processor_set_threads



