.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	processor_set_default.man,v $
.\" Revision 2.4  91/05/14  17:11:25  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:13:57  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:14:43  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:42:27  rpd
.\" 	Created.
.\" 
.TH processor_set_default 2 2/2/89
.CM 4
.SH NAME
.nf
processor_set_default  \-  Get default processor set.
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>

.nf
.ft B
kern_return_t processor_set_default(host, default_set);
	host_t			host;
	processor_set_t		*default_set;



.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
.B host
Specifies the host whose default processor set is requested.
.TP 15
.B
.B default_set
Returns the name port for the default processor set.  

.SH DESCRIPTION
The default processor set is used by all threads, tasks, and processors
that are not explicitly assigned to other sets. 
.B processor_set_default
returns a port that can be used to obtain information about this set
(e.g. how many threads are assigned to it).  This port cannot be
used to perform operations on that set.

.SH BUGS
Availability limited.

.SH SEE ALSO
.B processor_set_info, thread_assign, task_assign


