.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_set_mscount.man,v $
.\" Revision 2.4  91/05/14  17:07:36  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:12:03  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:12:12  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:38:12  rpd
.\" 	Created.
.\" 
.TH mach_port_set_mscount 2 1/13/87
.CM 4
.SH NAME
.nf
mach_port_set_mscount \- changes the make-send count of a port
.SH SYNOPSIS
.nf
.ft B
#include <mach/mach.h>

kern_return_t
mach_port_set_mscount(task, name, mscount)
	task_t task;
	mach_port_t name;
	mach_port_mscount_t mscount;
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task owning the receive right.
.TP 12
.B
name
\fBtask\fR's name for the receive right.
.TP 12
.B
mscount
New value for the make-send count for the receive right.
.SH DESCRIPTION
\fBmach_port_set_mscount\fR changes the make-send count of
\fBtask\fR's receive right named \fBname\fR.  All values for
\fBmscount\fR are valid.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_INVALID_NAME
\fBname\fR did not denote a right.
.TP 25
KERN_INVALID_RIGHT
\fBname\fR denoted a right, but not a receive right.
.PP
The \fBmach_port_set_mscount\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_get_receive_status(2), mach_port_set_qlimit(2).
