.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_names.man,v $
.\" Revision 2.4  91/05/14  17:07:09  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:11:43  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:11:55  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:37:32  rpd
.\" 	Created.
.\" 
.TH mach_port_names 2 4/13/87
.CM 4
.SH NAME
.nf
mach_port_names \- return information about a task's port name space
.SH SYNOPSIS
.nf
.ft B
#include <mach/mach.h>

kern_return_t
mach_port_names(task, names, ncount, types, tcount)
	task_t task;
	mach_port_name_array_t *names;		/* out array */
	mach_msg_type_number_t *ncount;		/* out */
	mach_port_type_array_t *types;		/* out array */
	mach_msg_type_number_t *tcount;		/* out */
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task whose port name space is queried.
.TP 12
.B
names
The names of the ports, port sets, and dead names in the task's
port name space, in no particular order.
.TP 12
.B
ncount
The number of names returned.
.TP 12
.B
types
The type of each corresponding name.  Indicates what kind
of rights the task holds with that name.
.TP 12
.B
tcount
Should be the same as ncount.
.SH DESCRIPTION
\fBmach_port_names\fR returns information about \fBtask\fR's port name
space.  It returns \fBtask\fR's currently active names, which represent some
port, port set, or dead name right.  For each name, it also returns
what type of rights \fBtask\fR holds.  (The same information returned
by \fBmach_port_type\fR.)  \fBnames\fR and \fBtypes\fR are arrays that
are automatically allocated when the reply message is received. The
user should \fBvm_deallocate\fR them when the data is no longer
needed.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_RESOURCE_SHORTAGE
The kernel ran out of memory.
.PP
The \fBmach_port_names\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_type(2), vm_deallocate(2).
