.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	mach_port_move_member.man,v $
.\" Revision 2.4  91/05/14  17:07:02  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:11:39  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:11:52  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:37:24  rpd
.\" 	Created.
.\" 
.TH mach_port_move_member 2 9/19/86
.CM 4
.SH NAME
.nf
mach_port_move_member \- moves a receive right into/out of a port set
.SH SYNOPSIS
.nf
.ft B
#include <mach/mach.h>

kern_return_t
mach_port_move_member(task, member, after)
	task_t task;
	mach_port_t member;
	mach_port_t after;
.fi
.ft P
.SH ARGUMENTS
.TP 12
.B
task
The task holding the port set and receive right.
.TP 12
.B
member
The task's name for the receive right.
.TP 12
.B
after
The task's name for the port set.
.SH DESCRIPTION
\fBmach_port_move_member\fR
moves a receive right into a port set.
If the receive right is already a member of another port set,
it is removed from that set first.
If the port set is MACH_PORT_NULL, then the receive right
is not put into a port set, but removed from its current port set.
.SH DIAGNOSTICS
.TP 25
KERN_SUCCESS
The call succeeded.
.TP 25
KERN_INVALID_TASK
\fBtask\fR was invalid.
.TP 25
KERN_INVALID_NAME
\fBmember\fR did not denote a right.
.TP 25
KERN_INVALID_RIGHT
\fBmember\fR denoted a right, but not a receive right.
.TP 25
KERN_INVALID_NAME
\fBafter\fR did not denote a right.
.TP 25
KERN_INVALID_RIGHT
\fBafter\fR denoted a right, but not a port set.
.TP 25
KERN_NOT_IN_SET
\fBafter\fR was MACH_PORT_NULL, but \fBmember\fR wasn't
currently in a port set.
.PP
The \fBmach_port_move_member\fR call is actually an RPC to \fBtask\fR,
normally a send right for a task port, but potentially any send right.
In addition to the normal diagnostic
return codes from the call's server (normally the kernel),
the call may return \fBmach_msg(2)\fR return codes.
.SH SEE ALSO
mach_port_get_set_status(2), mach_port_get_receive_status(2).
