.\" 
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie Mellon
.\" the rights to redistribute these changes.
.\" 
.\" 
.\" HISTORY
.\" $Log:	host_processor_set_priv.man,v $
.\" Revision 2.4  91/05/14  17:04:56  mrt
.\" 	Correcting copyright
.\" 
.\" Revision 2.3  91/02/14  14:10:27  mrt
.\" 	Changed to new Mach copyright
.\" 	[91/02/12  18:10:33  mrt]
.\" 
.\" Revision 2.2  90/08/07  18:34:58  rpd
.\" 	Created.
.\" 
.TH host_processor_set_priv 2 2/2/89
.CM 4
.SH NAME
.nf
host_processor_set_priv  \-  Get control port for processor set
.SH SYNOPSIS
.nf
.ft B
#include <mach.h>
.nf
.ft B
kern_return_t host_processor_set_priv(host_priv, set_name, set);
	host_priv_t		host_priv;
	processor_set_name_t	set_name;
	processor_set_t		*set;


.fi
.ft P
.SH ARGUMENTS
.TP 15
.B
.B host_priv
The privileged host port for the host on which this processor
set resides.
.TP 15
.B
.B set_name
The name port for this set.
.TP 15
.B
.B set
Returns the control port for this set.

.SH DESCRIPTION
This call allows a privileged application to obtain the control port
for an existing processor set from its name port.  The privileged host
port is required.

.SH BUGS
Availability limited.

.SH SEE ALSO
.B host_ports, processor_set_default, processor_set_create

