/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */


/* MacMach Console Output
 *
 * Created by Zonnie L. Williamson at CMU, 1991
 *
 * This emulates a vt52 with the additions of inverse video, underline and bold
 * character modes.
 *
 * The alternate character set provides vt100 style line graphics.
 *
 * Send ^F to trigger an answerback string that is a correct termcap entry for
 * the current console display.  The answerback string terminates with ^M.
 *
 * A status line at the bottom of the display provides a place to put quick
 * messages.  For kernel debugging use xprintf() as a printf to the status
 * line, otherwise use ^A and ^B to enclose a quick message to the status line.
 *
 * This module can be compiled as a standalone program for debugging outside
 * of the kernel.  An alternate display device can be specified on the command
 * line.  Send a ^C to the display to exit the standalone console.
 *
 * Note that console_setstat() TTY_SET_BREAK will reset the console device.
 */

#ifndef KERNEL
#undef DEBUG
#endif

/* define SMALL_FONT to use a 6x13 font, otherwise 7x13 is used */
#define SMALL_FONT

static char termcap[] =
  "mac2|MacMach Console:"
  "do=^J:"
  "le=^H:"
  "bs:"
  "cd=\\EJ:"
  "ce=\\EK:"
  "cl=\\EH\\EJ:"
  "cm=\\EY%+ %+ :"
  "nd=\\EC:"
  "pt:"
  "sr=\\EI:"
  "up=\\EA:"
  "ku=\\EA:"
  "kd=\\EB:"
  "kr=\\EC:"
  "kl=\\ED:"
  "kb=\\177:"
  "so=\\Ej:"
  "se=\\Ek:"
  "us=\\El:"
  "ue=\\Em:"
  "as=\\En:"
  "ae=\\Eo:"
  "md=\\Ep:"
  "me=\\Eq:"
  "hs:"
  "es:"
  "ts=\\ES%+ :"
  "fs=^B:";
  /* co, li and ws are appended by display_init() */

#ifdef KERNEL

#include <device/conf.h>
#include <device/tty.h>
#include <device/io_req.h>
#include <device/buf.h>

#include <sys/types.h>
#include <sys/varargs.h>

#include <mac2/act.h>
#include <mac2/clock.h>

#else

#include <sys/mman.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sgtty.h>
#include <signal.h>

#endif

#undef NULL
#include <mac2os/Types.h>
#include <mac2os/Video.h>
#include <mac2dev/video.h>
#include <mac2dev/adb.h>

#ifdef KERNEL

struct tty console_tty;

struct act *console_act;

struct {
  unsigned long transData;
  unsigned long state;
  unsigned short modflags;
  struct act *key_act;
  unsigned char	repeat_code;
} key_data;

#define KEY_MOD_CTRL	0x1000
#define KEY_MOD_OPT	0x0800
#define KEY_MOD_CAPS	0x0400
#define KEY_MOD_SHFT	0x0200
#define KEY_MOD_CMD	0x0100

#define KEY_CLOCK_LIST	0

#endif

/* mode bits */
#define BOLD      1
#define UNDERLINE 2
#define INVERSE   4
#define GRAPHIC   8

struct position {
  int x;
  int y;
};

struct display {
  int height;                          /* height, in pixels */
  int width;                           /* width, in pixels */
  int rowsize;                         /* buffer rowsize, in int's */
  int offset;                          /* x offset for centered display */
  struct position max;                 /* display size, in characters */
  struct position cursor;              /* cursor postion */
  struct position new;                 /* new cursor position */
  int mode;                            /* display mode */
  int state;                           /* emulator state */
  int status;                          /* status line flag */
  int status_mode;                     /* display mode on status line */
  unsigned int *buffer;                /* display frame buffer */
  char termcap[sizeof(termcap) + 22];  /* termcap string */
  /* "co#ddd:li#ddd:ws#ddd:"0, at most 22 chars, appended to termcap string */
};

#ifdef SMALL_FONT

#define font_height 13
#define font_width 6

#define X(a, b, c, d, e, f) \
  ((a<<5)|(b<<4)|(c<<3)|(d<<2)|(e<<1)|(f<<0))

/* this is the 6x13 font from X11 */
static unsigned char font_normal[128 * 13] = {
  /* character 0 */
  X(0,0,0,0,0,0), X(1,1,1,1,0,0), X(1,1,1,1,0,0), X(1,1,1,1,0,0),
  X(1,1,1,1,0,0), X(1,1,1,1,0,0), X(1,1,1,1,0,0), X(1,1,1,1,0,0),
  X(1,1,1,1,0,0), X(1,1,1,1,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 1 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(1,1,1,1,1,0),
  X(0,1,1,1,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 2 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,0,1,0,1,0), X(0,1,0,1,0,0), X(1,0,1,0,1,0), X(0,1,0,1,0,0),
  X(1,0,1,0,1,0), X(0,1,0,1,0,0), X(1,0,1,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 3 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,0,1,0,0,0), X(1,0,1,0,0,0), X(1,1,1,0,0,0), X(1,0,1,0,0,0),
  X(1,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0),
  /* character 4 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,1,1,0,0,0), X(1,0,0,0,0,0), X(1,1,0,0,0,0), X(1,0,0,0,0,0),
  X(1,1,1,1,0,0), X(0,1,0,0,0,0), X(0,1,1,0,0,0), X(0,1,0,0,0,0),
  X(0,1,0,0,0,0),
  /* character 5 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,1,1,1,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(0,1,1,1,0,0),
  X(0,1,1,1,0,0), X(0,1,0,0,1,0), X(0,1,1,1,0,0), X(0,1,0,1,0,0),
  X(0,1,0,0,1,0),
  /* character 6 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,0,0,0),
  X(0,1,1,1,0,0), X(0,1,0,0,0,0), X(0,1,1,0,0,0), X(0,1,0,0,0,0),
  X(0,1,0,0,0,0),
  /* character 7 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,1,1,0,0,0), X(1,0,0,1,0,0), X(1,0,0,1,0,0), X(0,1,1,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 8 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(1,1,1,1,1,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 9 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,0,0,0,1,0), X(1,1,0,0,1,0), X(1,0,1,0,1,0), X(1,0,0,1,1,0),
  X(1,0,0,0,1,0), X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,1,0,0,0,0),
  X(0,1,1,1,1,0),
  /* character 10 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,0,1,0,0), X(0,0,1,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0),
  /* character 11 */
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(1,1,1,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 12 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0),
  /* character 13 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,1,1),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0),
  /* character 14 */
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,1,1,1),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 15 */
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(1,1,1,1,1,1),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0),
  /* character 16 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 17 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 18 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 19 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 20 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1),
  X(0,0,0,0,0,0),
  /* character 21 */
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,1,1,1),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0),
  /* character 22 */
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(1,1,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0),
  /* character 23 */
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(1,1,1,1,1,1),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 24 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0),
  /* character 25 */
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0),
  /* character 26 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,1,0),
  X(0,0,0,1,0,0), X(0,0,1,0,0,0), X(0,1,0,0,0,0), X(0,0,1,0,0,0),
  X(0,0,0,1,0,0), X(0,0,0,0,1,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 27 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,0,0),
  X(0,1,0,0,0,0), X(0,0,1,0,0,0), X(0,0,0,1,0,0), X(0,0,1,0,0,0),
  X(0,1,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 28 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,1,0,1,0,0),
  X(0,1,0,1,0,0), X(0,1,0,1,0,0), X(1,0,0,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 29 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,1,0), X(1,1,1,1,1,0), X(0,0,1,0,0,0),
  X(1,1,1,1,1,0), X(1,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 30 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,1,0,0), X(0,1,0,0,1,0), X(0,1,0,0,0,0), X(1,1,1,1,0,0),
  X(0,0,1,0,0,0), X(1,1,1,1,0,0), X(1,0,1,0,1,0), X(1,1,1,0,0,0),
  X(0,0,0,0,0,0),
  /* character 31 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 32 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 33 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 34 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,0,1,0,0), X(0,1,0,1,0,0),
  X(0,1,0,1,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 35 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,0,1,0,0),
  X(0,1,0,1,0,0), X(1,1,1,1,1,0), X(0,1,0,1,0,0), X(1,1,1,1,1,0),
  X(0,1,0,1,0,0), X(0,1,0,1,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 36 */
  X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(1,0,1,0,0,0),
  X(1,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,1,0,1,0), X(0,0,1,0,1,0),
  X(0,1,1,1,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 37 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,0,0,1,0), X(1,0,1,0,1,0),
  X(0,1,0,1,0,0), X(0,0,0,1,0,0), X(0,0,1,0,0,0), X(0,1,0,0,0,0),
  X(0,1,0,1,0,0), X(1,0,1,0,1,0), X(1,0,0,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 38 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,0,0,0,0), X(1,0,1,0,0,0),
  X(1,0,1,0,0,0), X(0,1,0,0,0,0), X(1,0,1,0,0,0), X(1,0,0,1,1,0),
  X(1,0,0,1,0,0), X(0,1,1,0,1,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 39 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,0,1,0,0,0),
  X(0,1,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 40 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,1,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,1,0,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,0,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 41 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,0,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,0,0,1,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,1,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 42 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0),
  X(1,0,1,0,1,0), X(1,1,1,1,1,0), X(0,1,1,1,0,0), X(1,1,1,1,1,0),
  X(1,0,1,0,1,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 43 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(1,1,1,1,1,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 44 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,0,1,0,0,0), X(0,1,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 45 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 46 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,1,0,0,0),
  X(0,0,0,0,0,0),
  /* character 47 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,1,0), X(0,0,0,0,1,0),
  X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,0,1,0,0,0), X(0,1,0,0,0,0),
  X(0,1,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 48 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,1,0,1,0,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(0,1,0,1,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 49 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,1,1,0,0,0),
  X(1,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 50 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(0,0,0,0,1,0), X(0,0,0,1,0,0), X(0,0,1,0,0,0),
  X(0,1,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 51 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,1,0),
  X(0,0,0,1,0,0), X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,0,0,1,0),
  X(0,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 52 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,1,0,0), X(0,0,0,1,0,0),
  X(0,0,1,1,0,0), X(0,1,0,1,0,0), X(0,1,0,1,0,0), X(1,0,0,1,0,0),
  X(1,1,1,1,1,0), X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 53 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,1,1,0,0), X(1,1,0,0,1,0), X(0,0,0,0,1,0),
  X(0,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 54 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 55 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,1,0),
  X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 56 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 57 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,1,0), X(0,0,0,0,1,0),
  X(0,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 58 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,1,0,0,0),
  X(0,0,0,0,0,0),
  /* character 59 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,0,1,0,0,0), X(0,1,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 60 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,1,0), X(0,0,0,1,0,0),
  X(0,0,1,0,0,0), X(0,1,0,0,0,0), X(1,0,0,0,0,0), X(0,1,0,0,0,0),
  X(0,0,1,0,0,0), X(0,0,0,1,0,0), X(0,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 61 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,1,1,1,1,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 62 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,0,0), X(0,1,0,0,0,0),
  X(0,0,1,0,0,0), X(0,0,0,1,0,0), X(0,0,0,0,1,0), X(0,0,0,1,0,0),
  X(0,0,1,0,0,0), X(0,1,0,0,0,0), X(1,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 63 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(0,0,0,0,1,0), X(0,0,0,1,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 64 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,1,1,0), X(1,0,1,0,1,0), X(1,0,1,0,1,0),
  X(1,0,1,1,0,0), X(1,0,0,0,0,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 65 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,1,0,1,0,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,1,1,1,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 66 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,0,0), X(0,1,0,0,1,0),
  X(0,1,0,0,1,0), X(0,1,0,0,1,0), X(0,1,1,1,0,0), X(0,1,0,0,1,0),
  X(0,1,0,0,1,0), X(0,1,0,0,1,0), X(1,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 67 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 68 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,0,0), X(0,1,0,0,1,0),
  X(0,1,0,0,1,0), X(0,1,0,0,1,0), X(0,1,0,0,1,0), X(0,1,0,0,1,0),
  X(0,1,0,0,1,0), X(0,1,0,0,1,0), X(1,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 69 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,1,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 70 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,1,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 71 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,1,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 72 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,1,1,1,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 73 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 74 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,1,0), X(0,0,0,1,0,0),
  X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,0,0,1,0,0),
  X(0,0,0,1,0,0), X(1,0,0,1,0,0), X(0,1,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 75 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,1,0,0), X(1,0,1,0,0,0), X(1,1,0,0,0,0), X(1,0,1,0,0,0),
  X(1,0,0,1,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 76 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 77 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,1,0,1,1,0), X(1,0,1,0,1,0), X(1,0,1,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 78 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,1,0,0,1,0),
  X(1,1,0,0,1,0), X(1,0,1,0,1,0), X(1,0,1,0,1,0), X(1,0,0,1,1,0),
  X(1,0,0,1,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 79 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 80 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,1,1,1,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 81 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,1,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,1,0),
  X(0,0,0,0,0,0),
  /* character 82 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,1,1,1,0,0), X(1,0,1,0,0,0),
  X(1,0,0,1,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 83 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(0,1,1,1,0,0), X(0,0,0,0,1,0),
  X(0,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 84 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 85 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 86 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,0,1,0,0), X(0,1,0,1,0,0),
  X(0,1,0,1,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 87 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,1,0,1,0), X(1,0,1,0,1,0),
  X(1,0,1,0,1,0), X(1,1,0,1,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 88 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(0,1,0,1,0,0), X(0,1,0,1,0,0), X(0,0,1,0,0,0), X(0,1,0,1,0,0),
  X(0,1,0,1,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 89 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(0,1,0,1,0,0), X(0,1,0,1,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 90 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,1,0),
  X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,0,1,0,0,0), X(0,1,0,0,0,0),
  X(0,1,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 91 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(0,1,0,0,0,0),
  X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,1,0,0,0,0),
  X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 92 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0),
  X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,0,1,0,0,0), X(0,0,0,1,0,0),
  X(0,0,0,1,0,0), X(0,0,0,0,1,0), X(0,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 93 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(0,0,0,1,0,0),
  X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,0,0,1,0,0),
  X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 94 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,1,0,1,0,0),
  X(1,0,0,0,1,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 95 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0),
  X(0,0,0,0,0,0),
  /* character 96 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,0,0,1,0,0),
  X(0,0,0,0,1,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 97 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(0,0,0,0,1,0), X(0,1,1,1,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 98 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,1,1,1,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 99 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 100 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,1,0), X(0,0,0,0,1,0),
  X(0,0,0,0,1,0), X(0,1,1,1,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 101 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0), X(1,1,1,1,1,0),
  X(1,0,0,0,0,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 102 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,1,0,0,1,0),
  X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(1,1,1,1,0,0), X(0,1,0,0,0,0),
  X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,1,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 103 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(0,1,1,1,1,0), X(0,0,0,0,1,0), X(1,0,0,0,1,0),
  X(0,1,1,1,0,0),
  /* character 104 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,1,1,0,0), X(1,1,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 105 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 106 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,1,0,0),
  X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,0,0,1,0,0), X(0,0,0,1,0,0),
  X(0,0,0,1,0,0), X(0,0,0,1,0,0), X(1,0,0,1,0,0), X(1,0,0,1,0,0),
  X(0,1,1,0,0,0),
  /* character 107 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,1,0,0), X(1,0,1,0,0,0), X(1,1,0,0,0,0),
  X(1,0,1,0,0,0), X(1,0,0,1,0,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 108 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 109 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,0,1,0,0), X(1,0,1,0,1,0), X(1,0,1,0,1,0),
  X(1,0,1,0,1,0), X(1,0,1,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 110 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,0,1,1,0,0), X(1,1,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 111 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 112 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,1,1,1,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0),
  /* character 113 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(0,1,1,1,1,0), X(0,0,0,0,1,0), X(0,0,0,0,1,0),
  X(0,0,0,0,1,0),
  /* character 114 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,0,1,1,0,0), X(1,1,0,0,1,0), X(1,0,0,0,0,0),
  X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(1,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 115 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(1,0,0,0,1,0), X(0,1,1,0,0,0),
  X(0,0,0,1,0,0), X(1,0,0,0,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 116 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,0,0,0,0),
  X(0,1,0,0,0,0), X(1,1,1,1,0,0), X(0,1,0,0,0,0), X(0,1,0,0,0,0),
  X(0,1,0,0,0,0), X(0,1,0,0,1,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 117 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,0,1,0), X(1,0,0,1,1,0), X(0,1,1,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 118 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(0,1,0,1,0,0), X(0,1,0,1,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 119 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,1,0,1,0),
  X(1,0,1,0,1,0), X(1,0,1,0,1,0), X(0,1,0,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 120 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(0,1,0,1,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,1,0,1,0,0), X(1,0,0,0,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 121 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0), X(1,0,0,0,1,0),
  X(1,0,0,1,1,0), X(0,1,1,0,1,0), X(0,0,0,0,1,0), X(1,0,0,0,1,0),
  X(0,1,1,1,0,0),
  /* character 122 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,1,0,0), X(0,0,1,0,0,0),
  X(0,1,0,0,0,0), X(1,0,0,0,0,0), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 123 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,1,1,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(1,1,0,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,0,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 124 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 125 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,0,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(0,0,0,1,1,0), X(0,0,1,0,0,0),
  X(0,0,1,0,0,0), X(0,0,1,0,0,0), X(1,1,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 126 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,0,0,1,0), X(1,0,1,0,1,0),
  X(1,0,0,1,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* character 127 */
  X(1,0,1,0,1,0), X(0,1,0,1,0,0), X(1,0,1,0,1,0), X(0,1,0,1,0,0),
  X(1,0,1,0,1,0), X(0,1,0,1,0,0), X(1,0,1,0,1,0), X(0,1,0,1,0,0),
  X(1,0,1,0,1,0), X(0,1,0,1,0,0), X(1,0,1,0,1,0), X(0,1,0,1,0,0),
  X(1,0,1,0,1,0)
};

/* this is the 6x13B font from X11 */
static unsigned char font_bold[128 * 13] = {
  /* bold character 0 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 1 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0), X(1,1,1,1,1,1),
  X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 2 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,1,1,1,1,1), X(0,1,1,1,1,0), X(1,1,1,1,1,1), X(0,1,1,1,1,0),
  X(1,1,1,1,1,1), X(0,1,1,1,1,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 3 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,1,1,0),
  X(1,1,0,1,1,0), X(1,1,1,1,1,0), X(1,1,0,1,1,0), X(1,1,0,1,1,0),
  X(0,0,1,1,1,1), X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,0,0,1,1,0),
  X(0,0,0,1,1,0),
  /* bold character 4 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,0,0),
  X(1,1,0,0,0,0), X(1,1,1,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0),
  X(0,0,1,1,1,1), X(0,0,1,1,0,0), X(0,0,1,1,1,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0),
  /* bold character 5 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0),
  X(1,1,0,0,1,0), X(1,1,0,0,0,0), X(1,1,0,0,1,0), X(0,1,1,1,1,0),
  X(0,1,1,1,1,0), X(0,1,1,0,1,1), X(0,1,1,1,1,0), X(0,1,1,0,1,0),
  X(0,1,1,0,1,1),
  /* bold character 6 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,0,0),
  X(0,0,1,1,1,1), X(0,0,1,1,0,0), X(0,0,1,1,1,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0),
  /* bold character 7 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,1,1,1,0,0), X(1,1,0,1,1,0), X(1,1,0,1,1,0), X(0,1,1,1,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 8 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(1,1,1,1,1,1), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 9 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,1,1,0),
  X(1,1,1,1,1,0), X(1,1,1,1,1,0), X(1,1,0,1,1,0), X(1,1,0,1,1,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,1,1),
  /* bold character 10 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,1,1,0),
  X(1,1,0,1,1,0), X(1,1,0,1,1,0), X(0,1,1,1,0,0), X(0,0,1,0,0,0),
  X(0,0,1,1,1,1), X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,0,0,1,1,0),
  X(0,0,0,1,1,0),
  /* bold character 11 */
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(1,1,1,1,0,0), X(1,1,1,1,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 12 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,0,0), X(1,1,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0),
  /* bold character 13 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,1,1), X(0,0,1,1,1,1),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0),
  /* bold character 14 */
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,1,1), X(0,0,1,1,1,1),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 15 */
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(1,1,1,1,1,1), X(1,1,1,1,1,1),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0),
  /* bold character 16 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(1,1,1,1,1,1),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 17 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,1,1,1,1,1), X(1,1,1,1,1,1), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 18 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(1,1,1,1,1,1),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 19 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,1,1,1,1,1), X(1,1,1,1,1,1), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 20 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(1,1,1,1,1,1),
  X(0,0,0,0,0,0),
  /* bold character 21 */
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,1,1), X(0,0,1,1,1,1),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0),
  /* bold character 22 */
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(1,1,1,1,0,0), X(1,1,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0),
  /* bold character 23 */
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(1,1,1,1,1,1), X(1,1,1,1,1,1),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 24 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(1,1,1,1,1,1),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0),
  /* bold character 25 */
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0),
  /* bold character 26 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,1,1), X(0,0,0,1,1,0),
  X(0,0,1,1,0,0), X(0,1,1,0,0,0), X(0,0,1,1,0,0), X(0,0,0,1,1,0),
  X(0,0,0,0,1,1), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 27 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,0,0),
  X(0,1,1,0,0,0), X(0,0,1,1,0,0), X(0,0,0,1,1,0), X(0,0,1,1,0,0),
  X(0,1,1,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 28 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,1,1,1,1,0),
  X(0,1,1,1,1,0), X(0,1,1,1,1,0), X(1,1,0,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 29 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,1,1), X(1,1,1,1,1,1), X(0,0,1,1,0,0),
  X(1,1,1,1,1,1), X(1,1,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 30 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,1,1,0), X(0,1,1,0,1,1), X(0,1,1,0,0,0), X(1,1,1,1,1,0),
  X(0,1,1,0,0,0), X(1,1,1,1,0,0), X(0,1,1,1,1,0), X(1,1,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 31 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,1,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 32 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 33 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 34 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(0,1,1,1,1,0),
  X(0,1,1,1,1,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 35 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0),
  X(0,1,1,1,1,0), X(1,1,1,1,1,1), X(0,1,1,1,1,0), X(1,1,1,1,1,1),
  X(0,1,1,1,1,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 36 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0),
  X(0,1,1,1,1,0), X(1,1,1,1,0,0), X(0,1,1,1,1,0), X(0,0,1,1,1,1),
  X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 37 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,0,1,1), X(1,1,1,1,1,1),
  X(0,1,1,1,1,0), X(0,0,0,1,1,0), X(0,0,1,1,0,0), X(0,1,1,0,0,0),
  X(0,1,1,1,1,0), X(1,1,1,1,1,1), X(1,1,0,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 38 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,1,1,0,0,0), X(1,1,1,1,0,0), X(1,1,1,1,0,0), X(0,1,1,0,0,0),
  X(1,1,1,1,1,1), X(1,1,0,1,1,0), X(0,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 39 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,1,0), X(0,0,1,1,0,0),
  X(0,1,1,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 40 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,1,1,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(0,1,1,0,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,0,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 41 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,0,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,0,0,1,1,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,1,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 42 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(1,1,1,1,1,1), X(0,1,1,1,1,0),
  X(1,1,0,0,1,1), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 43 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(1,1,1,1,1,1), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 44 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,1,1,1,0), X(0,0,1,1,0,0), X(0,1,1,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 45 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 46 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0), X(0,0,1,1,0,0),
  X(0,0,0,0,0,0),
  /* bold character 47 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,1,1), X(0,0,0,0,1,1),
  X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,0,1,1,0,0), X(0,1,1,0,0,0),
  X(0,1,1,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 48 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 49 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,1,1,1,0,0),
  X(1,1,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 50 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(0,0,0,0,1,1), X(0,0,0,1,1,0), X(0,0,1,1,0,0),
  X(0,1,1,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 51 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,1,1),
  X(0,0,0,1,1,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0), X(0,0,0,0,1,1),
  X(0,0,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 52 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,1,1,0), X(0,0,0,1,1,0),
  X(0,0,1,1,1,0), X(0,1,1,1,1,0), X(0,1,0,1,1,0), X(1,1,0,1,1,0),
  X(1,1,1,1,1,1), X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 53 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,1,1,1,0), X(1,1,1,0,1,1), X(0,0,0,0,1,1),
  X(0,0,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 54 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,1,0), X(0,1,1,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,1,0), X(1,1,1,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 55 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,1,1),
  X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 56 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 57 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,1,1,1), X(0,1,1,1,1,1), X(0,0,0,0,1,1),
  X(0,0,0,0,1,1), X(0,0,0,1,1,0), X(0,1,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 58 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0),
  X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,1,0,0), X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 59 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,1,1,0,0), X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,1,1,1,0), X(0,0,1,1,0,0), X(0,1,1,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 60 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,1,1), X(0,0,0,1,1,0),
  X(0,0,1,1,0,0), X(0,1,1,0,0,0), X(1,1,0,0,0,0), X(0,1,1,0,0,0),
  X(0,0,1,1,0,0), X(0,0,0,1,1,0), X(0,0,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 61 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(1,1,1,1,1,1), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 62 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,0,0), X(0,1,1,0,0,0),
  X(0,0,1,1,0,0), X(0,0,0,1,1,0), X(0,0,0,0,1,1), X(0,0,0,1,1,0),
  X(0,0,1,1,0,0), X(0,1,1,0,0,0), X(1,1,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 63 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(0,0,0,0,1,1), X(0,0,0,1,1,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 64 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,1,1,1), X(1,1,1,1,1,1), X(1,1,1,1,1,1),
  X(1,1,1,1,1,0), X(1,1,0,0,0,0), X(0,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 65 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,1,1,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 66 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,1,1,0,1,1),
  X(0,1,1,0,1,1), X(0,1,1,0,1,1), X(0,1,1,1,1,0), X(0,1,1,0,1,1),
  X(0,1,1,0,1,1), X(0,1,1,0,1,1), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 67 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 68 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(0,1,1,0,1,1),
  X(0,1,1,0,1,1), X(0,1,1,0,1,1), X(0,1,1,0,1,1), X(0,1,1,0,1,1),
  X(0,1,1,0,1,1), X(0,1,1,0,1,1), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 69 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,1,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 70 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,1,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 71 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,1,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 72 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,1,1,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 73 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 74 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,1,1), X(0,0,0,0,1,1),
  X(0,0,0,0,1,1), X(0,0,0,0,1,1), X(0,0,0,0,1,1), X(0,0,0,0,1,1),
  X(0,0,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 75 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,1,1,0), X(1,1,1,1,0,0), X(1,1,1,0,0,0), X(1,1,1,1,0,0),
  X(1,1,0,1,1,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 76 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 77 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,1,1,1,1), X(1,1,1,1,1,1), X(1,1,1,1,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 78 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,1,0,1,1),
  X(1,1,1,0,1,1), X(1,1,1,1,1,1), X(1,1,1,1,1,1), X(1,1,0,1,1,1),
  X(1,1,0,1,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 79 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 80 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,1,1,1,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 81 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,1,1,1,1), X(0,1,1,1,1,0), X(0,0,0,0,1,1),
  X(0,0,0,0,0,0),
  /* bold character 82 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,1,1,1,0), X(1,1,1,1,0,0),
  X(1,1,0,1,1,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 83 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(0,1,1,1,1,0), X(0,0,0,0,1,1),
  X(0,0,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 84 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 85 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 86 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,1,1,1,1,0),
  X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 87 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,1,1,1,1), X(1,1,1,1,1,1),
  X(1,1,1,1,1,1), X(1,1,1,1,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 88 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(0,1,1,1,1,0), X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0),
  X(0,1,1,1,1,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 89 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(0,1,1,1,1,0), X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 90 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,1,1),
  X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,0,1,1,0,0), X(0,1,1,0,0,0),
  X(0,1,1,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 91 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(0,1,1,0,0,0),
  X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(0,1,1,0,0,0),
  X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 92 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0),
  X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(0,0,1,1,0,0), X(0,0,0,1,1,0),
  X(0,0,0,1,1,0), X(0,0,0,0,1,1), X(0,0,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 93 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(0,0,0,1,1,0),
  X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,0,0,1,1,0),
  X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 94 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0),
  X(1,1,0,0,1,1), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 95 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,1,1,1),
  X(0,0,0,0,0,0),
  /* bold character 96 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,1,0), X(0,0,0,1,1,0),
  X(0,0,0,0,1,1), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 97 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(0,0,0,0,1,1), X(0,1,1,1,1,1),
  X(1,1,0,0,1,1), X(1,1,0,1,1,1), X(0,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 98 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,1,1,1,0), X(1,1,1,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,1,0,1,1), X(1,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 99 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 100 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,1,1), X(0,0,0,0,1,1),
  X(0,0,0,0,1,1), X(0,1,1,1,1,1), X(1,1,0,1,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,1,1,1), X(0,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 101 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1), X(1,1,1,1,1,1),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 102 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,1,0), X(0,1,1,0,1,1),
  X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(1,1,1,1,1,0), X(0,1,1,0,0,0),
  X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(0,1,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 103 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,1,1), X(1,1,0,1,1,0), X(1,1,0,1,1,0),
  X(0,1,1,1,0,0), X(1,1,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1),
  X(0,1,1,1,1,0),
  /* bold character 104 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,1,1,1,0), X(1,1,1,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 105 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 106 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,1,1,0),
  X(0,0,0,0,0,0), X(0,0,1,1,1,0), X(0,0,0,1,1,0), X(0,0,0,1,1,0),
  X(0,0,0,1,1,0), X(0,0,0,1,1,0), X(1,1,0,1,1,0), X(1,1,0,1,1,0),
  X(0,1,1,1,0,0),
  /* bold character 107 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,1,1,0), X(1,1,1,1,0,0), X(1,1,1,0,0,0),
  X(1,1,1,1,0,0), X(1,1,0,1,1,0), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 108 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 109 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(1,1,1,1,1,1), X(1,1,1,1,1,1),
  X(1,1,1,1,1,1), X(1,1,1,1,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 110 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(1,1,1,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 111 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 112 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(1,1,1,0,1,1), X(1,1,0,0,1,1),
  X(1,1,1,0,1,1), X(1,1,1,1,1,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0),
  /* bold character 113 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,1,1), X(1,1,0,1,1,1), X(1,1,0,0,1,1),
  X(1,1,0,1,1,1), X(0,1,1,1,1,1), X(0,0,0,0,1,1), X(0,0,0,0,1,1),
  X(0,0,0,0,1,1),
  /* bold character 114 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,0), X(1,1,1,0,1,1), X(1,1,0,0,0,0),
  X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(1,1,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 115 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1), X(0,1,1,1,0,0),
  X(0,0,0,1,1,0), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 116 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,0,0,0),
  X(0,1,1,0,0,0), X(1,1,1,1,1,0), X(0,1,1,0,0,0), X(0,1,1,0,0,0),
  X(0,1,1,0,0,0), X(0,1,1,0,1,1), X(0,0,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 117 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,0,1,1), X(1,1,0,1,1,1), X(0,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 118 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(0,1,1,1,1,0), X(0,1,1,1,1,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 119 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,1,1,1,1),
  X(1,1,1,1,1,1), X(1,1,1,1,1,1), X(0,1,1,1,1,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 120 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(0,1,1,1,1,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,1,1,1,1,0), X(1,1,0,0,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 121 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,0,0,1,1), X(1,1,0,0,1,1), X(1,1,0,0,1,1),
  X(1,1,0,1,1,1), X(0,1,1,1,1,1), X(0,0,0,0,1,1), X(1,1,0,0,1,1),
  X(0,1,1,1,1,0),
  /* bold character 122 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,1,1,0), X(0,0,1,1,0,0),
  X(0,1,1,0,0,0), X(1,1,0,0,0,0), X(1,1,1,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 123 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,1,1,1), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,0,1,1,0), X(0,1,1,1,0,0), X(0,0,0,1,1,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,0,1,1,1), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 124 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 125 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(1,1,1,0,0,0), X(0,0,1,1,0,0),
  X(0,0,1,1,0,0), X(0,1,1,0,0,0), X(0,0,1,1,1,0), X(0,1,1,0,0,0),
  X(0,0,1,1,0,0), X(0,0,1,1,0,0), X(1,1,1,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 126 */
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,1,1,0,1,0), X(1,1,1,1,1,0),
  X(1,0,0,1,1,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0), X(0,0,0,0,0,0),
  X(0,0,0,0,0,0),
  /* bold character 127 */
  X(1,0,1,0,1,0), X(0,1,0,1,0,0), X(1,0,1,0,1,0), X(0,1,0,1,0,0),
  X(1,0,1,0,1,0), X(0,1,0,1,0,0), X(1,0,1,0,1,0), X(0,1,0,1,0,0),
  X(1,0,1,0,1,0), X(0,1,0,1,0,0), X(1,0,1,0,1,0), X(0,1,0,1,0,0),
  X(1,0,1,0,1,0),
};

#else

#define font_height 13
#define font_width 7

#define X(a, b, c, d, e, f, g) \
  ((a<<6)|(b<<5)|(c<<4)|(d<<3)|(e<<2)|(f<<1)|(g<<0))

/* this is the 7x13 font from X11 */
static unsigned char font_normal[128 * 13] = {
  /* character 0 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 1 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,1,0,0,0,0), X(0,1,1,1,0,0,0), X(1,1,1,1,1,0,0),
  X(0,1,1,1,0,0,0), X(0,0,1,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 2 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(1,0,1,1,0,1,0), X(0,1,0,0,1,0,0), X(1,0,1,1,0,1,0), X(0,1,0,0,1,0,0),
  X(1,0,1,1,0,1,0), X(0,1,0,0,1,0,0), X(1,0,1,1,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 3 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,1,0,0,0), X(1,0,0,1,0,0,0),
  X(1,1,1,1,0,0,0), X(1,0,0,1,0,0,0), X(1,0,0,1,0,0,0), X(0,0,0,1,1,1,0),
  X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0),
  X(0,0,0,0,0,0,0),
  /* character 4 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,0,0,0), X(1,0,0,0,0,0,0),
  X(1,1,1,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(0,0,1,1,1,1,0),
  X(0,0,1,0,0,0,0), X(0,0,1,1,1,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 5 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(0,0,1,1,1,0,0),
  X(0,0,1,0,0,1,0), X(0,0,1,1,1,0,0), X(0,0,1,0,1,0,0), X(0,0,1,0,0,1,0),
  X(0,0,0,0,0,0,0),
  /* character 6 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,1,1,1,0,0,0), X(0,0,1,1,1,1,0),
  X(0,0,1,0,0,0,0), X(0,0,1,1,1,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 7 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(1,0,0,0,1,0,0),
  X(1,0,0,0,1,0,0), X(0,1,1,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 8 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(1,1,1,1,1,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 9 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,1,0,0), X(1,1,0,0,1,0,0),
  X(1,0,1,0,1,0,0), X(1,0,0,1,1,0,0), X(1,0,0,0,1,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,1,1,1,0),
  X(0,0,0,0,0,0,0),
  /* character 10 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,1,0,0),
  X(0,1,0,1,0,0,0), X(0,1,0,1,0,0,0), X(0,0,1,0,0,0,0), X(0,1,1,1,1,1,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 11 */
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(1,1,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 12 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0),
  /* character 13 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,1,1,1), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0),
  /* character 14 */
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,1,1,1), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 15 */
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(1,1,1,1,1,1,1), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0),
  /* character 16 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,1), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 17 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(1,1,1,1,1,1,1), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 18 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,1), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 19 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(1,1,1,1,1,1,1), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 20 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,1), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 21 */
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,1,1,1), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0),
  /* character 22 */
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(1,1,1,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0),
  /* character 23 */
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(1,1,1,1,1,1,1), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 24 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,1), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0),
  /* character 25 */
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0),
  /* character 26 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,1,0),
  X(0,0,0,1,1,0,0), X(0,1,1,0,0,0,0), X(1,0,0,0,0,0,0), X(0,1,1,0,0,0,0),
  X(0,0,0,1,1,0,0), X(0,0,0,0,0,1,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 27 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,0,0),
  X(0,1,1,0,0,0,0), X(0,0,0,1,1,0,0), X(0,0,0,0,0,1,0), X(0,0,0,1,1,0,0),
  X(0,1,1,0,0,0,0), X(1,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 28 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,1,0,0,1,0,0),
  X(0,1,0,0,1,0,0), X(0,1,0,0,1,0,0), X(1,0,0,0,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 29 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,1,0,0), X(1,1,1,1,1,1,0), X(0,0,0,1,0,0,0), X(0,0,1,0,0,0,0),
  X(1,1,1,1,1,1,0), X(0,1,0,0,0,0,0), X(1,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 30 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0),
  X(0,1,0,0,0,1,0), X(0,1,0,0,0,0,0), X(1,1,1,0,0,0,0), X(0,1,0,0,0,0,0),
  X(0,1,0,0,0,0,0), X(0,1,0,0,0,1,0), X(1,0,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 31 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 32 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 33 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 34 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,0,1,0,0), X(0,0,1,0,1,0,0),
  X(0,0,1,0,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 35 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,0,1,0,0),
  X(0,0,1,0,1,0,0), X(0,1,1,1,1,1,0), X(0,0,1,0,1,0,0), X(0,1,1,1,1,1,0),
  X(0,0,1,0,1,0,0), X(0,0,1,0,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 36 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,1,1,1,1,0), X(0,1,0,1,0,0,0), X(0,0,1,1,1,0,0), X(0,0,0,1,0,1,0),
  X(0,1,1,1,1,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 37 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,0,0,0,1,0), X(1,0,1,0,0,1,0),
  X(0,1,0,0,1,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,1,0,0,0,0),
  X(0,1,0,0,1,0,0), X(1,0,0,1,0,1,0), X(1,0,0,0,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 38 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,1,1,0,0,0,0), X(1,0,0,1,0,0,0), X(1,0,0,1,0,0,0), X(0,1,1,0,0,0,0),
  X(1,0,0,1,0,1,0), X(1,0,0,0,1,0,0), X(0,1,1,1,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 39 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0), X(0,0,1,1,0,0,0),
  X(0,1,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 40 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 41 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,1,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 42 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,1,0,0,1,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,0), X(0,0,1,1,0,0,0),
  X(0,1,0,0,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 43 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,1,1,1,1,1,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 44 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,1,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 45 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 46 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,1,1,1,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 47 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,1,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,1,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 48 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,0,0,1,0,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(0,1,0,0,1,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 49 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,1,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 50 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(0,0,0,0,0,1,0), X(0,0,0,0,1,0,0), X(0,0,1,1,0,0,0),
  X(0,1,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 51 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(0,0,0,0,0,1,0), X(0,0,0,0,0,1,0), X(0,0,1,1,1,0,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 52 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,0,0), X(0,0,0,1,1,0,0),
  X(0,0,1,0,1,0,0), X(0,1,0,0,1,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,1,0,0),
  X(1,1,1,1,1,1,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 53 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,1,1,1,0,0), X(1,1,0,0,0,1,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 54 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0), X(0,1,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,1,1,1,0,0), X(1,1,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 55 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,1,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 56 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 57 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,1,1,0), X(0,1,1,1,0,1,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,0,1,0), X(0,0,0,0,1,0,0), X(0,1,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 58 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,1,1,1,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,1,1,1,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 59 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,1,1,1,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,1,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 60 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,1,0), X(0,0,0,0,1,0,0),
  X(0,0,0,1,0,0,0), X(0,0,1,0,0,0,0), X(0,1,0,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 61 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 62 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,0,1,0), X(0,0,0,0,1,0,0),
  X(0,0,0,1,0,0,0), X(0,0,1,0,0,0,0), X(0,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 63 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(0,0,0,0,0,1,0), X(0,0,0,0,1,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 64 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,1,1,1,0), X(1,0,1,0,0,1,0), X(1,0,1,0,1,1,0),
  X(1,0,0,1,0,1,0), X(1,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 65 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,0,0,1,0,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,1,1,1,1,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 66 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(0,1,0,0,0,1,0),
  X(0,1,0,0,0,1,0), X(0,1,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,1,0,0,0,1,0),
  X(0,1,0,0,0,1,0), X(0,1,0,0,0,1,0), X(1,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 67 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 68 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(0,1,0,0,0,1,0),
  X(0,1,0,0,0,1,0), X(0,1,0,0,0,1,0), X(0,1,0,0,0,1,0), X(0,1,0,0,0,1,0),
  X(0,1,0,0,0,1,0), X(0,1,0,0,0,1,0), X(1,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 69 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,1,1,1,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 70 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,1,1,1,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 71 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,1,1,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,1,1,0), X(0,1,1,1,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 72 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,1,1,1,1,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 73 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(1,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 74 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,1,1,0), X(0,0,0,0,1,0,0),
  X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0),
  X(0,0,0,0,1,0,0), X(1,0,0,0,1,0,0), X(0,1,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 75 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,1,0,0),
  X(1,0,0,1,0,0,0), X(1,0,1,0,0,0,0), X(1,1,0,0,0,0,0), X(1,0,1,0,0,0,0),
  X(1,0,0,1,0,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 76 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 77 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,0,1,1,0,1,0), X(1,0,1,1,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 78 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,1,0,0,0,1,0), X(1,0,1,0,0,1,0), X(1,0,0,1,0,1,0), X(1,0,0,0,1,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 79 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 80 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,1,1,1,1,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 81 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,1,0,0,1,0), X(1,0,0,1,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,0,0,0),
  /* character 82 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,1,1,1,1,0,0), X(1,0,1,0,0,0,0),
  X(1,0,0,1,0,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 83 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 84 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 85 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 86 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(0,1,0,0,1,0,0), X(0,1,0,0,1,0,0), X(0,1,0,0,1,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 87 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,1,1,0,1,0), X(1,0,1,1,0,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 88 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(0,1,0,0,1,0,0), X(0,1,0,0,1,0,0), X(0,0,1,1,0,0,0), X(0,1,0,0,1,0,0),
  X(0,1,0,0,1,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 89 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,1,0,0),
  X(0,1,0,1,0,0,0), X(0,1,0,1,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 90 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,1,0,0), X(0,0,0,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,0,0,0,0),
  X(0,1,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 91 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,1,0,0,0,0,0),
  X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0),
  X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 92 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,1,0,0),
  X(0,0,0,0,1,0,0), X(0,0,0,0,0,1,0), X(0,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 93 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,1,0,0),
  X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0),
  X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 94 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,1,0,1,0,0),
  X(0,1,0,0,0,1,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 95 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0),
  X(0,0,0,0,0,0,0),
  /* character 96 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 97 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,1,0), X(0,1,1,1,1,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,1,1,0), X(0,1,1,1,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 98 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,1,1,1,0,0), X(1,1,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,1,0,0,0,1,0), X(1,0,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 99 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 100 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,1,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,0,1,0), X(0,1,1,1,0,1,0), X(1,0,0,0,1,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,1,1,0), X(0,1,1,1,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 101 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0), X(1,1,1,1,1,1,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 102 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0), X(0,1,0,0,0,1,0),
  X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(1,1,1,1,0,0,0), X(0,1,0,0,0,0,0),
  X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 103 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,0,1,0), X(1,0,0,0,1,0,0), X(1,0,0,0,1,0,0),
  X(0,1,1,1,0,0,0), X(1,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0),
  X(0,1,1,1,1,0,0),
  /* character 104 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,1,1,1,0,0), X(1,1,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 105 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(1,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 106 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,1,1,0,0), X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0),
  X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,1,0,0),
  X(0,1,1,1,0,0,0),
  /* character 107 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,1,0,0), X(1,0,0,1,0,0,0), X(1,1,1,0,0,0,0),
  X(1,0,0,1,0,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 108 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(1,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 109 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,0,1,0,0,0), X(1,0,1,0,1,0,0), X(1,0,1,0,1,0,0),
  X(1,0,1,0,1,0,0), X(1,0,1,0,1,0,0), X(1,0,0,0,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 110 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,0,1,1,1,0,0), X(1,1,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 111 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 112 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,0,1,1,1,0,0), X(1,1,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,1,0,0,0,1,0), X(1,0,1,1,1,0,0), X(1,0,0,0,0,0,0), X(1,0,0,0,0,0,0),
  X(1,0,0,0,0,0,0),
  /* character 113 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,0,1,0), X(1,0,0,0,1,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,1,1,0), X(0,1,1,1,0,1,0), X(0,0,0,0,0,1,0), X(0,0,0,0,0,1,0),
  X(0,0,0,0,0,1,0),
  /* character 114 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,0,1,1,1,0,0), X(0,1,0,0,0,1,0), X(0,1,0,0,0,0,0),
  X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 115 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,0,1,0), X(0,1,1,0,0,0,0),
  X(0,0,0,1,1,0,0), X(1,0,0,0,0,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 116 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,0,0,0,0,0),
  X(0,1,0,0,0,0,0), X(1,1,1,1,0,0,0), X(0,1,0,0,0,0,0), X(0,1,0,0,0,0,0),
  X(0,1,0,0,0,0,0), X(0,1,0,0,0,1,0), X(0,0,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 117 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,0,1,0), X(1,0,0,0,1,1,0), X(0,1,1,1,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 118 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,1,0,0),
  X(0,1,0,1,0,0,0), X(0,1,0,1,0,0,0), X(0,0,1,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 119 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,0,0,0,1,0,0), X(1,0,0,0,1,0,0), X(1,0,1,0,1,0,0),
  X(1,0,1,0,1,0,0), X(1,0,1,0,1,0,0), X(0,1,0,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 120 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(0,1,0,0,1,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,1,0,0,1,0,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 121 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(1,0,0,0,1,1,0), X(0,1,1,1,0,1,0), X(0,0,0,0,0,1,0), X(1,0,0,0,0,1,0),
  X(0,1,1,1,1,0,0),
  /* character 122 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,1,0,0), X(0,0,0,1,0,0,0),
  X(0,0,1,0,0,0,0), X(0,1,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 123 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,1,1,0), X(0,0,1,0,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,0,1,0,0,0), X(0,1,1,0,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,1,0,0,0,0), X(0,0,1,0,0,0,0), X(0,0,0,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 124 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0),
  X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 125 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(0,0,0,0,1,0,0),
  X(0,0,0,0,1,0,0), X(0,0,0,1,0,0,0), X(0,0,0,0,1,1,0), X(0,0,0,1,0,0,0),
  X(0,0,0,0,1,0,0), X(0,0,0,0,1,0,0), X(0,1,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 126 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,0,0,1,0), X(0,1,0,1,0,1,0),
  X(0,1,0,0,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 127 */
  X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0), X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0),
  X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0), X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0),
  X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0), X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0),
  X(0,1,0,1,0,1,0)
};

/* this is the 7x13B font from X11 */
static unsigned char font_bold[128 * 13] = {
  /* character 0 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 1 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,1,1,1,0,0), X(1,1,1,1,1,1,0),
  X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 2 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(0,0,1,1,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(0,0,1,1,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 3 */
  X(0,0,0,0,0,0,0), X(1,1,0,1,1,0,0), X(1,1,0,1,1,0,0), X(1,1,1,1,1,0,0),
  X(1,1,0,1,1,0,0), X(1,1,0,1,1,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,1,0),
  X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0),
  X(0,0,0,0,0,0,0),
  /* character 4 */
  X(0,0,0,0,0,0,0), X(1,1,1,1,0,0,0), X(1,1,0,0,0,0,0), X(1,1,1,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,1,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 5 */
  X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(0,1,1,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0),
  X(0,0,1,1,0,1,0), X(0,0,1,1,1,0,0), X(0,0,1,1,0,1,0), X(0,0,1,1,0,1,0),
  X(0,0,0,0,0,0,0),
  /* character 6 */
  X(0,0,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,1,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,1,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 7 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 8 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 9 */
  X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,1,0,1,1,0), X(1,1,1,1,1,1,0),
  X(1,1,0,1,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,1,1,0),
  X(0,0,0,0,0,0,0),
  /* character 10 */
  X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,0,0,1,0,0),
  X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,1,0),
  X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0),
  X(0,0,0,0,0,0,0),
  /* character 11 */
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,0,0,0), X(1,1,1,1,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 12 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,0,0,0), X(1,1,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0),
  /* character 13 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,1,1), X(0,0,1,1,1,1,1),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0),
  /* character 14 */
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,1,1,1), X(0,0,1,1,1,1,1),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 15 */
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,1), X(1,1,1,1,1,1,1),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0),
  /* character 16 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,1), X(1,1,1,1,1,1,1),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 17 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(1,1,1,1,1,1,1), X(1,1,1,1,1,1,1), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 18 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,1), X(1,1,1,1,1,1,1),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 19 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(1,1,1,1,1,1,1), X(1,1,1,1,1,1,1), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 20 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,1), X(1,1,1,1,1,1,1),
  X(0,0,0,0,0,0,0),
  /* character 21 */
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,1,1,1), X(0,0,1,1,1,1,1),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0),
  /* character 22 */
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,0,0,0), X(1,1,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0),
  /* character 23 */
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,1), X(1,1,1,1,1,1,1),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 24 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,1), X(1,1,1,1,1,1,1),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0),
  /* character 25 */
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0),
  /* character 26 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,1,0), X(0,0,0,1,1,0,0),
  X(0,1,1,0,0,0,0), X(1,1,0,0,0,0,0), X(0,1,1,0,0,0,0), X(0,0,0,1,1,0,0),
  X(0,0,0,0,1,1,0), X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 27 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,0,0,0), X(0,1,1,0,0,0,0),
  X(0,0,0,1,1,0,0), X(0,0,0,0,1,1,0), X(0,0,0,1,1,0,0), X(0,1,1,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 28 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,1,1,0,1,1,0), X(0,1,1,0,1,1,0),
  X(0,1,1,0,1,1,0), X(1,1,1,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 29 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,1,0), X(0,0,0,0,1,1,0),
  X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,0),
  X(1,1,1,1,1,1,0), X(1,1,0,0,0,0,0), X(1,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 30 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0), X(0,1,1,0,1,1,0),
  X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(1,1,1,1,0,0,0), X(0,1,1,0,0,0,0),
  X(0,1,1,0,0,0,0), X(0,1,1,0,1,1,0), X(1,0,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 31 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 32 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 33 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 34 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,0,1,1,0), X(0,1,1,0,1,1,0),
  X(0,1,1,0,1,1,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 35 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,0,1,0,0), X(0,0,1,0,1,0,0),
  X(0,1,1,1,1,1,0), X(0,1,1,1,1,1,0), X(0,0,1,0,1,0,0), X(0,1,1,1,1,1,0),
  X(0,1,1,1,1,1,0), X(0,0,1,0,1,0,0), X(0,0,1,0,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 36 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,1,1,1,0,0),
  X(1,0,1,1,0,1,0), X(1,0,1,1,0,0,0), X(0,1,1,1,1,0,0), X(0,0,1,1,0,1,0),
  X(1,0,1,1,0,1,0), X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 37 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,0,0,1,0), X(1,0,1,0,1,1,0),
  X(1,1,1,0,1,0,0), X(0,0,0,1,1,0,0), X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0),
  X(0,1,0,1,1,1,0), X(1,1,0,1,0,1,0), X(1,0,0,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 38 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(1,1,0,1,1,0,0),
  X(1,1,0,1,1,0,0), X(1,1,0,1,1,0,0), X(0,1,1,1,0,0,0), X(1,1,0,1,0,1,0),
  X(1,1,0,1,1,1,0), X(1,1,0,1,1,0,0), X(0,1,1,1,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 39 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0), X(0,0,1,1,1,0,0),
  X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 40 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,1,1,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 41 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,0,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 42 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,1,0,0,1,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0),
  X(0,0,1,1,0,0,0), X(0,1,0,0,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 43 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 44 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,1,1,1,0,0), X(0,0,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 45 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 46 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 47 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0),
  X(0,1,1,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 48 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,0,0,1,0,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(0,1,0,0,1,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 49 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,1,1,0,0,0),
  X(1,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 50 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(0,0,0,0,1,1,0), X(0,0,1,1,1,0,0), X(0,1,1,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 51 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0), X(0,0,1,1,1,0,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 52 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,1,0), X(0,0,0,1,1,1,0),
  X(0,0,1,1,1,1,0), X(0,1,1,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,1,1,1,1,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 53 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 54 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 55 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 56 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 57 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 58 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,1,1,0,0,0), X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 59 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,1,1,0,0,0), X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,1,1,1,0,0), X(0,0,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 60 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,1,0), X(0,0,0,1,1,0,0),
  X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0), X(1,1,0,0,0,0,0), X(0,1,1,0,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,0,1,1,0,0), X(0,0,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 61 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0),
  X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 62 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,0,0,0), X(0,1,1,0,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,0,1,1,0,0), X(0,0,0,0,1,1,0), X(0,0,0,1,1,0,0),
  X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0), X(1,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 63 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(0,0,0,0,1,1,0), X(0,0,1,1,1,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 64 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,0,0,0,1,1,0),
  X(1,0,0,0,1,1,0), X(1,0,1,1,1,1,0), X(1,0,1,0,1,1,0), X(1,0,1,1,1,1,0),
  X(1,0,0,0,0,0,0), X(1,0,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 65 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 66 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 67 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 68 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 69 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 70 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 71 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,1,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 72 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 73 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 74 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 75 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,0,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,1,1,0,0), X(1,1,1,1,0,0,0), X(1,1,1,0,0,0,0), X(1,1,1,1,0,0,0),
  X(1,1,0,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 76 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 77 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,1,0,0,1,1,0),
  X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 78 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,1,0,1,1,0), X(1,1,1,0,1,1,0), X(1,1,1,1,1,1,0), X(1,1,0,1,1,1,0),
  X(1,1,0,1,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 79 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 80 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 81 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,1,0,1,1,0), X(1,1,0,1,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,0,0,0),
  /* character 82 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,0,0), X(1,1,1,1,0,0,0),
  X(1,1,0,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 83 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 84 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 85 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 86 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(0,1,0,0,1,0,0), X(0,1,0,0,1,0,0), X(0,1,1,1,1,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 87 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,1,0),
  X(1,1,1,1,1,1,0), X(1,1,0,0,1,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 88 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,0,0,0,0,1,0), X(1,1,0,0,1,1,0),
  X(0,1,0,0,1,0,0), X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,1,1,1,1,0,0),
  X(0,1,0,0,1,0,0), X(1,1,0,0,1,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 89 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(0,1,1,1,1,0,0), X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 90 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(0,0,0,1,1,0,0), X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 91 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,1,1,0,0,0,0),
  X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0),
  X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 92 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,1,1,0,0),
  X(0,0,0,1,1,0,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 93 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,0,0,1,1,0,0),
  X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0),
  X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 94 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,1,1,1,0,0),
  X(1,1,0,0,1,1,0), X(1,0,0,0,0,1,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 95 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0),
  X(0,0,0,0,0,0,0),
  /* character 96 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(0,1,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,0,1,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 97 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(0,0,0,0,1,1,0), X(0,1,1,1,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 98 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 99 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 100 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(0,1,1,1,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 101 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,1,1,1,1,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 102 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0), X(0,1,1,0,1,1,0),
  X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(1,1,1,1,0,0,0), X(0,1,1,0,0,0,0),
  X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 103 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,0,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(0,1,1,1,1,0,0), X(1,1,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0),
  X(0,1,1,1,1,0,0),
  /* character 104 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 105 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 106 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(0,1,1,1,1,0,0),
  /* character 107 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,1,1,0,0), X(1,1,1,1,0,0,0),
  X(1,1,1,1,0,0,0), X(1,1,0,1,1,0,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 108 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 109 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,0,1,1,0,0), X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 110 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 111 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 112 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,1,1,1,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0),
  /* character 113 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(0,1,1,1,1,1,0), X(0,0,0,0,1,1,0), X(0,0,0,0,1,1,0),
  X(0,0,0,0,1,1,0),
  /* character 114 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 115 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(0,1,1,0,0,0,0),
  X(0,0,0,1,1,0,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 116 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,1,1,0,0,0), X(1,1,0,0,0,0,0), X(1,1,0,0,0,0,0),
  X(1,1,0,0,0,0,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 117 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 118 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(0,1,1,1,1,0,0), X(0,1,1,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 119 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,1,1,1,1,0), X(1,1,1,1,1,1,0), X(0,1,0,0,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 120 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,1,1,1,1,0,0),
  X(0,1,1,1,1,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 121 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(1,1,0,0,1,1,0), X(0,1,1,1,1,1,0), X(0,0,0,0,1,1,0), X(1,1,0,0,1,1,0),
  X(0,1,1,1,1,0,0),
  /* character 122 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,1,1,0), X(0,0,0,1,1,0,0),
  X(0,1,1,0,0,0,0), X(1,1,0,0,0,0,0), X(1,1,1,1,1,1,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 123 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,1,0,0), X(0,1,1,0,0,0,0),
  X(0,1,1,0,0,0,0), X(0,0,1,1,0,0,0), X(0,1,1,0,0,0,0), X(0,0,1,1,0,0,0),
  X(0,1,1,0,0,0,0), X(0,1,1,0,0,0,0), X(0,0,1,1,1,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 124 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0),
  X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 125 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,1,0,0,0), X(0,0,0,1,1,0,0),
  X(0,0,0,1,1,0,0), X(0,0,1,1,0,0,0), X(0,0,0,1,1,0,0), X(0,0,1,1,0,0,0),
  X(0,0,0,1,1,0,0), X(0,0,0,1,1,0,0), X(0,1,1,1,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 126 */
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,1,1,0,0,1,0), X(1,1,1,1,1,1,0),
  X(1,0,0,1,1,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0), X(0,0,0,0,0,0,0),
  X(0,0,0,0,0,0,0),
  /* character 127 */
  X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0), X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0),
  X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0), X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0),
  X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0), X(0,1,0,1,0,1,0), X(0,0,1,0,1,0,0),
  X(0,1,0,1,0,1,0)
};

#endif

static struct display console_display;

/* access all fields in the display structure */
#define display_height      console_display.height
#define display_width       console_display.width
#define display_rowsize     console_display.rowsize
#define display_offset      console_display.offset
#define max_x               console_display.max.x
#define max_y               console_display.max.y
#define cursor_x            console_display.cursor.x
#define cursor_y            console_display.cursor.y
#define new_x               console_display.new.x
#define new_y               console_display.new.y
#define display_mode        console_display.mode
#define display_state       console_display.state
#define display_status      console_display.status
#define display_status_mode console_display.status_mode
#define display_buffer      console_display.buffer
#define display_termcap     console_display.termcap

/* display char at position (x, y), (0, 0) is upper left, -1 is cursor. */
static display_char(int x, int y, int c)
{
  register unsigned int *b, bits, mask1, mask2;
  register int i;
  unsigned int mask;
  int shift1, shift2, mode, lastrow, bits_base;
  unsigned char *bits_array;

#ifdef DEBUG
  printf("display_char(%d, %d, %d)\n\r", x, y, c);
#endif
#ifndef KERNEL
  if ((x < 0) || (x >= max_x)) printf("display_char: x = %d\n\r", x);
  if ((y < 0) || (y > max_y)) printf("display_char: y = %d\n\r", y);
  if (c > 127) printf("display_char: c = %d\n\r", c);
#endif
  x = (x * font_width) + display_offset;
  y = y * font_height;
  mask = (1 << font_width) - 1;
  shift1 = 32 - font_width - x % 32;
  if (shift1 >= 0) {
    mask1 = mask << shift1;
    shift2 = 0;
  }
  else {
    shift1 = -shift1;
    shift2 = 32 - shift1;
    mask1 = mask >> shift1;
    mask2 = mask << shift2;
  }
  b = &display_buffer[(y * display_rowsize) + (x / 32)];

  if (c < 0) {
    for (i = 0; i < font_height; i++) {
      if (!shift2) *b ^= mask1;
      else {
        b[0] ^= mask1;
        b[1] ^= mask2;
      }
      b += display_rowsize;
    }

  }
  else {
    if (c < ' ') c = ' ';
    mode = display_status ? display_status_mode ^ INVERSE : display_mode;
    if (mode & GRAPHIC) c = c - 'j' + 11;
    bits_base = c * font_height;
    bits_array = (mode & BOLD) ? font_bold : font_normal;
    lastrow = font_height - 1;
    for (i = 0; i <= lastrow; i++) {
      if ((mode & UNDERLINE) && (i == lastrow)) bits = mask & -1;
      else bits = bits_array[bits_base + i];
      if (!shift2) {
        *b &= ~mask1;
        if (mode & INVERSE) *b |= (~(bits << shift1)) & mask1;
        else *b |= bits << shift1;
      }
      else {
        b[0] &= ~mask1;
        b[1] &= ~mask2;
        if (mode & INVERSE) {
          b[0] |= (~(bits >> shift1)) & mask1;
          b[1] |= (~(bits << shift2)) & mask2;
        }
        else {
          b[0] |= bits >> shift1;
          b[1] |= bits << shift2;
        }
      }
      b += display_rowsize;
    }
  }

} /* display_char() */

/* Clear the specified line, set y == max_y for status line */
static void display_ceol(register int x, register int y)
{
  register unsigned int *b, *end;
  register int i;

#ifdef DEBUG
  printf("display_ceol(%d, %d)\n\r", x, y);
#endif
#ifndef KERNEL
  if ((x < 0) || (x >= max_x)) printf("display_ceol: x = %d\n\r", x);
  if ((y < 0) || (y > max_y)) printf("display_ceol: y = %d\n\r", y);
#endif
  /* it is faster to clear the entire line */
  if (!x) {
    b = &display_buffer[y * font_height * display_rowsize];
    end = &b[font_height * display_rowsize];
    if (y == max_y) while (b != end) *b++ = -1;
    else while (b != end) *b++ = 0;
  }
  else for (i = x; i < max_x; i++) display_char(i, y, ' ');

} /* display_ceol() */

/* Clear from (x, y) to end of display -- don't use for status line */
static void display_ceod(int x, int y)
{
  register unsigned int *b, *end;

#ifdef DEBUG
  printf("display_ceod(%d, %d)\n\r", x, y);
#endif
#ifndef KERNEL
  if ((x < 0) || (x >= max_x)) printf("display_ceod: x = %d\n\r", x);
  if ((y < 0) || (y >= max_y)) printf("display_ceod: y = %d\n\r", y);
#endif
  if (!x) display_ceol(x, y++);
  b = &display_buffer[y * font_height * display_rowsize];
  end = &display_buffer[max_y * font_height * display_rowsize];
  while (b != end) *b++ = 0;
  display_char(cursor_x, cursor_y, -1);

} /* display_ceod() */

/* Scroll up or down onto the specified line. */
static void display_scroll(int y, int down)
{
  register unsigned int *to, *from, *end;
  int to_y, from_y, end_y;

#ifdef DEBUG
  printf("display_scroll(%d, %d)\n\r", y, down);
#endif
#ifndef KERNEL
  if ((y < 0) || (y >= max_y)) printf("display_scroll: y = %d\n\r", y);
#endif
  y = (y * font_height);
  if (down) { /* scroll down onto line */
    to_y = (y + font_height - 1);
    from_y = y - 1;
    end_y = -1;
    to = &display_buffer[to_y * display_rowsize];
    from = &display_buffer[from_y * display_rowsize];
    end = &display_buffer[end_y * display_rowsize + (display_rowsize - 1)];
    while (from != end) *to-- = *from--;
  }
  else { /* scroll up onto line */
    to_y = y;
    from_y = y + font_height;
    end_y = font_height * max_y;
    to = &display_buffer[to_y * display_rowsize];
    from = &display_buffer[from_y * display_rowsize];
    end = &display_buffer[end_y * display_rowsize];
    while (to != end) *to++ = *from++;
  }

} /* display_scroll() */

/* Blink the entire display. */
static void display_blink(void)
{
  register unsigned int *start;
  register unsigned int *end;

#ifdef DEBUG
  printf("display_blink()\n\r");
#endif
  end = &display_buffer[display_height * display_rowsize];
  for (start = display_buffer; start != end; start++) *start = ~*start;
  for (start = display_buffer; start != end; start++) *start = ~*start;

} /* display_blink() */

/* Display a character, emulate a vt52 terminal. */
void display(unsigned char c)
{
  int x, y;
  char *t;

#ifdef DEBUG
  printf("display(%d)\n\r", c);
#endif

  /* remove cursor */
  display_char(cursor_x, cursor_y, -1);

  /* a simple state machine */
  switch (display_state) {

    case 0: /* not in escape sequence */
      c &= 127;
      switch (c) {
        case '[' - '@': /* begin escape sequence */
          display_state = 1;
          break;
        case 'J' - '@': /* do, down one line */
          if (display_status) display_status = 0;
          else {
            cursor_y++;
            if (cursor_y >= max_y) {
              cursor_y = max_y - 1;
              display_scroll(0, 0);
              display_ceol(0, max_y - 1);
            }
          }
          break;
        case 'M' - '@': /* ^M, carriage return */
          if (display_status) display_status = 1;
          else cursor_x = 0;
          break;
        case 'H' - '@': /* le, cursor left */
          if (display_status) {
            if (display_status > 1) display_status--;
            display_char(display_status - 1, max_y, ' ');
          }
          else {
            if (cursor_x) cursor_x--;
            display_char(cursor_x, cursor_y, ' ');
          }
          break;
        case 'I' - '@': /* ^I, tab */
          if (display_status) {
            x = (display_status - 1) + (8 - ((display_status - 1) % 8));
            if (x < max_x) display_status = x + 1;
          }
          else {
            x = cursor_x + (8 - (cursor_x % 8));
            if (x < max_x) cursor_x = x;
          }
          break;
        case 'G' - '@': /* ^G, beep */
          display_blink();
          break;
        case 'A' - '@': /* ^A, enter and clear the status line */
          display_status = 1;
          display_status_mode = 0;
          display_ceol(0, max_y);
          break;
        case 'B' - '@': /* ^B, exit the status line */
          display_status = 0;
          break;
        default: /* paint the character at cursor position, advance cursor */
          if (display_status) {
            display_char(display_status++ - 1, max_y, c);
            if (display_status > max_x) display_status = 1;
          }
          else {
            display_char(cursor_x++, cursor_y, c);
            if (cursor_x >= max_x) { /* am, automatic margin */
              cursor_x = 0;
              cursor_y++;
              if (cursor_y >= max_y) {
                cursor_y = max_y - 1;
                display_scroll(0, 0);
                display_ceol(0, max_y - 1);
              }
            }
          }
          break;
      }
      break;

    case 1: /* first char of escape sequence */
      c &= 127;
      switch (c) {
        case 'Y': /* cm, new cursor position follows */
          display_state = 2;
          break;
        case 'S': /* ts, status line column follows */
          display_state = 4;
          break;
        case 'J': /* cd, clear from cursor to end of display */
          display_state = 0;
          if (display_status) display_ceol(display_status - 1, max_y);
          else {
/*
#ifdef KERNEL
            if (!cursor_x && !cursor_y) video_setup(&video[0], FALSE);
#endif
*/
            display_ceod(cursor_x, cursor_y);
          }
          break;
        case 'K': /* ce, clear to end of line */
          display_state = 0;
          if (display_status) display_ceol(display_status - 1, max_y);
          else display_ceol(cursor_x, cursor_y);
          break;
        case 'H': /* ho, home cursor */
          display_state = 0;
          if (display_status) display_status = 1;
          else cursor_x = cursor_y = 0;
          break;
        case 'C': /* nd, cursor right */
          display_state = 0;
          if (display_status) {
            display_status++;
            if (display_status > max_x) display_status = max_x;
          }
          else {
            cursor_x++;
            if (cursor_x >= max_x) cursor_x = max_x - 1;
          }
          break;
        case 'I': /* sr, scroll text down */
          display_state = 0;
          if (display_status) break;
          cursor_y++;
          if (cursor_y >= max_y) cursor_y = max_y - 1;
          display_scroll(max_y - 1, -1);
          display_ceol(0, 0);
          break;
        case 'A': /* up, cursor up */
          display_state = 0;
          if (display_status) break;
          cursor_y--;
          if (cursor_y < 0) cursor_y = 0;
          break;
        case 'j': /* so, mr, start standout mode */
          display_state = 0;
          if (display_status) display_status_mode |= INVERSE;
          else display_mode |= INVERSE;
          break;
        case 'k': /* se, end standout mode */
          display_state = 0;
          if (display_status) display_status_mode &= ~INVERSE;
          else display_mode &= ~INVERSE;
          break;
        case 'l': /* us, start underline mode */
          display_state = 0;
          if (display_status) display_status_mode |= UNDERLINE;
          else display_mode |= UNDERLINE;
          break;
        case 'm': /* ue, end underline mode */
          display_state = 0;
          if (display_status) display_status_mode &= ~UNDERLINE;
          else display_mode &= ~UNDERLINE;
          break;
        case 'n': /* as, start alternate (graphic) mode */
          display_state = 0;
          if (display_status) display_status_mode |= GRAPHIC;
          else display_mode |= GRAPHIC;
          break;
        case 'o': /* ae, end alternate (graphic) mode */
          display_state = 0;
          if (display_status) display_status_mode &= ~GRAPHIC;
          else display_mode &= ~GRAPHIC;
          break;
        case 'p': /* md, start bold mode */
          display_state = 0;
          if (display_status) display_status_mode |= BOLD;
          else display_mode |= BOLD;
          break;
        case 'q': /* me, end all modes */
          display_state = 0;
          if (display_status) display_status_mode = 0;
          else display_mode = 0;
          break;
      }
      break;

    case 2: /* pick up new cursor X */
      new_y = c - ' ';
      display_state = 3;
      break;

    case 3: /* pick up new cursor Y, set new cursor position */
      new_x = c - ' ';
      display_state = 0;
      if ((new_x < 0) || (new_x >= max_x)) {
        display_blink();
        break;
      }
      if ((new_y < 0) || (new_y >= max_y)) {
        display_blink();
        break;
      }
      cursor_x = new_x;
      cursor_y = new_y;
      break;

    case 4: /* pick up status column */
      new_x = c - ' ';
      display_state = 0;
      if ((new_x < 0) || (new_x >= max_x)) {
        display_blink();
        new_x = 0;
      }
      display_status = new_x + 1;
      break;

  }

  /* restore cursor at new position */
  display_char(cursor_x, cursor_y, -1);

} /* display() */

/* append string, advance pointer */
static append_string(register char **p, register char *b)
{
  while (*b) *(*p)++ = *b++;
}

/* append number, advance pointer */
static append_number(char **p, register int n)
{
  char buffer[30];
  register char *b = &buffer[sizeof(buffer) - 1];

  *(b--) = 0;
  do {
    *b-- = '0' + n % 10;
    n /= 10;
  } while (n != 0);
  b++;
  append_string(p, b);
}

/* setup display parameters, compose termcap string */
void display_init(unsigned int *buffer, int height, int width, int rowsize)
{
  register unsigned int *b, *end;
  char *p;

#ifdef DEBUG
  printf("display_init(0x%X, %d, %d, %d)\n\r",
    buffer, height, width, rowsize);
#endif
  b = buffer;
  end = &buffer[height * rowsize];
  while (b != end) *b++ = -1;
  display_buffer = buffer;
  display_height = height;
  display_width = width;
  display_rowsize = rowsize;
  max_x = width / font_width;
  display_offset = (width - (max_x * font_width)) / 2;
  if (display_offset < 2) {
    max_x--;
    display_offset = (width - (max_x * font_width)) / 2;
  }
  max_y = (height / font_height) - 1;
#ifdef DEBUG
  printf("strlen(termcap) = %d\n\r", strlen(termcap));
#endif
  p = display_termcap;
  *p = 0;
  append_string(&p, termcap);
  append_string(&p, "co#"); append_number(&p, max_x);
  append_string(&p, ":li#"); append_number(&p, max_y);
  append_string(&p, ":ws#"); append_number(&p, max_x);
  append_string(&p, ":");
  *p = 0;
#ifdef DEBUG
  printf("strlen(display_termcap) = %d\n\r", strlen(display_termcap));
#endif
  display_mode = display_state = display_status = display_status_mode = 0;
  cursor_x = cursor_y = 0;
  display_ceod(0, 0);
  display_ceol(0, max_y);

} /* display_init() */

#ifdef KERNEL

/* current column for xprintf() */
static int xprintf_x;

/* putc used by xprintf() */
static xprintf_putc(register char c)
{
  if (xprintf_x < max_x) display_char(xprintf_x++, max_y, c & 127);
}

/* xprintf() is a fast, protected "printf" to the status line */
/* Both xprintf() and printf() will not work properly if the console
 * video device parameters have been changed.
 */
/*VARARGS*/
xprintf(fmt, va_alist)
char *fmt;
va_dcl
{
  int s, saved_status, saved_status_mode;

  va_list listp;
  va_start(listp);
  s = spl7();
  saved_status = display_status;
  display_status = 1;
  saved_status_mode = display_status_mode;
  display_status_mode = 0;
  xprintf_x = 0;
  display_ceol(0, max_y);
  _doprnt(fmt, &listp, xprintf_putc, 16);
  display_status_mode = saved_status_mode;
  display_status = saved_status;
  splx(s);
  va_end(listp);
}

/* Called by console output activity at IPL0 to do actual output. */
static console_output(register struct tty *tp)
{
  register int c, s;
  register char *t;
  extern int ttrstrt();

  for (;;) {
    s = spl7();
    if ((tp->t_state&TS_TTSTOP) || (tp->t_outq.c_cc == 0)) break;
    c = getc(&tp->t_outq);
    if (c <= 127 || tp->t_flags & LITOUT) {
      if (c != ('F' - '@')) display(c);
      else { /* ^F, answerback with termcap entry */
        for (t = display_termcap; *t; t++) ttyinput(*t, &console_tty);
        ttyinput('M' - '@', &console_tty);
      }
    }
    else {
      timeout(ttrstrt, (caddr_t)tp, (c & 127));
      tp->t_state |= TS_TIMEOUT;
      break;
    }
    splx(s);
  }
  tp->t_state &= ~TS_BUSY;
  if (tp->t_outq.c_cc <= TTLOWAT(tp)) tt_write_wakeup(tp);
  splx(s);
}

static console_repeat(unsigned char key_char, int list, struct act *act)
{
  if (key_data.repeat_code == 0) return;
  ttyinput(key_char, &console_tty);
  runact(list, act, key_char, hz/20);
}

static console_key(unsigned char key_code)
{
  register unsigned long key_char;

  switch (key_code) {
    case 0x36:
      key_data.modflags |= KEY_MOD_CTRL;  break;
    case 0xb6:
      key_data.modflags &= ~KEY_MOD_CTRL; break;
    case 0x3a:
      key_data.modflags |= KEY_MOD_OPT;   break;
    case 0xba:
      key_data.modflags &= ~KEY_MOD_OPT;  break;
    case 0x39:
      key_data.modflags |= KEY_MOD_CAPS;  break;
    case 0xb9:
      key_data.modflags &= ~KEY_MOD_CAPS; break;
    case 0x38:
      key_data.modflags |= KEY_MOD_SHFT;  break;
    case 0xb8:
      key_data.modflags &= ~KEY_MOD_SHFT; break;
    case 0x37:
      key_data.modflags |= KEY_MOD_CMD;   break;
    case 0xb7:
      key_data.modflags &= ~KEY_MOD_CMD;  break;
    case 0xff:
    case 0x7f:
      break;
    default:
      if (key_code & 0x80) {
        if (key_code == key_data.repeat_code) key_data.repeat_code = 0;
        break;
      }
      key_char = KeyTrans(key_data.transData,
        (key_data.modflags | key_code), &key_data.state);
      cancelact(key_data.key_act);
      key_data.repeat_code = (0x80 | key_code);
      if ((key_code & 127) == 0x33) key_char = 127;
      runact(KEY_CLOCK_LIST, key_data.key_act, key_char, hz/2);
      ttyinput(key_char, &console_tty);
      break;
  }
}

static console_input(adb_cmd_t cmd, unsigned char *data)
{
  if ((console_tty.t_state&TS_ISOPEN) && cmd.reg.cmd == ADB_talk
      && cmd.reg.reg == 0 && cmd.cmd.len == 2) {
    console_key(data[0]);
    console_key(data[1]);
  }
}

static console_start(tp)
register struct tty *tp;
{
  if (tp->t_state & (TS_TIMEOUT|TS_BUSY|TS_TTSTOP)) return;
  if (tp->t_outq.c_cc <= TTLOWAT(tp)) tt_write_wakeup(tp);
  if (tp->t_outq.c_cc == 0) return;
  tp->t_state |= TS_BUSY;
  softact(console_act, tp);
}

/* Reset the console device. */
/* This is called when by video_close() for the console video device and
 * by console_setstat() of TTY_SET_BREAK.
 */
void console_reset()
{
  int s;

  s = spl7();

  /* re-initialize the console video device */
  video_setup(&video[0]);

  /* restore the console display */
  display_init(display_buffer, display_height, display_width, display_rowsize);

  /* direct keyboard input back to the console */
  adb_close(ADB_ADDR_KEYBOARD);

  /* let user know that the console has been reset */
  xprintf("MacMach Console Reset %d x %d", max_x, max_y);

  splx(s);

} /* console_reset() */

io_return_t console_open(dev_t dev, int flag, io_req_t ior)
{
  register struct tty *tp;
  register io_return_t result;

  tp = &console_tty;
  tp->t_addr = 0;
  tp->t_oproc = console_start;
  tp->t_stop = nulldev;
  if ((tp->t_state&TS_ISOPEN) == 0) {
    if (Xadb_query(ADB_ADDR_KEYBOARD, -1, 0) != ADB_ADDR_KEYBOARD)
      return D_NO_SUCH_DEVICE;
    ttychars(tp);
    tp->t_flags = EVENP|ODDP|ECHO|XTABS|CRMOD;
    tp->t_ispeed = tp->t_ospeed = B9600;
    tp->t_state = TS_CARR_ON;
  }
  /* allocate console output activity if none exists. */
  if (console_act == 0) {
    console_act = (struct act *)makesoftact(console_output, SR_IPL0);
    if (console_act == 0) panic("console_open: allocate output act");
  }
  /* allocate key repeat activity if none exists. */
  if (key_data.key_act == 0) {
    key_data.key_act = (struct act *)makeact(console_repeat, SR_IPL1, 1);
    if (key_data.key_act == 0) panic("console_open: allocate repeat act");
    addact(KEY_CLOCK_LIST, key_data.key_act, &actclock);
  }
  if ((tp->t_state&TS_ISOPEN) == 0) {
    if (!Xadb_open(ADB_ADDR_KEYBOARD, console_input)) return (D_IO_ERROR);
  }
  result =  char_open(dev, tp, flag, ior);
  if (result != D_SUCCESS) {
    if ((tp->t_state&TS_ISOPEN) == 0) Xadb_close(ADB_ADDR_KEYBOARD);
    return result;
  }
  tp->t_state |= TS_ISOPEN;
  return D_SUCCESS;
}

void console_close(dev_t dev)
{
  Xadb_close(ADB_ADDR_KEYBOARD);
  cancelact(key_data.key_act);
  key_data.repeat_code = 0;
  key_data.modflags = 0;
  key_data.state = 0;
  ttyclose(&console_tty);
}

io_return_t console_read(dev_t dev, struct uio *uio)
{
  return char_read(&console_tty, uio);
}

io_return_t console_write(dev_t dev, struct uio *uio)
{
  return char_write(&console_tty, uio);
}

boolean_t console_portdeath(dev_t dev, mach_port_t port)
{
  return tty_portdeath(&console_tty, port);
}

io_return_t console_getstat
  (dev_t dev, int flavor, int *data, unsigned int *count)
{
  if (flavor == 245) {
  }
  else return tty_get_status(&console_tty, flavor, data, count);
}

io_return_t console_setstat
  (dev_t dev, int flavor, int *data, unsigned int count)
{
  if (flavor == TTY_SET_BREAK) {
    console_reset();
    return D_SUCCESS;
  }
  else if (flavor == TTY_CLEAR_BREAK) return D_SUCCESS;
  return tty_set_status(&console_tty, flavor, data, count);
}

/* There is nothing to force. */
cons_force()
{
}

/* There is no kernel console input. */
cngetc()
{
  panic("cngetc");
}

/* Used by the kernel printf() to output characters. */
cnputc(register char c)
{
  int s;

  s = spl7();
  if (c == '\n') display('\r');
  display(c);
  splx(s);
}

/* Initialize console device so that kernel printfs work. */
console_printf_init()
{
  VPBlock v;

  if (video_cons_find(&v) == TRUE) {
    display_init((unsigned int *)(video[0].video_devbase + v.vpBaseOffset),
                  v.vpBounds.bottom - v.vpBounds.top,
                  v.vpBounds.right - v.vpBounds.left,
                  v.vpRowBytes / sizeof(int));
  }
  /* Load key translation resource. */
  if (key_data.transData == 0) {
    Handle h = (Handle)GetResource(*(unsigned long *)"KCHR", 0);
    if (h) {
      DetachResource(h);
      HLock(h);
      key_data.transData = (unsigned)*h;
    }
  }
  xprintf("MacMach Console %d x %d", max_x, max_y);
}

#endif

#ifndef KERNEL

#define oops(expr) ((void)((expr) ? (_oops(#expr, __LINE__, __FILE__), 0) : 0))

_oops(char *expr, int line, char *file)
{
  printf("oops: %s(%d): %s\n\r", file, line, expr);
  exit(1);
}

main(int argc, char **argv)
{
  int i, n, kbd, pty, tty, pid, f, size, pagesize, on = 1;
  char pty_name[11], tty_name[11], chars[128];
  struct sgttyb sgttyb, saved_sgttyb;
  VPBlock info;
  VDPageInfo vpinfo;
  unsigned char *buffer;
  struct winsize win = { 0, 0, 0, 0 };
  extern char *malloc();
  extern int getpagesize();

  if ((argc > 1) && !strcmp(argv[1], "exit")) {
    printf("%c", 'C' - '@');
    exit(0);
  }
  else if ((argc > 1) && (*(argv[1]) != '/')) {
    printf("%c", 'A' - '@');
    for (i = 1; i < argc; i++) printf("%s%s", (i == 1) ? "" : " ", argv[i]);
    printf("%c", 'B' - '@');
    exit(0);
  }
  pagesize = getpagesize();
  oops((f = open((argc > 1) ? argv[1] : "/dev/scn0", O_RDWR)) == -1);
  oops(ioctl(f, VIDEO_CTRL_Init, &vpinfo) < 0);
  oops(ioctl(f, VIDEO_PARAMS, &info) < 0);
  size = info.vpBaseOffset +
    (info.vpRowBytes * (info.vpBounds.bottom - info.vpBounds.top));
  oops(!(buffer = (unsigned char *)malloc(size + pagesize)));
  buffer = (unsigned char *)(((int)buffer / pagesize + 1) * pagesize);
  oops(mmap(buffer, size, PROT_READ | PROT_WRITE, MAP_SHARED, f, 0) < 0);
  oops(((unsigned)buffer + info.vpBaseOffset) & 3);
  display_init((unsigned int *)&buffer[info.vpBaseOffset],
                info.vpBounds.bottom - info.vpBounds.top,
                info.vpBounds.right - info.vpBounds.left,
                info.vpRowBytes / sizeof(int));
  oops((kbd = open("/dev/tty", O_RDWR)) < 0);
  for (i = 0; i < 16; i++) {
    sprintf(pty_name, "/dev/ptyp%c", "0123456789abcdef"[i]);
    if ((pty = open(pty_name, O_RDWR)) >= 0) break;
  }
  oops(pty < 0);
  oops(ioctl(pty, TIOCSWINSZ, &win));
  oops(ioctl(pty, FIONBIO, &on));
  (void)sprintf(tty_name, "/dev/ttyp%c", pty_name[9]);
  oops((tty = open(tty_name, O_RDWR)) < 0);
  oops(ioctl(kbd, TIOCGETP, &sgttyb));
  bcopy(&sgttyb, &saved_sgttyb, sizeof(sgttyb));
  oops(ioctl(tty, TIOCSETP, &sgttyb));
  oops((pid = fork()) < 0);
  if (pid == 0) {
    char *envp[3];
    close(pty);
    dup2(tty, 0);
    dup2(tty, 1);
    dup2(tty, 2);
    close(tty);
    envp[0] = "PATH=/bin:/usr/bin:/usr/ucb";
    envp[1] = "TERM=mac2";
    envp[2] = malloc(sizeof(display_termcap) + 8);
    sprintf(envp[2], "TERMCAP=%s", display_termcap);
    envp[3] = 0;
    execle("/bin/sh", "sh", 0, envp);
    oops("/bin/sh");
  }
  close(tty);
  oops(signal(SIGTSTP, SIG_IGN));
  oops(signal(SIGTTOU, SIG_IGN));
  oops(ioctl(kbd, TIOCGETP, &sgttyb));
  sgttyb.sg_flags |= RAW;
  sgttyb.sg_flags |= CBREAK;
  sgttyb.sg_flags &= ~ECHO;
  sgttyb.sg_flags &= ~XTABS;
  oops(ioctl(kbd, TIOCSETP, &sgttyb));
  oops(ioctl(kbd, FIONBIO, &on));
  for (;;) {
    /* should use select() here... */
    if ((n = read(kbd, chars, sizeof(chars))) > 0) write(pty, chars, n);
    if ((n = read(pty, chars, sizeof(chars))) > 0) {
      for (i = 0; i < n; i++) {
        if (chars[i] == ('C' - '@')) {
          (void)ioctl(kbd, TIOCSETP, &saved_sgttyb);
          exit(0);
        }
        else if (chars[i] != ('F' - '@')) display(chars[i]);
        else { /* ^F, answerback with termcap entry */
          write(pty, display_termcap, strlen(display_termcap));
          chars[i] = ('M' - '@');
          write(pty, &chars[i], 1);
        }
      }
    }
  }
}

#endif
