.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)write.2	6.5 (Berkeley) 5/14/86
.\"
.TH WRITE 2 "May 14, 1986"
.UC 4
.SH NAME
write, writev \- write output
.SH SYNOPSIS
.nf
.ft B
cc = write(d, buf, nbytes)
int cc, d;
char *buf;
int nbytes;
.PP
.ft B
#include <sys/types.h>
#include <sys/uio.h>
.PP
.ft B
cc = writev(d, iov, iovcnt)
int cc, d;
struct iovec *iov;
int iovcnt;
.fi
.SH DESCRIPTION
.I Write
attempts to write
.I nbytes
of data to the object referenced by the descriptor
.I d
from the buffer pointed to by
.IR buf .
.I Writev
performs the same action, but gathers the output data
from the 
.I iovcnt
buffers specified by the members of the
.I iov
array: iov[0], iov[1], ..., iov[iovcnt\|\-\|1].
.PP
For 
.IR writev ,
the 
.I iovec
structure is defined as
.PP
.nf
.RS
.DT
struct iovec {
	caddr_t	iov_base;
	int	iov_len;
};
.RE
.fi
.PP
Each 
.I iovec
entry specifies the base address and length of an area
in memory from which data should be written.
.I Writev
will always write a complete area before proceeding
to the next.
.PP
On objects capable of seeking, the \fIwrite\fP starts at a position
given by the pointer associated with
.IR d ,
see
.IR lseek (2).
Upon return from
.IR write ,
the pointer is incremented by the number of bytes actually written.
.PP
Objects that are not capable of seeking always write from the current
position.  The value of the pointer associated with such an object
is undefined.
.PP
If the real user is not the super-user, then
.I write
clears the set-user-id bit on a file.
This prevents penetration of system security
by a user who
\*(lqcaptures\*(rq a writable set-user-id file
owned by the super-user.
.PP
When using non-blocking I/O on objects such as sockets that are subject
to flow control,
.I write
and
.I writev
may write fewer bytes than requested;
the return value must be noted,
and the remainder of the operation should be retried when possible.
.SH "RETURN VALUE
Upon successful completion the number of bytes actually written
is returned.  Otherwise a \-1 is returned and the global variable
.I errno
is set to indicate the error.
.SH ERRORS
.I Write
and
.I writev
will fail and the file pointer will remain unchanged if one or more
of the following are true:
.TP 15
[EBADF]
\fID\fP is not a valid descriptor open for writing.
.TP 15
[EPIPE]
An attempt is made to write to a pipe that is not open
for reading by any process.
.TP 15
[EPIPE]
An attempt is made to write to a socket of type SOCK_STREAM
that is not connected to a peer socket.
.TP 15
[EFBIG]
An attempt was made to write a file that exceeds the process's
file size limit or the maximum file size.
.TP 15
[EFAULT]
Part of \fIiov\fP or data to be written to the file
points outside the process's allocated address space.
.TP 15
[EINVAL]
The pointer associated with
.I d
was negative.
.TP 15
[ENOSPC]
There is no free space remaining on the file system
containing the file.
.TP 15
[EDQUOT]
The user's quota of disk blocks on the file system
containing the file has been exhausted.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file system.
.TP 15
[EWOULDBLOCK]
The file was marked for non-blocking I/O,
and no data could be written immediately.
.PP
In addition, 
.I writev
may return one of the following errors:
.TP 15
[EINVAL]
.I Iovcnt
was less than or equal to 0, or greater than 16.
.TP 15
[EINVAL]
One of the
.I iov_len
values in the
.I iov
array was negative.
.TP 15
[EINVAL]
The sum of the
.I iov_len
values in the
.I iov
array overflowed a 32-bit integer.
.SH "SEE ALSO"
fcntl(2), lseek(2), open(2), pipe(2), select(2)
