/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **********************************************************************
 * HISTORY
 *
 * 21-Nov-88  Zon Williamson (zon) at Carnegie-Mellon University
 *      Created this version for MacMach.
 *
 **********************************************************************
 */

#if defined(SYSLIBC_SCCS)
	.asciz "@(#)wait3.s MacMach 5.1 (from Berkeley 5.5)"
	.even
#endif /* SYSLIBC_SCCS and not lint */

#include "SYS.h"

#define SYS_wait3 SYS_wait

/*
SYSCALL(wait3)
	rts
*/

ENTRY(wait3) /* pid = wait3(status, options, rusage) */
	movl	sp@(8),d0
	movl	sp@(12),d1
	movl	#SYS_wait3,sp@-
	orb	#0x1f,cc
	trap	#0
	bcc 	noerror
	jmp 	cerror
noerror:
	tstl	sp@(4)
	beqs	skip
	movl	sp@(4),a0
	movl	d1,a0@
skip:
	rts

