.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)vfork.2	6.2 (Berkeley) 6/30/85
.\"
.TH VFORK 2 "June 30, 1985"
.UC 4
.SH NAME
vfork \- spawn new process in a virtual memory efficient way
.SH SYNOPSIS
.B pid = vfork()
.br
.B int pid;
.SH DESCRIPTION
.I Vfork
can be used to create new processes without fully copying the address
space of the old process, which is horrendously inefficient in a paged
environment.  It is useful when the purpose of
.IR fork (2)
would have been to create a new system context for an
.IR execve .
.I Vfork
differs from
.I fork
in that the child borrows the parent's memory and thread of
control until a call to
.IR execve (2)
or an exit (either by a call to
.IR exit (2)
or abnormally.)
The parent process is suspended while the child is using its resources.
.PP
.I Vfork
returns 0 in the child's context and (later) the pid of the child in
the parent's context.
.PP
.I Vfork
can normally be used just like
.I fork.
It does not work, however, to return while running in the childs context
from the procedure that called
.I vfork
since the eventual return from
.I vfork
would then return to a no longer existent stack frame.
Be careful, also, to call
.I _exit
rather than
.I exit
if you can't
.IR execve ,
since
.I exit
will flush and close standard I/O channels, and thereby mess up the
parent processes standard I/O data structures.
(Even with
.I fork
it is wrong to call
.I exit
since buffered data would then be flushed twice.)
.SH SEE ALSO
fork(2), execve(2), sigvec(2), wait(2),
.SH DIAGNOSTICS
Same as for
.IR fork .
.SH BUGS
This system call will be eliminated when proper system sharing
mechanisms are implemented. 
Users should not depend on the memory
sharing semantics of
.I vfork
as it will, in that case, be made synonymous to
.IR fork .
.PP
To avoid a possible deadlock situation,
processes that are children in the middle
of a
.I vfork
are never sent SIGTTOU or SIGTTIN signals; rather,
output or
.IR ioctl s
are allowed
and input attempts result in an end-of-file indication.
