.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)umask.2	6.1 (Berkeley) 5/9/85
.\"
.TH UMASK 2 "May 9, 1985"
.UC 4
.SH NAME
umask \- set file creation mode mask
.SH SYNOPSIS
.ft B
oumask = umask(numask)
.br
int oumask, numask;
.ft R
.SH DESCRIPTION
.I Umask
sets the process's file mode creation mask to \fInumask\fP
and returns the previous value of the mask.  The low-order
9 bits of \fInumask\fP are used whenever a file is created,
clearing corresponding bits in the file mode
(see
.IR chmod (2)).
This clearing allows each user to restrict the default access
to his files.
.PP
The value is initially 022 (write access for owner only).
The mask is inherited by child processes.
.SH "RETURN VALUE
The previous value of the file mode mask is returned by the call.
.SH SEE ALSO
chmod(2), mknod(2), open(2)
