.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)syscall.2	6.2 (Berkeley) 4/16/86
.\"
.TH SYSCALL 2 "April 16, 1986"
.UC 4
.SH NAME
syscall \- indirect system call
.SH SYNOPSIS
.nf
.ft B
#include <syscall.h>
.PP
.BR "syscall(number, arg, ...)" \  \  (VAX-11)
.fi
.SH DESCRIPTION
.I Syscall
performs the system call whose assembly language
interface has the specified
.I number,
register arguments
.I r0
and
.I r1
and further arguments
.IR arg .
Symbolic constants for system calls can be found in the header file
.I <syscall.h>.
.PP
The r0 value of the system call is returned.
.SH DIAGNOSTICS
When the C-bit is set,
.I syscall
returns \-1 and sets the
external variable 
.I errno
(see
.IR intro (2)).
.SH BUGS
There is no way to simulate system calls
such as
.IR pipe (2),
which return values in register r1.
