.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)symlink.2	6.3 (Berkeley) 8/26/85
.\"
.TH SYMLINK 2 "August 26, 1985"
.UC 5
.SH NAME
symlink \- make symbolic link to a file
.SH SYNOPSIS
.nf
.ft B
symlink(name1, name2)
char *name1, *name2;
.fi
.ft R
.SH DESCRIPTION
A symbolic link
.I name2
is created to
.IR name1
(\fIname2\fP is the name of the
file created, \fIname1\fP is the string
used in creating the symbolic link).
Either name may be an arbitrary path name; the files need not
be on the same file system.
.SH "RETURN VALUE
Upon successful completion, a zero value is returned.
If an error occurs, the error code is stored in \fIerrno\fP
and a \-1 value is returned.
.SH "ERRORS
The symbolic link is made unless on or more of the
following are true:
.TP 15
[ENOTDIR]
A component of the \fIname2\fP prefix is not a directory.
.TP 15
[EINVAL]
Either \fIname1\fP or \fIname2\fP
contains a character with the high-order bit set.
.TP 15
[ENAMETOOLONG]
A component of either pathname exceeded 255 characters,
or the entire length of either path name exceeded 1023 characters.
.TP 15
[ENOENT]
The named file does not exist.
.TP 15
[EACCES]
A component of the \fIname2\fP path prefix denies search permission.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating the pathname.
.TP 15
[EEXIST]
\fIName2\fP already exists.
.TP 15
[EIO]
An I/O error occurred while making the directory entry for \fIname2\fP,
or allocating the inode for \fIname2\fP,
or writing out the link contents of \fIname2\fP.
.TP 15
[EROFS]
The file \fIname2\fP would reside on a read-only file system.
.TP 15
[ENOSPC]
The directory in which the entry for the new symbolic link is being placed
cannot be extended because there is no space left on the file
system containing the directory.
.TP 15
[ENOSPC]
The new symbolic link cannot be created because there
there is no space left on the file
system that will contain the symbolic link.
.TP 15
[ENOSPC]
There are no free inodes on the file system on which the
symbolic link is being created.
.TP 15
[EDQUOT]
The directory in which the entry for the new symbolic link
is being placed cannot be extended because the
user's quota of disk blocks on the file system
containing the directory has been exhausted.
.TP 15
[EDQUOT]
The new symbolic link cannot be created because the user's
quota of disk blocks on the file system that will
contain the symbolic link has been exhausted.
.TP 15
[EDQUOT]
The user's quota of inodes on the file system on
which the symbolic link is being created has been exhausted.
.TP 15
[EIO]
An I/O error occurred while making the directory entry or allocating the inode.
.TP 15
[EFAULT]
.I Name1
or
.I name2
points outside the process's allocated address space.
.SH "SEE ALSO"
link(2), ln(1), unlink(2)
