.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)sigvec.2	6.3 (Berkeley) 1/8/86
.\"
.TH SIGVEC 2 "January 8, 1986"
.UC 4
.ie t .ds d \(dg
.el .ds d \z'|+'
.ie t .ds b \(bu
.el .ds b @
.SH NAME
sigvec \- software signal facilities
.SH SYNOPSIS
.nf
.B #include <signal.h>
.PP
.B struct sigvec {
.B	int	(*sv_handler)();
.B	int	sv_mask;
.B	int	sv_flags;
.B };
.PP
.B sigvec(sig, vec, ovec)
.B int sig;
.B struct sigvec *vec, *ovec;
.fi
.SH DESCRIPTION
The system defines a set of signals that may be delivered to a process.
Signal delivery resembles the occurence of a hardware interrupt:
the signal is blocked from further occurrence, the current process 
context is saved, and a new one is built.  A process may specify a
.I handler
to which a signal is delivered, or specify that a signal is to be 
.I blocked
or
.IR ignored .
A process may also specify that a default action is to be taken
by the system when a signal occurs.
Normally, signal handlers execute on the current stack
of the process.  This may be changed, on a per-handler basis,
so that signals are taken on a special
.IR "signal stack" .
.PP
All signals have the same
.IR priority .
Signal routines execute with the signal that caused their
invocation
.IR blocked ,
but other signals may yet occur.
A global 
.I "signal mask"
defines the set of signals currently blocked from delivery
to a process.  The signal mask for a process is initialized
from that of its parent (normally 0).  It
may be changed with a
.IR sigblock (2)
or
.IR sigsetmask (2)
call, or when a signal is delivered to the process.
.PP
When a signal
condition arises for a process, the signal is added to a set of
signals pending for the process.  If the signal is not currently
.I blocked
by the process then it is delivered to the process.  When a signal
is delivered, the current state of the process is saved,
a new signal mask is calculated (as described below), 
and the signal handler is invoked.  The call to the handler
is arranged so that if the signal handling routine returns
normally the process will resume execution in the context
from before the signal's delivery.
If the process wishes to resume in a different context, then it
must arrange to restore the previous context itself.
.PP
When a signal is delivered to a process a new signal mask is
installed for the duration of the process' signal handler
(or until a
.I sigblock
or
.I sigsetmask
call is made).
This mask is formed by taking the current signal mask,
adding the signal to be delivered, and 
.IR or 'ing
in the signal mask associated with the handler to be invoked.
.PP
.I Sigvec
assigns a handler for a specific signal.  If
.I vec
is non-zero, it
specifies a handler routine and mask
to be used when delivering the specified signal.
Further, if the SV_ONSTACK bit is set in
.I sv_flags,
the system will deliver the signal to the process on a
.IR "signal stack" ,
specified with
.IR sigstack (2).
If 
.I ovec
is non-zero, the previous handling information for the signal
is returned to the user.
.PP
The following is a list of all signals
with names as in the include file
.RI < signal.h >:
.LP
.nf
.ta \w'SIGVTALRM 'u +\w'15*  'u
SIGHUP	1	hangup
SIGINT	2	interrupt
SIGQUIT	3*	quit
SIGILL	4*	illegal instruction
SIGTRAP	5*	trace trap
SIGIOT	6*	IOT instruction
SIGEMT	7*	EMT instruction
SIGFPE	8*	floating point exception
SIGKILL	9	kill (cannot be caught, blocked, or ignored)
SIGBUS	10*	bus error
SIGSEGV	11*	segmentation violation
SIGSYS	12*	bad argument to system call
SIGPIPE	13	write on a pipe with no one to read it
SIGALRM	14	alarm clock
SIGTERM	15	software termination signal
SIGURG	16\*b	urgent condition present on socket
SIGSTOP	17\*d	stop (cannot be caught, blocked, or ignored)
SIGTSTP	18\*d	stop signal generated from keyboard
SIGCONT	19\*b	continue after stop (cannot be blocked)
SIGCHLD	20\*b	child status has changed
SIGTTIN	21\*d	background read attempted from control terminal
SIGTTOU	22\*d	background write attempted to control terminal
SIGIO	23\*b	i/o is possible on a descriptor (see \fIfcntl\fP(2))
SIGXCPU	24	cpu time limit exceeded (see \fIsetrlimit\fP(2))
SIGXFSZ	25	file size limit exceeded (see \fIsetrlimit\fP(2))
SIGVTALRM	26	virtual time alarm (see \fIsetitimer\fP(2))
SIGPROF	27	profiling timer alarm (see \fIsetitimer\fP(2))
SIGWINCH	28\*b	window size change
SIGUSR1	30	user defined signal 1
SIGUSR2	31	user defined signal 2
.fi
.PP
The starred signals in the list above cause a core image
if not caught or ignored.
.PP
Once a signal handler is installed, it remains installed
until another
.I sigvec
call is made, or an 
.IR execve (2)
is performed.
The default action for a signal may be reinstated by setting
.I sv_handler
to SIG_DFL; this default is termination
(with a core image for starred signals)
except for signals marked with \*b or \*d.
Signals marked with \*b are discarded if the action
is SIG_DFL; signals marked
with \*d cause the process to stop.
If
.I sv_handler
is SIG_IGN the signal is subsequently ignored,
and pending instances of the signal are discarded.
.PP
If a caught signal occurs during certain system calls,
the call is normally restarted.
The call can be forced to terminate prematurely with an
EINTR error return by setting the SV_INTERRUPT bit in
.I sv_flags.
The affected system calls are
.IR read (2)
or
.IR write (2)
on a slow device (such as a terminal; but not a file)
and during a
.IR wait (2).
.PP
After a
.IR fork (2)
or
.IR vfork (2)
the child inherits
all signals, the signal mask, the signal stack,
and the restart/interrupt flags.
.PP
.IR  Execve (2)
resets all
caught signals to default action and
resets all signals to be caught on the user stack.
Ignored signals remain ignored;
the signal mask remains the same;
signals that interrupt system calls continue to do so.
.SH NOTES
The mask specified in 
.I vec
is not allowed to block SIGKILL, SIGSTOP, or SIGCONT.  This
is done silently by the system.
.PP
The SV_INTERRUPT flag is not available in 4.2BSD,
hence it should not be used if backward compatibility is needed.
.SH "RETURN VALUE
A 0 value indicated that the call succeeded.  A \-1 return value
indicates an error occurred and
.I errno
is set to indicated the reason.
.SH ERRORS
.I Sigvec
will fail and no new signal handler will be installed if one
of the following occurs:
.TP 15
[EFAULT]
Either
.I vec
or 
.I ovec
points to memory that is not a valid part of the process
address space.
.TP 15
[EINVAL]
.I Sig
is not a valid signal number.
.TP 15
[EINVAL]
An attempt is made to ignore or supply a handler for SIGKILL
or SIGSTOP.
.TP 15
[EINVAL]
An attempt is made to ignore SIGCONT (by default SIGCONT
is ignored).
.SH "SEE ALSO"
kill(1),
ptrace(2), kill(2),
sigblock(2), sigsetmask(2), sigpause(2),
sigstack(2), sigvec(2), setjmp(3), siginterrupt(3), tty(4)
.SH "NOTES  (VAX-11)"
The handler routine can be declared:
.PP
    handler(sig, code, scp)
    int sig, code;
    struct sigcontext *scp;
.PP
Here
.I sig
is the signal number, into which the hardware faults and traps are
mapped as defined below. 
.I Code
is a parameter that is either a constant
as given below or, for compatibility mode faults, the code provided by
the hardware (Compatibility mode faults are distinguished from the
other SIGILL traps by having PSL_CM set in the psl).
.I Scp
is a pointer to the
.I sigcontext
structure (defined in
.RI < signal.h >),
used to restore the context from before the signal.
.PP
The following defines the mapping of hardware traps to signals
and codes.  All of these symbols are defined in
.RI < signal.h >:
.LP
.ta \w'     Floating/decimal divide by zero   'u +\w'15*  'u +8n
.nf
   Hardware condition	Signal	Code

Arithmetic traps:
   Integer overflow	SIGFPE	FPE_INTOVF_TRAP
   Integer division by zero	SIGFPE	FPE_INTDIV_TRAP
   Floating overflow trap	SIGFPE	FPE_FLTOVF_TRAP
   Floating/decimal division by zero	SIGFPE	FPE_FLTDIV_TRAP
   Floating underflow trap	SIGFPE	FPE_FLTUND_TRAP
   Decimal overflow trap	SIGFPE	FPE_DECOVF_TRAP
   Subscript-range	SIGFPE	FPE_SUBRNG_TRAP
   Floating overflow fault	SIGFPE	FPE_FLTOVF_FAULT
   Floating divide by zero fault	SIGFPE	FPE_FLTDIV_FAULT
   Floating underflow fault	SIGFPE	FPE_FLTUND_FAULT
Length access control	SIGSEGV
Protection violation	SIGBUS
Reserved instruction	SIGILL	ILL_RESAD_FAULT
Customer-reserved instr.	SIGEMT
Reserved operand	SIGILL	ILL_PRIVIN_FAULT
Reserved addressing	SIGILL	ILL_RESOP_FAULT
Trace pending	SIGTRAP
Bpt instruction	SIGTRAP
Compatibility-mode	SIGILL	hardware supplied code
Chme	SIGSEGV
Chms	SIGSEGV
Chmu	SIGSEGV
.fi
.SH BUGS
This manual page is still confusing.
