.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)shutdown.2	6.1 (Berkeley) 5/15/85
.\"
.TH SHUTDOWN 2 "May 15, 1985"
.UC 5
.SH NAME
shutdown \- shut down part of a full-duplex connection
.SH SYNOPSIS
.nf
.ft B
shutdown(s, how)
int s, how;
.fi
.SH DESCRIPTION
The
.I shutdown
call causes all or part of a full-duplex connection on
the socket associated with
.I s
to be shut down.
If \fIhow\fP is 0, then further receives will be disallowed.
If \fIhow\fP is 1, then further sends will be disallowed.
If \fIhow\fP is 2, then further sends and receives will be disallowed.
.SH DIAGNOSTICS
A 0 is returned if the call succeeds, \-1 if it fails.
.SH ERRORS
The call succeeds unless:
.TP 15
[EBADF]
.I S
is not a valid descriptor.
.TP 15
[ENOTSOCK]
.I S
is a file, not a socket.
.TP 15
[ENOTCONN]
The specified socket is not connected.
.SH "SEE ALSO"
connect(2), socket(2)
