.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)setquota.2	6.6 (Berkeley) 7/9/88
.\"
.TH SETQUOTA 2 "July 9, 1988"
.UC 5
.SH NAME
setquota \- enable/disable quotas on a file system
.SH SYNOPSIS
.nf
.B setquota(special, file)
.B char *special, *file;
.fi
.SH DESCRIPTION
Disc quotas are enabled or disabled with the
.I setquota
call.
.I Special
indicates a block special device on which a
mounted file system exists.
If
.I file
is nonzero, it specifies a file in that
file system from which to take the quotas.  If
.I file
is 0, then quotas are disabled on the file system.
The quota file must exist; it is normally created
with the 
.IR quotacheck (8)
program.
.PP
Only the super-user may turn quotas on or off.
.SH "SEE ALSO"
quota(2), quotacheck(8), quotaon(8)
.SH "RETURN VALUE"
A 0 return value indicates a successful call.  A value
of \-1 is returned when an error occurs and 
.I errno
is set to indicate the reason for failure.
.SH ERRORS
.I Setquota
will fail when one of the following occurs:
.TP 15
[ENOTDIR]
A component of either path prefix is not a directory.
.TP 15
[EINVAL]
Either pathname contains a character with the high-order bit set.
.TP 15
[EINVAL]
The kernel has not been compiled with the QUOTA option.
.TP 15
[ENAMETOOLONG]
A component of either pathname exceeded 255 characters,
or the entire length of either path name exceeded 1023 characters.
.TP 15
[ENODEV]
.I Special
does not exist.
.TP 15
[ENOENT]
.I File
does not exist.
.TP 15
[ELOOP]
Too many symbolic links were encountered in translating either pathname.
.TP 15
[EPERM]
The caller is not the super-user.
.TP 15
[ENOTBLK]
.I Special
is not a block device.
.TP 15
[ENXIO]
The major device number of 
.I special
is out of range (this indicates no device driver exists
for the associated hardware).
.TP 15
[EROFS]
.I File
resides on a read-only file system.
.TP 15
[EACCES]
Search permission is denied for a component of either path prefix.
.TP 15
[EACCES]
.I File
resides on a file system different from
.IR special .
.TP 15
[EACCES]
.I File
is not a plain file.
.TP 15
[EIO]
An I/O error occurred while reading from or writing to the file containing
the quotas.
.TP 15
[EFAULT]
.I Special
or \fIpath\fP points outside the process's allocated address space.
.SH BUGS
The error codes are in a state of disarray; too many errors
appear to the caller as one value.
