.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)setpgrp.2	6.1 (Berkeley) 5/9/85
.\"
.TH SETPGRP 2 "May 9, 1985"
.UC 4
.SH NAME
setpgrp \- set process group
.SH SYNOPSIS
.ft B
setpgrp(pid, pgrp)
.br
int pid, pgrp;
.ft R
.SH DESCRIPTION
.I Setpgrp
sets the process group of the specified process
.I pid
to the specified
.IR pgrp .
If
.I pid
is zero, then the call applies to the current process.
.PP
If the invoker is not the super-user, then the affected process
must have the same effective user-id as the invoker or be a descendant
of the invoking process.
.SH "RETURN VALUE
.I Setpgrp
returns when the operation was successful.  If
the request failed, \-1 is returned and the global
variable
.I errno
indicates the reason.
.SH ERRORS
.I Setpgrp
will fail and the process group will not be altered if
one of the following occur:
.TP 15
[ESRCH]
The requested process does not exist.
.TP 15
[EPERM]
The effective user ID of the requested process is different
from that of the caller and the process is not a descendent
of the calling process.
.SH "SEE ALSO"
getpgrp(2)
