.\" Copyright (c) 1980 Regents of the University of California.
.\" All rights reserved.  The Berkeley software License Agreement
.\" specifies the terms and conditions for redistribution.
.\"
.\"	@(#)reboot.2	6.1 (Berkeley) 5/9/85
.\"
.TH REBOOT 2 "May 9, 1985"
.UC 4
.SH NAME
reboot \- reboot system or halt processor
.SH SYNOPSIS
.nf
.B #include <sys/reboot.h>
.PP
.B reboot(howto)
.B int howto;
.fi
.SH DESCRIPTION
.I Reboot
reboots the system, and is invoked automatically
in the event of unrecoverable system failures.
.I Howto
is a mask of options passed to the bootstrap program.
The system call interface permits only RB_HALT or RB_AUTOBOOT
to be passed to the reboot program; the other flags
are used in scripts stored on the console storage media, or used
in manual bootstrap procedures.
When none of these options (e.g. RB_AUTOBOOT) is given, the system is rebooted
from file \*(lqvmunix\*(rq in the root file system of unit 0
of a disk chosen in a processor specific way.
An automatic consistency check of the disks is then normally performed.
.PP
The bits of
.I howto
are:
.TP
RB_HALT
the processor is simply halted; no reboot takes place.
RB_HALT should be used with caution.
.TP
RB_ASKNAME
Interpreted by the bootstrap program itself, causing it to
inquire as to what file should be booted.  Normally, the system is
booted from the file \*(lqxx(0,0)vmunix\*(rq without asking.
.TP
RB_SINGLE
Normally, the reboot procedure involves an automatic disk consistency
check and then multi-user operations.  RB_SINGLE prevents the consistency
check, rather simply booting the system with a single-user shell on
the console.
RB_SINGLE is interpreted by the
.IR init (8)
program in the newly booted system.
This switch is not available from the system call interface.
.PP
Only the super-user may
.I reboot
a machine.
.SH "RETURN VALUES"
If successful, this call never returns.  Otherwise, a \-1
is returned and an error is returned in the global variable
.IR errno .
.SH ERRORS
.TP 15
[EPERM]
The caller is not the super-user.
.SH "SEE ALSO"
crash(8), halt(8), init(8), reboot(8)
.SH BUGS
The notion of ``console medium'', among other things,
is specific to the VAX.
