.\" Copyright (c) 1983 Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms are permitted
.\" provided that the above copyright notice and this paragraph are
.\" duplicated in all such forms and that any documentation,
.\" advertising materials, and other materials related to such
.\" distribution and use acknowledge that the software was developed
.\" by the University of California, Berkeley.  The name of the
.\" University may not be used to endorse or promote products derived
.\" from this software without specific prior written permission.
.\" THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
.\" IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
.\" WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
.\"
.\"	@(#)quota.2	6.9 (Berkeley) 7/9/88
.\"
.TH QUOTA 2 "July 9, 1988"
.UC 5
.SH NAME
quota \- manipulate disk quotas
.SH SYNOPSIS
.nf
.B #include <sys/quota.h>
.PP
.B quota(cmd, uid, arg, addr)
.B int cmd, uid, arg;
.B char *addr;
.fi
.SH DESCRIPTION
The
.I quota
call manipulates disk quotas for file systems
that have had quotas enabled with
.IR setquota (2).
The
.I cmd
parameter indicates a command to be applied to
the user ID
.IR uid .
.I Arg
is a command specific argument and
.I addr
is the address of an optional, command specific, data structure
that is copied in or out of the system.  The interpretation of
.I arg
and
.I addr
is given with each command below.
.TP
Q_SETDLIM
Set disc quota limits and current usage for the user with ID
.IR uid .
.I Arg
is a major-minor device indicating a particular file system.
.I Addr
is a pointer to a struct dqblk structure (defined in 
.RI < sys/quota.h >).
This call is restricted to the super-user.
.TP
Q_GETDLIM
Get disc quota limits and current usage for the user with ID
.IR uid .
The remaining parameters are as for Q_SETDLIM.
.TP
Q_SETDUSE
Set disc usage limits for the user with ID
.IR uid .
.I Arg
is a major-minor device indicating a particular file system.
.I Addr
is a pointer to a struct dqusage structure (defined in
.RI < sys/quota.h >).
This call is restricted to the super-user.
.TP
Q_SYNC
Update the on-disc copy of quota usages.
.I Arg
is a major-minor device indicating the file system to be sync'ed.
If the
.I arg
parameter is specified as NODEV, all file systems that have
disc quotas will be sync'ed.
The \fIuid\fP and \fIaddr\fP parameters are ignored.
.TP
Q_SETUID
Change the calling process's quota limits to those of the
user with ID
.IR uid .
The 
.I arg
and
.I addr
parameters are ignored.  This call is restricted to the super-user.
.TP
Q_SETWARN
Alter the disc usage warning limits for the user with ID
.IR uid .
.I Arg
is a major-minor device indicating a particular file system.
.I Addr
is a pointer to a struct dqwarn structure (defined in
.RI < sys/quota.h >).
This call is restricted to the super-user.
.TP
Q_DOWARN
Warn the user with user ID
.I uid
about excessive disc usage.
This call causes the system to check its current disc usage
information and print a message on the terminal of
the caller for each file system on which the user is over quota.
If the user is under quota, his warning count is reset to MAX_*_WARN
(defined in
.RI < sys/quota.h >).
If the
.I arg
parameter is specified as NODEV, all file systems that have
disc quotas will be checked.  Otherwise, 
.I arg
indicates a specific major-minor device to be checked.
This call is restricted to the super-user.
.SH "RETURN VALUE"
A successful call returns 0,
otherwise the value \-1 is returned and the global variable
.I errno
indicates the reason for the failure.
.SH ERRORS
A \fIquota\fP call will fail when one of the following occurs:
.TP 15
[EINVAL]
The kernel has not been compiled with the QUOTA option.
.TP 15
[EINVAL]
.I Cmd
is invalid.
.TP 15
[ESRCH]
No disc quota is found for the indicated user.
.TP 15
[EPERM]
The call is priviledged and the caller was not the super-user.
.TP 15
[ENODEV]
The 
.I arg
parameter is being interpreted as a major-minor
device and it indicates an unmounted file system.
.TP 15
[EFAULT]
An invalid
.I addr
is supplied; the associated structure could not be copied in or out
of the kernel.
.TP 15
[EUSERS]
The quota table is full.
.SH "SEE ALSO"
setquota(2), quotaon(8), quotacheck(8)
.SH BUGS
There should be some way to integrate this call with the resource
limit interface provided by
.IR setrlimit (2)
and
.IR getrlimit (2).
.PP
The Australian spelling of
.I disk
is used throughout the quota facilities in honor of
the implementors.
